/*
 * Decompiled with CFR 0.152.
 */
package io.github.lcaohoanq.processor;

import io.github.lcaohoanq.annotations.BrowserLauncher;
import io.github.lcaohoanq.core.JavaBrowserLauncher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;

public class BrowserLauncherProcessor
implements ApplicationRunner {
    @Autowired
    private ApplicationContext applicationContext;

    public void run(ApplicationArguments args) {
        String mainClassName = null;
        try {
            String[] beanNames;
            for (String beanName : beanNames = this.applicationContext.getBeanNamesForType(Object.class)) {
                Object bean = this.applicationContext.getBean(beanName);
                Class<?> beanClass = bean.getClass();
                if (beanClass.getName().contains("$$")) {
                    beanClass = beanClass.getSuperclass();
                }
                if (beanClass.getAnnotation(SpringBootApplication.class) == null) continue;
                mainClassName = beanClass.getName();
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (mainClassName == null) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            mainClassName = Arrays.stream(stackTrace).filter(element -> "main".equals(element.getMethodName())).findFirst().map(StackTraceElement::getClassName).orElse(null);
        }
        if (mainClassName == null) {
            System.out.println("Could not find main class for browser launcher");
            return;
        }
        try {
            Class<?> mainClass = Class.forName(mainClassName);
            BrowserLauncher annotation = (BrowserLauncher)AnnotationUtils.findAnnotation(mainClass, BrowserLauncher.class);
            if (annotation != null) {
                String[] activeProfiles = System.getProperty("spring.profiles.active", "").split(",");
                boolean excluded = Arrays.stream(annotation.excludeProfiles()).anyMatch(p -> Arrays.asList(activeProfiles).contains(p));
                if (!excluded) {
                    ArrayList<String> urlList = new ArrayList<String>();
                    if (!annotation.value().isEmpty()) {
                        urlList.add(annotation.value());
                    } else if (!annotation.url().isEmpty()) {
                        urlList.add(annotation.url());
                    } else if (annotation.urls().length > 0) {
                        urlList.addAll(Arrays.asList(annotation.urls()));
                    }
                    if (urlList.isEmpty()) {
                        System.err.println("No URLs specified in @BrowserLauncher annotation");
                        return;
                    }
                    String[] urls = urlList.toArray(new String[0]);
                    String healthCheckEndpoint = annotation.healthCheckEndpoint();
                    List<String> urlsAsList = Arrays.asList(urls);
                    if (healthCheckEndpoint.isEmpty()) {
                        if (urls.length == 1) {
                            JavaBrowserLauncher.openHomePage(urls[0]);
                        } else {
                            JavaBrowserLauncher.openHomePage(urlsAsList);
                        }
                    } else if (annotation.async()) {
                        for (String url : urls) {
                            JavaBrowserLauncher.doHealthCheckThenOpenHomePageAsync(healthCheckEndpoint, url);
                        }
                    } else {
                        for (String url : urls) {
                            JavaBrowserLauncher.doHealthCheckThenOpenHomePage(healthCheckEndpoint, url);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error in browser launcher processor: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

