/*
 * Decompiled with CFR 0.152.
 */
package github.leavesczy.matisse;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.compose.runtime.Stable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J1\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0005H\u00c6\u0001J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0013\u0010\u001b\u001a\u00020\u00112\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0005H\u00d6\u0001J\u0016\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0012\u00a8\u0006%"}, d2={"Lgithub/leavesczy/matisse/MediaResource;", "Landroid/os/Parcelable;", "uri", "Landroid/net/Uri;", "path", "", "name", "mimeType", "<init>", "(Landroid/net/Uri;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getUri", "()Landroid/net/Uri;", "getPath", "()Ljava/lang/String;", "getName", "getMimeType", "isImage", "", "()Z", "isVideo", "component1", "component2", "component3", "component4", "copy", "describeContents", "", "equals", "other", "", "hashCode", "toString", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "matisse_release"})
@Stable
@Parcelize
public final class MediaResource
implements Parcelable {
    @NotNull
    private final Uri uri;
    @NotNull
    private final String path;
    @NotNull
    private final String name;
    @NotNull
    private final String mimeType;
    @NotNull
    public static final Parcelable.Creator<MediaResource> CREATOR;
    public static final int $stable;

    public MediaResource(@NotNull Uri uri, @NotNull String path, @NotNull String name, @NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        this.uri = uri;
        this.path = path;
        this.name = name;
        this.mimeType = mimeType;
    }

    @NotNull
    public final Uri getUri() {
        return this.uri;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getMimeType() {
        return this.mimeType;
    }

    public final boolean isImage() {
        return StringsKt.startsWith$default((String)this.mimeType, (String)"image/", (boolean)false, (int)2, null);
    }

    public final boolean isVideo() {
        return StringsKt.startsWith$default((String)this.mimeType, (String)"video/", (boolean)false, (int)2, null);
    }

    public final void writeToParcel(@NotNull Parcel dest, int flags) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        dest.writeParcelable((Parcelable)this.uri, flags);
        dest.writeString(this.path);
        dest.writeString(this.name);
        dest.writeString(this.mimeType);
    }

    public final int describeContents() {
        return 0;
    }

    @NotNull
    public final Uri component1() {
        return this.uri;
    }

    @NotNull
    public final String component2() {
        return this.path;
    }

    @NotNull
    public final String component3() {
        return this.name;
    }

    @NotNull
    public final String component4() {
        return this.mimeType;
    }

    @NotNull
    public final MediaResource copy(@NotNull Uri uri, @NotNull String path, @NotNull String name, @NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        return new MediaResource(uri, path, name, mimeType);
    }

    public static /* synthetic */ MediaResource copy$default(MediaResource mediaResource, Uri uri, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            uri = mediaResource.uri;
        }
        if ((n & 2) != 0) {
            string = mediaResource.path;
        }
        if ((n & 4) != 0) {
            string2 = mediaResource.name;
        }
        if ((n & 8) != 0) {
            string3 = mediaResource.mimeType;
        }
        return mediaResource.copy(uri, string, string2, string3);
    }

    @NotNull
    public String toString() {
        return "MediaResource(uri=" + this.uri + ", path=" + this.path + ", name=" + this.name + ", mimeType=" + this.mimeType + ")";
    }

    public int hashCode() {
        int result = this.uri.hashCode();
        result = result * 31 + this.path.hashCode();
        result = result * 31 + this.name.hashCode();
        result = result * 31 + this.mimeType.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaResource)) {
            return false;
        }
        MediaResource mediaResource = (MediaResource)other;
        if (!Intrinsics.areEqual((Object)this.uri, (Object)mediaResource.uri)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.path, (Object)mediaResource.path)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)mediaResource.name)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.mimeType, (Object)mediaResource.mimeType);
    }

    static {
        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<MediaResource> {
            public final MediaResource[] newArray(int size) {
                return new MediaResource[size];
            }

            public final MediaResource createFromParcel(Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                return new MediaResource((Uri)parcel.readParcelable(MediaResource.class.getClassLoader()), parcel.readString(), parcel.readString(), parcel.readString());
            }
        }
        CREATOR = new Creator();
    }
}

