package github.leavesczy.monitor.internal.db;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class MonitorDao_Impl implements MonitorDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<Monitor> __insertionAdapterOfMonitor;

  private final MonitorTypeConverter __monitorTypeConverter = new MonitorTypeConverter();

  private final EntityDeletionOrUpdateAdapter<Monitor> __updateAdapterOfMonitor;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

  public MonitorDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfMonitor = new EntityInsertionAdapter<Monitor>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `MonitorHttp` (`id`,`url`,`scheme`,`host`,`path`,`query`,`protocol`,`method`,`requestHeaders`,`requestBody`,`requestContentType`,`requestContentLength`,`requestDate`,`responseHeaders`,`responseBody`,`responseContentType`,`responseContentLength`,`responseDate`,`responseTlsVersion`,`responseCipherSuite`,`responseCode`,`responseMessage`,`error`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final Monitor entity) {
        statement.bindLong(1, entity.getId());
        statement.bindString(2, entity.getUrl());
        statement.bindString(3, entity.getScheme());
        statement.bindString(4, entity.getHost());
        statement.bindString(5, entity.getPath());
        statement.bindString(6, entity.getQuery());
        statement.bindString(7, entity.getProtocol());
        statement.bindString(8, entity.getMethod());
        final String _tmp = __monitorTypeConverter.toJson(entity.getRequestHeaders());
        statement.bindString(9, _tmp);
        if (entity.getRequestBody() == null) {
          statement.bindNull(10);
        } else {
          statement.bindString(10, entity.getRequestBody());
        }
        statement.bindString(11, entity.getRequestContentType());
        statement.bindLong(12, entity.getRequestContentLength());
        statement.bindLong(13, entity.getRequestDate());
        final String _tmp_1 = __monitorTypeConverter.toJson(entity.getResponseHeaders());
        statement.bindString(14, _tmp_1);
        if (entity.getResponseBody() == null) {
          statement.bindNull(15);
        } else {
          statement.bindString(15, entity.getResponseBody());
        }
        statement.bindString(16, entity.getResponseContentType());
        statement.bindLong(17, entity.getResponseContentLength());
        statement.bindLong(18, entity.getResponseDate());
        statement.bindString(19, entity.getResponseTlsVersion());
        statement.bindString(20, entity.getResponseCipherSuite());
        statement.bindLong(21, entity.getResponseCode());
        statement.bindString(22, entity.getResponseMessage());
        if (entity.getError() == null) {
          statement.bindNull(23);
        } else {
          statement.bindString(23, entity.getError());
        }
      }
    };
    this.__updateAdapterOfMonitor = new EntityDeletionOrUpdateAdapter<Monitor>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `MonitorHttp` SET `id` = ?,`url` = ?,`scheme` = ?,`host` = ?,`path` = ?,`query` = ?,`protocol` = ?,`method` = ?,`requestHeaders` = ?,`requestBody` = ?,`requestContentType` = ?,`requestContentLength` = ?,`requestDate` = ?,`responseHeaders` = ?,`responseBody` = ?,`responseContentType` = ?,`responseContentLength` = ?,`responseDate` = ?,`responseTlsVersion` = ?,`responseCipherSuite` = ?,`responseCode` = ?,`responseMessage` = ?,`error` = ? WHERE `id` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final Monitor entity) {
        statement.bindLong(1, entity.getId());
        statement.bindString(2, entity.getUrl());
        statement.bindString(3, entity.getScheme());
        statement.bindString(4, entity.getHost());
        statement.bindString(5, entity.getPath());
        statement.bindString(6, entity.getQuery());
        statement.bindString(7, entity.getProtocol());
        statement.bindString(8, entity.getMethod());
        final String _tmp = __monitorTypeConverter.toJson(entity.getRequestHeaders());
        statement.bindString(9, _tmp);
        if (entity.getRequestBody() == null) {
          statement.bindNull(10);
        } else {
          statement.bindString(10, entity.getRequestBody());
        }
        statement.bindString(11, entity.getRequestContentType());
        statement.bindLong(12, entity.getRequestContentLength());
        statement.bindLong(13, entity.getRequestDate());
        final String _tmp_1 = __monitorTypeConverter.toJson(entity.getResponseHeaders());
        statement.bindString(14, _tmp_1);
        if (entity.getResponseBody() == null) {
          statement.bindNull(15);
        } else {
          statement.bindString(15, entity.getResponseBody());
        }
        statement.bindString(16, entity.getResponseContentType());
        statement.bindLong(17, entity.getResponseContentLength());
        statement.bindLong(18, entity.getResponseDate());
        statement.bindString(19, entity.getResponseTlsVersion());
        statement.bindString(20, entity.getResponseCipherSuite());
        statement.bindLong(21, entity.getResponseCode());
        statement.bindString(22, entity.getResponseMessage());
        if (entity.getError() == null) {
          statement.bindNull(23);
        } else {
          statement.bindString(23, entity.getError());
        }
        statement.bindLong(24, entity.getId());
      }
    };
    this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "delete from MonitorHttp";
        return _query;
      }
    };
  }

  @Override
  public long insert(final Monitor monitor) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final long _result = __insertionAdapterOfMonitor.insertAndReturnId(monitor);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final Monitor monitor) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfMonitor.handle(monitor);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object deleteAll(final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAll.acquire();
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfDeleteAll.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object query(final long id, final Continuation<? super Monitor> $completion) {
    final String _sql = "select * from MonitorHttp where id =?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, id);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Monitor>() {
      @Override
      @NonNull
      public Monitor call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
          final int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "url");
          final int _cursorIndexOfScheme = CursorUtil.getColumnIndexOrThrow(_cursor, "scheme");
          final int _cursorIndexOfHost = CursorUtil.getColumnIndexOrThrow(_cursor, "host");
          final int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow(_cursor, "path");
          final int _cursorIndexOfQuery = CursorUtil.getColumnIndexOrThrow(_cursor, "query");
          final int _cursorIndexOfProtocol = CursorUtil.getColumnIndexOrThrow(_cursor, "protocol");
          final int _cursorIndexOfMethod = CursorUtil.getColumnIndexOrThrow(_cursor, "method");
          final int _cursorIndexOfRequestHeaders = CursorUtil.getColumnIndexOrThrow(_cursor, "requestHeaders");
          final int _cursorIndexOfRequestBody = CursorUtil.getColumnIndexOrThrow(_cursor, "requestBody");
          final int _cursorIndexOfRequestContentType = CursorUtil.getColumnIndexOrThrow(_cursor, "requestContentType");
          final int _cursorIndexOfRequestContentLength = CursorUtil.getColumnIndexOrThrow(_cursor, "requestContentLength");
          final int _cursorIndexOfRequestDate = CursorUtil.getColumnIndexOrThrow(_cursor, "requestDate");
          final int _cursorIndexOfResponseHeaders = CursorUtil.getColumnIndexOrThrow(_cursor, "responseHeaders");
          final int _cursorIndexOfResponseBody = CursorUtil.getColumnIndexOrThrow(_cursor, "responseBody");
          final int _cursorIndexOfResponseContentType = CursorUtil.getColumnIndexOrThrow(_cursor, "responseContentType");
          final int _cursorIndexOfResponseContentLength = CursorUtil.getColumnIndexOrThrow(_cursor, "responseContentLength");
          final int _cursorIndexOfResponseDate = CursorUtil.getColumnIndexOrThrow(_cursor, "responseDate");
          final int _cursorIndexOfResponseTlsVersion = CursorUtil.getColumnIndexOrThrow(_cursor, "responseTlsVersion");
          final int _cursorIndexOfResponseCipherSuite = CursorUtil.getColumnIndexOrThrow(_cursor, "responseCipherSuite");
          final int _cursorIndexOfResponseCode = CursorUtil.getColumnIndexOrThrow(_cursor, "responseCode");
          final int _cursorIndexOfResponseMessage = CursorUtil.getColumnIndexOrThrow(_cursor, "responseMessage");
          final int _cursorIndexOfError = CursorUtil.getColumnIndexOrThrow(_cursor, "error");
          final Monitor _result;
          if (_cursor.moveToFirst()) {
            final long _tmpId;
            _tmpId = _cursor.getLong(_cursorIndexOfId);
            final String _tmpUrl;
            _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
            final String _tmpScheme;
            _tmpScheme = _cursor.getString(_cursorIndexOfScheme);
            final String _tmpHost;
            _tmpHost = _cursor.getString(_cursorIndexOfHost);
            final String _tmpPath;
            _tmpPath = _cursor.getString(_cursorIndexOfPath);
            final String _tmpQuery;
            _tmpQuery = _cursor.getString(_cursorIndexOfQuery);
            final String _tmpProtocol;
            _tmpProtocol = _cursor.getString(_cursorIndexOfProtocol);
            final String _tmpMethod;
            _tmpMethod = _cursor.getString(_cursorIndexOfMethod);
            final List<MonitorPair> _tmpRequestHeaders;
            final String _tmp;
            _tmp = _cursor.getString(_cursorIndexOfRequestHeaders);
            _tmpRequestHeaders = __monitorTypeConverter.fromJsonArray(_tmp);
            final String _tmpRequestBody;
            if (_cursor.isNull(_cursorIndexOfRequestBody)) {
              _tmpRequestBody = null;
            } else {
              _tmpRequestBody = _cursor.getString(_cursorIndexOfRequestBody);
            }
            final String _tmpRequestContentType;
            _tmpRequestContentType = _cursor.getString(_cursorIndexOfRequestContentType);
            final long _tmpRequestContentLength;
            _tmpRequestContentLength = _cursor.getLong(_cursorIndexOfRequestContentLength);
            final long _tmpRequestDate;
            _tmpRequestDate = _cursor.getLong(_cursorIndexOfRequestDate);
            final List<MonitorPair> _tmpResponseHeaders;
            final String _tmp_1;
            _tmp_1 = _cursor.getString(_cursorIndexOfResponseHeaders);
            _tmpResponseHeaders = __monitorTypeConverter.fromJsonArray(_tmp_1);
            final String _tmpResponseBody;
            if (_cursor.isNull(_cursorIndexOfResponseBody)) {
              _tmpResponseBody = null;
            } else {
              _tmpResponseBody = _cursor.getString(_cursorIndexOfResponseBody);
            }
            final String _tmpResponseContentType;
            _tmpResponseContentType = _cursor.getString(_cursorIndexOfResponseContentType);
            final long _tmpResponseContentLength;
            _tmpResponseContentLength = _cursor.getLong(_cursorIndexOfResponseContentLength);
            final long _tmpResponseDate;
            _tmpResponseDate = _cursor.getLong(_cursorIndexOfResponseDate);
            final String _tmpResponseTlsVersion;
            _tmpResponseTlsVersion = _cursor.getString(_cursorIndexOfResponseTlsVersion);
            final String _tmpResponseCipherSuite;
            _tmpResponseCipherSuite = _cursor.getString(_cursorIndexOfResponseCipherSuite);
            final int _tmpResponseCode;
            _tmpResponseCode = _cursor.getInt(_cursorIndexOfResponseCode);
            final String _tmpResponseMessage;
            _tmpResponseMessage = _cursor.getString(_cursorIndexOfResponseMessage);
            final String _tmpError;
            if (_cursor.isNull(_cursorIndexOfError)) {
              _tmpError = null;
            } else {
              _tmpError = _cursor.getString(_cursorIndexOfError);
            }
            _result = new Monitor(_tmpId,_tmpUrl,_tmpScheme,_tmpHost,_tmpPath,_tmpQuery,_tmpProtocol,_tmpMethod,_tmpRequestHeaders,_tmpRequestBody,_tmpRequestContentType,_tmpRequestContentLength,_tmpRequestDate,_tmpResponseHeaders,_tmpResponseBody,_tmpResponseContentType,_tmpResponseContentLength,_tmpResponseDate,_tmpResponseTlsVersion,_tmpResponseCipherSuite,_tmpResponseCode,_tmpResponseMessage,_tmpError);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<Monitor> queryFlow(final long id) {
    final String _sql = "select * from MonitorHttp where id =?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, id);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"MonitorHttp"}, new Callable<Monitor>() {
      @Override
      @NonNull
      public Monitor call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
          final int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "url");
          final int _cursorIndexOfScheme = CursorUtil.getColumnIndexOrThrow(_cursor, "scheme");
          final int _cursorIndexOfHost = CursorUtil.getColumnIndexOrThrow(_cursor, "host");
          final int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow(_cursor, "path");
          final int _cursorIndexOfQuery = CursorUtil.getColumnIndexOrThrow(_cursor, "query");
          final int _cursorIndexOfProtocol = CursorUtil.getColumnIndexOrThrow(_cursor, "protocol");
          final int _cursorIndexOfMethod = CursorUtil.getColumnIndexOrThrow(_cursor, "method");
          final int _cursorIndexOfRequestHeaders = CursorUtil.getColumnIndexOrThrow(_cursor, "requestHeaders");
          final int _cursorIndexOfRequestBody = CursorUtil.getColumnIndexOrThrow(_cursor, "requestBody");
          final int _cursorIndexOfRequestContentType = CursorUtil.getColumnIndexOrThrow(_cursor, "requestContentType");
          final int _cursorIndexOfRequestContentLength = CursorUtil.getColumnIndexOrThrow(_cursor, "requestContentLength");
          final int _cursorIndexOfRequestDate = CursorUtil.getColumnIndexOrThrow(_cursor, "requestDate");
          final int _cursorIndexOfResponseHeaders = CursorUtil.getColumnIndexOrThrow(_cursor, "responseHeaders");
          final int _cursorIndexOfResponseBody = CursorUtil.getColumnIndexOrThrow(_cursor, "responseBody");
          final int _cursorIndexOfResponseContentType = CursorUtil.getColumnIndexOrThrow(_cursor, "responseContentType");
          final int _cursorIndexOfResponseContentLength = CursorUtil.getColumnIndexOrThrow(_cursor, "responseContentLength");
          final int _cursorIndexOfResponseDate = CursorUtil.getColumnIndexOrThrow(_cursor, "responseDate");
          final int _cursorIndexOfResponseTlsVersion = CursorUtil.getColumnIndexOrThrow(_cursor, "responseTlsVersion");
          final int _cursorIndexOfResponseCipherSuite = CursorUtil.getColumnIndexOrThrow(_cursor, "responseCipherSuite");
          final int _cursorIndexOfResponseCode = CursorUtil.getColumnIndexOrThrow(_cursor, "responseCode");
          final int _cursorIndexOfResponseMessage = CursorUtil.getColumnIndexOrThrow(_cursor, "responseMessage");
          final int _cursorIndexOfError = CursorUtil.getColumnIndexOrThrow(_cursor, "error");
          final Monitor _result;
          if (_cursor.moveToFirst()) {
            final long _tmpId;
            _tmpId = _cursor.getLong(_cursorIndexOfId);
            final String _tmpUrl;
            _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
            final String _tmpScheme;
            _tmpScheme = _cursor.getString(_cursorIndexOfScheme);
            final String _tmpHost;
            _tmpHost = _cursor.getString(_cursorIndexOfHost);
            final String _tmpPath;
            _tmpPath = _cursor.getString(_cursorIndexOfPath);
            final String _tmpQuery;
            _tmpQuery = _cursor.getString(_cursorIndexOfQuery);
            final String _tmpProtocol;
            _tmpProtocol = _cursor.getString(_cursorIndexOfProtocol);
            final String _tmpMethod;
            _tmpMethod = _cursor.getString(_cursorIndexOfMethod);
            final List<MonitorPair> _tmpRequestHeaders;
            final String _tmp;
            _tmp = _cursor.getString(_cursorIndexOfRequestHeaders);
            _tmpRequestHeaders = __monitorTypeConverter.fromJsonArray(_tmp);
            final String _tmpRequestBody;
            if (_cursor.isNull(_cursorIndexOfRequestBody)) {
              _tmpRequestBody = null;
            } else {
              _tmpRequestBody = _cursor.getString(_cursorIndexOfRequestBody);
            }
            final String _tmpRequestContentType;
            _tmpRequestContentType = _cursor.getString(_cursorIndexOfRequestContentType);
            final long _tmpRequestContentLength;
            _tmpRequestContentLength = _cursor.getLong(_cursorIndexOfRequestContentLength);
            final long _tmpRequestDate;
            _tmpRequestDate = _cursor.getLong(_cursorIndexOfRequestDate);
            final List<MonitorPair> _tmpResponseHeaders;
            final String _tmp_1;
            _tmp_1 = _cursor.getString(_cursorIndexOfResponseHeaders);
            _tmpResponseHeaders = __monitorTypeConverter.fromJsonArray(_tmp_1);
            final String _tmpResponseBody;
            if (_cursor.isNull(_cursorIndexOfResponseBody)) {
              _tmpResponseBody = null;
            } else {
              _tmpResponseBody = _cursor.getString(_cursorIndexOfResponseBody);
            }
            final String _tmpResponseContentType;
            _tmpResponseContentType = _cursor.getString(_cursorIndexOfResponseContentType);
            final long _tmpResponseContentLength;
            _tmpResponseContentLength = _cursor.getLong(_cursorIndexOfResponseContentLength);
            final long _tmpResponseDate;
            _tmpResponseDate = _cursor.getLong(_cursorIndexOfResponseDate);
            final String _tmpResponseTlsVersion;
            _tmpResponseTlsVersion = _cursor.getString(_cursorIndexOfResponseTlsVersion);
            final String _tmpResponseCipherSuite;
            _tmpResponseCipherSuite = _cursor.getString(_cursorIndexOfResponseCipherSuite);
            final int _tmpResponseCode;
            _tmpResponseCode = _cursor.getInt(_cursorIndexOfResponseCode);
            final String _tmpResponseMessage;
            _tmpResponseMessage = _cursor.getString(_cursorIndexOfResponseMessage);
            final String _tmpError;
            if (_cursor.isNull(_cursorIndexOfError)) {
              _tmpError = null;
            } else {
              _tmpError = _cursor.getString(_cursorIndexOfError);
            }
            _result = new Monitor(_tmpId,_tmpUrl,_tmpScheme,_tmpHost,_tmpPath,_tmpQuery,_tmpProtocol,_tmpMethod,_tmpRequestHeaders,_tmpRequestBody,_tmpRequestContentType,_tmpRequestContentLength,_tmpRequestDate,_tmpResponseHeaders,_tmpResponseBody,_tmpResponseContentType,_tmpResponseContentLength,_tmpResponseDate,_tmpResponseTlsVersion,_tmpResponseCipherSuite,_tmpResponseCode,_tmpResponseMessage,_tmpError);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Flow<List<Monitor>> queryFlow(final int limit) {
    final String _sql = "select * from MonitorHttp order by id desc limit ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, limit);
    return CoroutinesRoom.createFlow(__db, false, new String[] {"MonitorHttp"}, new Callable<List<Monitor>>() {
      @Override
      @NonNull
      public List<Monitor> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow(_cursor, "id");
          final int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "url");
          final int _cursorIndexOfScheme = CursorUtil.getColumnIndexOrThrow(_cursor, "scheme");
          final int _cursorIndexOfHost = CursorUtil.getColumnIndexOrThrow(_cursor, "host");
          final int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow(_cursor, "path");
          final int _cursorIndexOfQuery = CursorUtil.getColumnIndexOrThrow(_cursor, "query");
          final int _cursorIndexOfProtocol = CursorUtil.getColumnIndexOrThrow(_cursor, "protocol");
          final int _cursorIndexOfMethod = CursorUtil.getColumnIndexOrThrow(_cursor, "method");
          final int _cursorIndexOfRequestHeaders = CursorUtil.getColumnIndexOrThrow(_cursor, "requestHeaders");
          final int _cursorIndexOfRequestBody = CursorUtil.getColumnIndexOrThrow(_cursor, "requestBody");
          final int _cursorIndexOfRequestContentType = CursorUtil.getColumnIndexOrThrow(_cursor, "requestContentType");
          final int _cursorIndexOfRequestContentLength = CursorUtil.getColumnIndexOrThrow(_cursor, "requestContentLength");
          final int _cursorIndexOfRequestDate = CursorUtil.getColumnIndexOrThrow(_cursor, "requestDate");
          final int _cursorIndexOfResponseHeaders = CursorUtil.getColumnIndexOrThrow(_cursor, "responseHeaders");
          final int _cursorIndexOfResponseBody = CursorUtil.getColumnIndexOrThrow(_cursor, "responseBody");
          final int _cursorIndexOfResponseContentType = CursorUtil.getColumnIndexOrThrow(_cursor, "responseContentType");
          final int _cursorIndexOfResponseContentLength = CursorUtil.getColumnIndexOrThrow(_cursor, "responseContentLength");
          final int _cursorIndexOfResponseDate = CursorUtil.getColumnIndexOrThrow(_cursor, "responseDate");
          final int _cursorIndexOfResponseTlsVersion = CursorUtil.getColumnIndexOrThrow(_cursor, "responseTlsVersion");
          final int _cursorIndexOfResponseCipherSuite = CursorUtil.getColumnIndexOrThrow(_cursor, "responseCipherSuite");
          final int _cursorIndexOfResponseCode = CursorUtil.getColumnIndexOrThrow(_cursor, "responseCode");
          final int _cursorIndexOfResponseMessage = CursorUtil.getColumnIndexOrThrow(_cursor, "responseMessage");
          final int _cursorIndexOfError = CursorUtil.getColumnIndexOrThrow(_cursor, "error");
          final List<Monitor> _result = new ArrayList<Monitor>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final Monitor _item;
            final long _tmpId;
            _tmpId = _cursor.getLong(_cursorIndexOfId);
            final String _tmpUrl;
            _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
            final String _tmpScheme;
            _tmpScheme = _cursor.getString(_cursorIndexOfScheme);
            final String _tmpHost;
            _tmpHost = _cursor.getString(_cursorIndexOfHost);
            final String _tmpPath;
            _tmpPath = _cursor.getString(_cursorIndexOfPath);
            final String _tmpQuery;
            _tmpQuery = _cursor.getString(_cursorIndexOfQuery);
            final String _tmpProtocol;
            _tmpProtocol = _cursor.getString(_cursorIndexOfProtocol);
            final String _tmpMethod;
            _tmpMethod = _cursor.getString(_cursorIndexOfMethod);
            final List<MonitorPair> _tmpRequestHeaders;
            final String _tmp;
            _tmp = _cursor.getString(_cursorIndexOfRequestHeaders);
            _tmpRequestHeaders = __monitorTypeConverter.fromJsonArray(_tmp);
            final String _tmpRequestBody;
            if (_cursor.isNull(_cursorIndexOfRequestBody)) {
              _tmpRequestBody = null;
            } else {
              _tmpRequestBody = _cursor.getString(_cursorIndexOfRequestBody);
            }
            final String _tmpRequestContentType;
            _tmpRequestContentType = _cursor.getString(_cursorIndexOfRequestContentType);
            final long _tmpRequestContentLength;
            _tmpRequestContentLength = _cursor.getLong(_cursorIndexOfRequestContentLength);
            final long _tmpRequestDate;
            _tmpRequestDate = _cursor.getLong(_cursorIndexOfRequestDate);
            final List<MonitorPair> _tmpResponseHeaders;
            final String _tmp_1;
            _tmp_1 = _cursor.getString(_cursorIndexOfResponseHeaders);
            _tmpResponseHeaders = __monitorTypeConverter.fromJsonArray(_tmp_1);
            final String _tmpResponseBody;
            if (_cursor.isNull(_cursorIndexOfResponseBody)) {
              _tmpResponseBody = null;
            } else {
              _tmpResponseBody = _cursor.getString(_cursorIndexOfResponseBody);
            }
            final String _tmpResponseContentType;
            _tmpResponseContentType = _cursor.getString(_cursorIndexOfResponseContentType);
            final long _tmpResponseContentLength;
            _tmpResponseContentLength = _cursor.getLong(_cursorIndexOfResponseContentLength);
            final long _tmpResponseDate;
            _tmpResponseDate = _cursor.getLong(_cursorIndexOfResponseDate);
            final String _tmpResponseTlsVersion;
            _tmpResponseTlsVersion = _cursor.getString(_cursorIndexOfResponseTlsVersion);
            final String _tmpResponseCipherSuite;
            _tmpResponseCipherSuite = _cursor.getString(_cursorIndexOfResponseCipherSuite);
            final int _tmpResponseCode;
            _tmpResponseCode = _cursor.getInt(_cursorIndexOfResponseCode);
            final String _tmpResponseMessage;
            _tmpResponseMessage = _cursor.getString(_cursorIndexOfResponseMessage);
            final String _tmpError;
            if (_cursor.isNull(_cursorIndexOfError)) {
              _tmpError = null;
            } else {
              _tmpError = _cursor.getString(_cursorIndexOfError);
            }
            _item = new Monitor(_tmpId,_tmpUrl,_tmpScheme,_tmpHost,_tmpPath,_tmpQuery,_tmpProtocol,_tmpMethod,_tmpRequestHeaders,_tmpRequestBody,_tmpRequestContentType,_tmpRequestContentLength,_tmpRequestDate,_tmpResponseHeaders,_tmpResponseBody,_tmpResponseContentType,_tmpResponseContentLength,_tmpResponseDate,_tmpResponseTlsVersion,_tmpResponseCipherSuite,_tmpResponseCode,_tmpResponseMessage,_tmpError);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
