package github.leavesczy.monitor.internal.db;

import androidx.annotation.NonNull;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.migration.AutoMigrationSpec;
import androidx.room.migration.Migration;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Generated;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class MonitorDatabase_Impl extends MonitorDatabase {
  private volatile MonitorDao _monitorDao;

  @Override
  @NonNull
  protected SupportSQLiteOpenHelper createOpenHelper(@NonNull final DatabaseConfiguration config) {
    final SupportSQLiteOpenHelper.Callback _openCallback = new RoomOpenHelper(config, new RoomOpenHelper.Delegate(35) {
      @Override
      public void createAllTables(@NonNull final SupportSQLiteDatabase db) {
        db.execSQL("CREATE TABLE IF NOT EXISTS `MonitorHttp` (`id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `url` TEXT NOT NULL, `scheme` TEXT NOT NULL, `host` TEXT NOT NULL, `path` TEXT NOT NULL, `query` TEXT NOT NULL, `protocol` TEXT NOT NULL, `method` TEXT NOT NULL, `requestHeaders` TEXT NOT NULL, `requestBody` TEXT, `requestContentType` TEXT NOT NULL, `requestContentLength` INTEGER NOT NULL, `requestDate` INTEGER NOT NULL, `responseHeaders` TEXT NOT NULL, `responseBody` TEXT, `responseContentType` TEXT NOT NULL, `responseContentLength` INTEGER NOT NULL, `responseDate` INTEGER NOT NULL, `responseTlsVersion` TEXT NOT NULL, `responseCipherSuite` TEXT NOT NULL, `responseCode` INTEGER NOT NULL, `responseMessage` TEXT NOT NULL, `error` TEXT)");
        db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
        db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, '394157e88d91181878212d91a5178ad2')");
      }

      @Override
      public void dropAllTables(@NonNull final SupportSQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS `MonitorHttp`");
        final List<? extends RoomDatabase.Callback> _callbacks = mCallbacks;
        if (_callbacks != null) {
          for (RoomDatabase.Callback _callback : _callbacks) {
            _callback.onDestructiveMigration(db);
          }
        }
      }

      @Override
      public void onCreate(@NonNull final SupportSQLiteDatabase db) {
        final List<? extends RoomDatabase.Callback> _callbacks = mCallbacks;
        if (_callbacks != null) {
          for (RoomDatabase.Callback _callback : _callbacks) {
            _callback.onCreate(db);
          }
        }
      }

      @Override
      public void onOpen(@NonNull final SupportSQLiteDatabase db) {
        mDatabase = db;
        internalInitInvalidationTracker(db);
        final List<? extends RoomDatabase.Callback> _callbacks = mCallbacks;
        if (_callbacks != null) {
          for (RoomDatabase.Callback _callback : _callbacks) {
            _callback.onOpen(db);
          }
        }
      }

      @Override
      public void onPreMigrate(@NonNull final SupportSQLiteDatabase db) {
        DBUtil.dropFtsSyncTriggers(db);
      }

      @Override
      public void onPostMigrate(@NonNull final SupportSQLiteDatabase db) {
      }

      @Override
      @NonNull
      public RoomOpenHelper.ValidationResult onValidateSchema(
          @NonNull final SupportSQLiteDatabase db) {
        final HashMap<String, TableInfo.Column> _columnsMonitorHttp = new HashMap<String, TableInfo.Column>(23);
        _columnsMonitorHttp.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMonitorHttp.put("url", new TableInfo.Column("url", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMonitorHttp.put("scheme", new TableInfo.Column("scheme", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMonitorHttp.put("host", new TableInfo.Column("host", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMonitorHttp.put("path", new TableInfo.Column("path", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMonitorHttp.put("query", new TableInfo.Column("query", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMonitorHttp.put("protocol", new TableInfo.Column("protocol", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMonitorHttp.put("method", new TableInfo.Column("method", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMonitorHttp.put("requestHeaders", new TableInfo.Column("requestHeaders", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMonitorHttp.put("requestBody", new TableInfo.Column("requestBody", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMonitorHttp.put("requestContentType", new TableInfo.Column("requestContentType", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMonitorHttp.put("requestContentLength", new TableInfo.Column("requestContentLength", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMonitorHttp.put("requestDate", new TableInfo.Column("requestDate", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMonitorHttp.put("responseHeaders", new TableInfo.Column("responseHeaders", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMonitorHttp.put("responseBody", new TableInfo.Column("responseBody", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMonitorHttp.put("responseContentType", new TableInfo.Column("responseContentType", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMonitorHttp.put("responseContentLength", new TableInfo.Column("responseContentLength", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMonitorHttp.put("responseDate", new TableInfo.Column("responseDate", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMonitorHttp.put("responseTlsVersion", new TableInfo.Column("responseTlsVersion", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMonitorHttp.put("responseCipherSuite", new TableInfo.Column("responseCipherSuite", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMonitorHttp.put("responseCode", new TableInfo.Column("responseCode", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMonitorHttp.put("responseMessage", new TableInfo.Column("responseMessage", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMonitorHttp.put("error", new TableInfo.Column("error", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysMonitorHttp = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesMonitorHttp = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoMonitorHttp = new TableInfo("MonitorHttp", _columnsMonitorHttp, _foreignKeysMonitorHttp, _indicesMonitorHttp);
        final TableInfo _existingMonitorHttp = TableInfo.read(db, "MonitorHttp");
        if (!_infoMonitorHttp.equals(_existingMonitorHttp)) {
          return new RoomOpenHelper.ValidationResult(false, "MonitorHttp(github.leavesczy.monitor.internal.db.Monitor).\n"
                  + " Expected:\n" + _infoMonitorHttp + "\n"
                  + " Found:\n" + _existingMonitorHttp);
        }
        return new RoomOpenHelper.ValidationResult(true, null);
      }
    }, "394157e88d91181878212d91a5178ad2", "eca971dc8036eddb7be260b8f0831740");
    final SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder(config.context).name(config.name).callback(_openCallback).build();
    final SupportSQLiteOpenHelper _helper = config.sqliteOpenHelperFactory.create(_sqliteConfig);
    return _helper;
  }

  @Override
  @NonNull
  protected InvalidationTracker createInvalidationTracker() {
    final HashMap<String, String> _shadowTablesMap = new HashMap<String, String>(0);
    final HashMap<String, Set<String>> _viewTables = new HashMap<String, Set<String>>(0);
    return new InvalidationTracker(this, _shadowTablesMap, _viewTables, "MonitorHttp");
  }

  @Override
  public void clearAllTables() {
    super.assertNotMainThread();
    final SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
    try {
      super.beginTransaction();
      _db.execSQL("DELETE FROM `MonitorHttp`");
      super.setTransactionSuccessful();
    } finally {
      super.endTransaction();
      _db.query("PRAGMA wal_checkpoint(FULL)").close();
      if (!_db.inTransaction()) {
        _db.execSQL("VACUUM");
      }
    }
  }

  @Override
  @NonNull
  protected Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
    final HashMap<Class<?>, List<Class<?>>> _typeConvertersMap = new HashMap<Class<?>, List<Class<?>>>();
    _typeConvertersMap.put(MonitorDao.class, MonitorDao_Impl.getRequiredConverters());
    return _typeConvertersMap;
  }

  @Override
  @NonNull
  public Set<Class<? extends AutoMigrationSpec>> getRequiredAutoMigrationSpecs() {
    final HashSet<Class<? extends AutoMigrationSpec>> _autoMigrationSpecsSet = new HashSet<Class<? extends AutoMigrationSpec>>();
    return _autoMigrationSpecsSet;
  }

  @Override
  @NonNull
  public List<Migration> getAutoMigrations(
      @NonNull final Map<Class<? extends AutoMigrationSpec>, AutoMigrationSpec> autoMigrationSpecs) {
    final List<Migration> _autoMigrations = new ArrayList<Migration>();
    return _autoMigrations;
  }

  @Override
  public MonitorDao getMonitorDao() {
    if (_monitorDao != null) {
      return _monitorDao;
    } else {
      synchronized(this) {
        if(_monitorDao == null) {
          _monitorDao = new MonitorDao_Impl(this);
        }
        return _monitorDao;
      }
    }
  }
}
