/*
 * Decompiled with CFR 0.152.
 */
package github.leavesczy.monitor;

import androidx.compose.runtime.internal.StabilityInferred;
import github.leavesczy.monitor.MonitorInterceptorKt;
import github.leavesczy.monitor.internal.ContextProvider;
import github.leavesczy.monitor.internal.MonitorNotificationHandler;
import github.leavesczy.monitor.internal.db.Monitor;
import github.leavesczy.monitor.internal.db.MonitorDatabase;
import github.leavesczy.monitor.internal.db.MonitorPair;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lgithub/leavesczy/monitor/MonitorInterceptor;", "Lokhttp3/Interceptor;", "()V", "notificationHandleInitialized", "", "buildMonitor", "Lgithub/leavesczy/monitor/internal/db/Monitor;", "request", "Lokhttp3/Request;", "initNotificationHandlerIfNeed", "", "insert", "monitor", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "processResponse", "response", "update", "monitor_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nMonitorInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MonitorInterceptor.kt\ngithub/leavesczy/monitor/MonitorInterceptor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,219:1\n1549#2:220\n1620#2,3:221\n1549#2:224\n1620#2,3:225\n1549#2:228\n1620#2,3:229\n*S KotlinDebug\n*F\n+ 1 MonitorInterceptor.kt\ngithub/leavesczy/monitor/MonitorInterceptor\n*L\n67#1:220\n67#1:221,3\n120#1:224\n120#1:225,3\n123#1:228\n123#1:229,3\n*E\n"})
public final class MonitorInterceptor
implements Interceptor {
    private volatile boolean notificationHandleInitialized;
    public static final int $stable = 8;

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Response response;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        this.initNotificationHandlerIfNeed();
        Request request = chain.request();
        Monitor monitor = this.buildMonitor(request);
        monitor = this.insert(monitor);
        try {
            response = chain.proceed(request);
        }
        catch (Throwable throwable) {
            this.update(Monitor.copy$default(monitor, 0L, null, null, null, null, null, null, null, null, null, null, 0L, 0L, null, null, null, 0L, 0L, null, null, 0, null, throwable.toString(), 0x3FFFFF, null));
            throw throwable;
        }
        Response response2 = response;
        monitor = this.processResponse(response2, monitor);
        this.update(monitor);
        return response2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void initNotificationHandlerIfNeed() {
        if (!this.notificationHandleInitialized) {
            MonitorInterceptor monitorInterceptor = this;
            synchronized (monitorInterceptor) {
                boolean bl = false;
                if (!this.notificationHandleInitialized) {
                    this.notificationHandleInitialized = true;
                    MonitorNotificationHandler.INSTANCE.init(ContextProvider.INSTANCE.getContext());
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Monitor buildMonitor(Request request) {
        Object object;
        String string2;
        void $this$mapTo$iv$iv;
        long requestDate = System.currentTimeMillis();
        RequestBody requestBody = request.body();
        HttpUrl url = request.url();
        String scheme = url.scheme();
        String host = url.host();
        String path = url.encodedPath();
        String string3 = url.encodedQuery();
        if (string3 == null) {
            string3 = "";
        }
        String query = string3;
        String method = request.method();
        Iterable $this$map$iv = (Iterable)request.headers();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new MonitorPair((String)it.getFirst(), (String)it.getSecond()));
        }
        List requestHeaders = (List)destination$iv$iv;
        if (requestBody == null) {
            string2 = null;
        } else if (MonitorInterceptorKt.bodyHasUnknownEncoding(request.headers()) || requestBody.isDuplex() || requestBody.isOneShot()) {
            string2 = "";
        } else {
            Object charset;
            Buffer buffer = new Buffer();
            requestBody.writeTo((BufferedSink)buffer);
            MediaType contentType = requestBody.contentType();
            Object object2 = contentType;
            if (object2 == null || (object2 = object2.charset(Charsets.UTF_8)) == null) {
                object2 = charset = Charsets.UTF_8;
            }
            if (MonitorInterceptorKt.isProbablyUtf8(buffer)) {
                Object object3;
                String read = buffer.readString((Charset)charset);
                object = read;
                if (StringsKt.isBlank((CharSequence)object)) {
                    boolean bl = false;
                    object3 = null;
                } else {
                    object3 = object;
                }
                string2 = (String)object3;
            } else {
                string2 = "";
            }
        }
        String mRequestBody = string2;
        RequestBody requestBody2 = requestBody;
        long requestContentLength = requestBody2 != null ? requestBody2.contentLength() : 0L;
        Object object4 = requestBody;
        if (object4 == null || (object4 = object4.contentType()) == null || (object4 = object4.toString()) == null) {
            object4 = "";
        }
        Object requestContentType = object4;
        String string4 = url.toString();
        object = CollectionsKt.emptyList();
        return new Monitor(0L, string4, scheme, host, path, query, "", method, requestHeaders, mRequestBody, (String)requestContentType, requestContentLength, requestDate, (List)object, "", "", 0L, 0L, "", "", 0, "", null, 0x100000, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Monitor processResponse(Response response, Monitor monitor) {
        Object object;
        Object object2;
        String string2;
        long responseContentLength;
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv = (Iterable)response.request().headers();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new MonitorPair((String)it.getFirst(), (String)it.getSecond()));
        }
        List requestHeaders = (List)destination$iv$iv;
        Iterable $this$map$iv2 = (Iterable)response.headers();
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair bl = (Pair)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(new MonitorPair((String)it.getFirst(), (String)it.getSecond()));
        }
        List responseHeaders = (List)destination$iv$iv2;
        ResponseBody responseBody = response.body();
        Object object3 = responseBody;
        if (object3 == null || (object3 = object3.contentType()) == null || (object3 = object3.toString()) == null) {
            object3 = "";
        }
        Object responseContentType = object3;
        ResponseBody responseBody2 = responseBody;
        long l = responseContentLength = responseBody2 != null ? responseBody2.contentLength() : 0L;
        if (responseBody == null) {
            string2 = null;
        } else if (!HttpHeaders.promisesBody((Response)response) || MonitorInterceptorKt.bodyHasUnknownEncoding(response.headers())) {
            string2 = "";
        } else {
            Buffer buffer = MonitorInterceptorKt.getNativeSource(response);
            responseContentLength = buffer.size();
            if (MonitorInterceptorKt.isProbablyUtf8(buffer)) {
                if (responseContentLength != 0L) {
                    CharSequence charSequence;
                    String read;
                    CharSequence charSequence2;
                    Object charset;
                    Object object4 = responseBody.contentType();
                    if (object4 == null || (object4 = object4.charset(Charsets.UTF_8)) == null) {
                        object4 = charset = Charsets.UTF_8;
                    }
                    if (StringsKt.isBlank((CharSequence)(charSequence2 = (CharSequence)(read = buffer.clone().readString((Charset)charset))))) {
                        boolean bl = false;
                        charSequence = null;
                    } else {
                        charSequence = charSequence2;
                    }
                    string2 = (String)charSequence;
                } else {
                    string2 = "";
                }
            } else {
                string2 = "";
            }
        }
        String mResponseBody = string2;
        long l2 = response.sentRequestAtMillis();
        long l3 = response.receivedResponseAtMillis();
        String string3 = response.protocol().toString();
        int n = response.code();
        String string4 = response.message();
        Object object5 = response.handshake();
        if (object5 == null || (object5 = object5.tlsVersion()) == null || (object5 = object5.javaName()) == null) {
            object5 = object2 = "";
        }
        if ((object = response.handshake()) == null || (object = object.cipherSuite()) == null || (object = object.javaName()) == null) {
            object = "";
        }
        Object object6 = object;
        long l4 = responseContentLength;
        return Monitor.copy$default(monitor, 0L, null, null, null, null, null, string3, null, requestHeaders, null, null, 0L, l2, responseHeaders, mResponseBody, (String)responseContentType, l4, l3, (String)object2, (String)object6, n, string4, null, 4198079, null);
    }

    private final Monitor insert(Monitor monitor) {
        long id = MonitorDatabase.Companion.getInstance().getMonitorDao().insert(monitor);
        return Monitor.copy$default(monitor, id, null, null, null, null, null, null, null, null, null, null, 0L, 0L, null, null, null, 0L, 0L, null, null, 0, null, null, 0x7FFFFE, null);
    }

    private final void update(Monitor monitor) {
        MonitorDatabase.Companion.getInstance().getMonitorDao().update(monitor);
    }
}

