/*
 * Decompiled with CFR 0.152.
 */
package github.leavesczy.monitor;

import java.io.Closeable;
import java.io.EOFException;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0000\u001a\f\u0010\u0007\u001a\u00020\u0001*\u00020\u0005H\u0000\u00a8\u0006\b"}, d2={"bodyGzipped", "", "Lokhttp3/Headers;", "bodyHasUnknownEncoding", "getNativeSource", "Lokio/Buffer;", "Lokhttp3/Response;", "isProbablyUtf8", "monitor_release"})
public final class MonitorInterceptorKt {
    public static final boolean isProbablyUtf8(@NotNull Buffer $this$isProbablyUtf8) {
        Intrinsics.checkNotNullParameter((Object)$this$isProbablyUtf8, (String)"<this>");
        try {
            Buffer prefix = new Buffer();
            long byteCount = RangesKt.coerceAtMost((long)$this$isProbablyUtf8.getBuffer().size(), (long)64L);
            $this$isProbablyUtf8.getBuffer().copyTo(prefix, 0L, byteCount);
            for (int i = 0; i < 16 && !prefix.exhausted(); ++i) {
                int codePoint = prefix.readUtf8CodePoint();
                if (!Character.isISOControl(codePoint) || Character.isWhitespace(codePoint)) continue;
                return false;
            }
            return true;
        }
        catch (EOFException eOFException) {
            return false;
        }
    }

    public static final boolean bodyGzipped(@NotNull Headers $this$bodyGzipped) {
        Intrinsics.checkNotNullParameter((Object)$this$bodyGzipped, (String)"<this>");
        return StringsKt.equals((String)$this$bodyGzipped.get("Content-Encoding"), (String)"gzip", (boolean)true);
    }

    public static final boolean bodyHasUnknownEncoding(@NotNull Headers $this$bodyHasUnknownEncoding) {
        Intrinsics.checkNotNullParameter((Object)$this$bodyHasUnknownEncoding, (String)"<this>");
        String string2 = $this$bodyHasUnknownEncoding.get("Content-Encoding");
        if (string2 == null) {
            return false;
        }
        String contentEncoding = string2;
        return !StringsKt.equals((String)contentEncoding, (String)"identity", (boolean)true) && !StringsKt.equals((String)contentEncoding, (String)"gzip", (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Buffer getNativeSource(@NotNull Response $this$getNativeSource) {
        Intrinsics.checkNotNullParameter((Object)$this$getNativeSource, (String)"<this>");
        ResponseBody responseBody = $this$getNativeSource.body();
        Intrinsics.checkNotNull((Object)responseBody);
        BufferedSource source = responseBody.source();
        source.request(Long.MAX_VALUE);
        Buffer buffer = null;
        buffer = source.getBuffer();
        if (MonitorInterceptorKt.bodyGzipped($this$getNativeSource.headers())) {
            Closeable closeable = (Closeable)new GzipSource((Source)buffer.clone());
            Throwable throwable = null;
            try {
                GzipSource responseBody2 = (GzipSource)closeable;
                boolean bl = false;
                buffer = new Buffer();
                long l = buffer.writeAll((Source)responseBody2);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return buffer;
    }
}

