/*
 * Decompiled with CFR 0.152.
 */
package github.leavesczy.monitor.internal;

import androidx.compose.runtime.internal.StabilityInferred;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import github.leavesczy.monitor.internal.JsonFormat;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u000e\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0013J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0001J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011R#\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R#\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\t\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lgithub/leavesczy/monitor/internal/JsonFormat;", "", "()V", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "getGson", "()Lcom/google/gson/Gson;", "gson$delegate", "Lkotlin/Lazy;", "prettyPrintingGson", "getPrettyPrintingGson", "prettyPrintingGson$delegate", "fromJsonArray", "", "T", "json", "", "clazz", "Ljava/lang/Class;", "toJson", "ob", "toPrettyJson", "ParameterizedTypeImpl", "monitor_release"})
@StabilityInferred(parameters=0)
public final class JsonFormat {
    @NotNull
    public static final JsonFormat INSTANCE = new JsonFormat();
    @NotNull
    private static final Lazy gson$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)gson.2.INSTANCE);
    @NotNull
    private static final Lazy prettyPrintingGson$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)prettyPrintingGson.2.INSTANCE);
    public static final int $stable = 8;

    private JsonFormat() {
    }

    private final Gson getGson() {
        Lazy lazy = gson$delegate;
        return (Gson)lazy.getValue();
    }

    private final Gson getPrettyPrintingGson() {
        Lazy lazy = prettyPrintingGson$delegate;
        return (Gson)lazy.getValue();
    }

    @NotNull
    public final String toJson(@NotNull Object ob) {
        Intrinsics.checkNotNullParameter((Object)ob, (String)"ob");
        String string2 = this.getGson().toJson(ob);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toJson(...)");
        return string2;
    }

    @NotNull
    public final String toPrettyJson(@NotNull String json) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        try {
            string2 = this.getPrettyPrintingGson().toJson(JsonParser.parseString((String)json));
            Intrinsics.checkNotNull((Object)string2);
        }
        catch (JsonParseException e) {
            e.printStackTrace();
            string2 = json;
        }
        return string2;
    }

    @NotNull
    public final <T> List<T> fromJsonArray(@NotNull String json, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        ParameterizedTypeImpl<T> type = new ParameterizedTypeImpl<T>(clazz);
        List list = (List)this.getGson().fromJson(json, (Type)type);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public static final /* synthetic */ Gson access$getGson(JsonFormat $this) {
        return $this.getGson();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016\u00a2\u0006\u0002\u0010\u000bJ\n\u0010\f\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\r\u001a\u00020\nH\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lgithub/leavesczy/monitor/internal/JsonFormat$ParameterizedTypeImpl;", "T", "Ljava/lang/reflect/ParameterizedType;", "clazz", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "getClazz", "()Ljava/lang/Class;", "getActualTypeArguments", "", "Ljava/lang/reflect/Type;", "()[Ljava/lang/reflect/Type;", "getOwnerType", "getRawType", "monitor_release"})
    private static final class ParameterizedTypeImpl<T>
    implements ParameterizedType {
        @NotNull
        private final Class<T> clazz;

        public ParameterizedTypeImpl(@NotNull Class<T> clazz) {
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            this.clazz = clazz;
        }

        @NotNull
        public final Class<T> getClazz() {
            return this.clazz;
        }

        @Override
        @NotNull
        public Type[] getActualTypeArguments() {
            Type[] typeArray = new Type[]{this.clazz};
            return typeArray;
        }

        @Override
        @NotNull
        public Type getRawType() {
            return (Type)((Object)List.class);
        }

        @Override
        @Nullable
        public Type getOwnerType() {
            return null;
        }
    }
}

