/*
 * Decompiled with CFR 0.152.
 */
package github.leavesczy.monitor.internal;

import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.app.ShareCompat;
import github.leavesczy.monitor.R;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\r"}, d2={"Lgithub/leavesczy/monitor/internal/Utils;", "", "()V", "copyText", "", "context", "Landroid/content/Context;", "text", "", "shareFile", "uri", "Landroid/net/Uri;", "shareText", "monitor_release"})
@StabilityInferred(parameters=1)
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();
    public static final int $stable;

    private Utils() {
    }

    public final void copyText(@NotNull Context context, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String string2 = context.getString(R.string.monitor_monitor);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        String monitor = string2;
        Object object = context.getSystemService("clipboard");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.content.ClipboardManager");
        ClipboardManager clipboardManager = (ClipboardManager)object;
        ClipData clipData = ClipData.newPlainText((CharSequence)monitor, (CharSequence)text);
        clipboardManager.setPrimaryClip(clipData);
    }

    public final void shareText(@NotNull Context context, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String string2 = context.getString(R.string.monitor_monitor);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        String monitor = string2;
        Intent intent = new ShareCompat.IntentBuilder(context).setText((CharSequence)text).setType("text/plain").setChooserTitle((CharSequence)monitor).setSubject(monitor).createChooserIntent();
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"createChooserIntent(...)");
        Intent shareIntent = intent;
        if (!(context instanceof Activity)) {
            shareIntent.addFlags(0x10000000);
        }
        context.startActivity(shareIntent);
    }

    public final void shareFile(@NotNull Context context, @NotNull Uri uri) {
        Intent shareIntent;
        Intent intent;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String string2 = context.getString(R.string.monitor_monitor);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        String monitor = string2;
        Intent intent2 = new ShareCompat.IntentBuilder(context).setStream(uri).setType(context.getContentResolver().getType(uri)).setChooserTitle((CharSequence)monitor).setSubject(monitor).getIntent();
        Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"getIntent(...)");
        Intent $this$shareFile_u24lambda_u240 = intent = (shareIntent = intent2);
        boolean bl = false;
        $this$shareFile_u24lambda_u240.setClipData(ClipData.newRawUri((CharSequence)monitor, (Uri)uri));
        $this$shareFile_u24lambda_u240.addFlags(1);
        Intent chooserIntent = Intent.createChooser((Intent)shareIntent, (CharSequence)monitor);
        if (!(context instanceof Activity)) {
            chooserIntent.addFlags(0x10000000);
        }
        context.startActivity(chooserIntent);
    }
}

