/*
 * Decompiled with CFR 0.152.
 */
package github.leavesczy.monitor.internal.db;

import android.content.Context;
import android.text.format.Formatter;
import github.leavesczy.monitor.R;
import github.leavesczy.monitor.internal.ContextProvider;
import github.leavesczy.monitor.internal.JsonFormat;
import github.leavesczy.monitor.internal.db.Monitor;
import github.leavesczy.monitor.internal.db.MonitorPair;
import github.leavesczy.monitor.internal.db.MonitorStatus;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u001a\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u000b\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0006H\u0002\u001a\u0012\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r*\u00020\u000fH\u0000\u001a\f\u0010\u0010\u001a\u00020\u0001*\u00020\u000fH\u0000\u001a\u0012\u0010\u0011\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u001a\f\u0010\u0012\u001a\u00020\u0001*\u00020\u000fH\u0002\u001a\f\u0010\u0013\u001a\u00020\u0001*\u00020\u000fH\u0002\u00a8\u0006\u0014"}, d2={"formatBody", "", "body", "contentType", "formatBytes", "bytes", "", "formatXml", "xml", "getDateMDHMS", "date", "getDateYMDHMSS", "buildOverview", "", "Lgithub/leavesczy/monitor/internal/db/MonitorPair;", "Lgithub/leavesczy/monitor/internal/db/Monitor;", "buildShareText", "format", "formatRequestBody", "formatResponseBody", "monitor_release"})
@SourceDebugExtension(value={"SMAP\nModels.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Models.kt\ngithub/leavesczy/monitor/internal/db/ModelsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,359:1\n1864#2,3:360\n*S KotlinDebug\n*F\n+ 1 Models.kt\ngithub/leavesczy/monitor/internal/db/ModelsKt\n*L\n350#1:360,3\n*E\n"})
public final class ModelsKt {
    @NotNull
    public static final List<MonitorPair> buildOverview(@NotNull Monitor $this$buildOverview) {
        List list;
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$buildOverview, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$buildOverview.getHttpStatus().ordinal()]) {
            case 1: {
                object = "";
                break;
            }
            case 2: {
                object = $this$buildOverview.getResponseCode() + " " + $this$buildOverview.getResponseMessage();
                break;
            }
            case 3: {
                object = $this$buildOverview.getError();
                if (object != null) break;
                object = "";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String responseSummaryText = object;
        List $this$buildOverview_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$buildOverview_u24lambda_u240.add(new MonitorPair("Url", $this$buildOverview.getUrl()));
        $this$buildOverview_u24lambda_u240.add(new MonitorPair("Method", $this$buildOverview.getMethod()));
        $this$buildOverview_u24lambda_u240.add(new MonitorPair("Protocol", $this$buildOverview.getProtocol()));
        $this$buildOverview_u24lambda_u240.add(new MonitorPair("State", $this$buildOverview.getHttpStatus().toString()));
        $this$buildOverview_u24lambda_u240.add(new MonitorPair("Response", responseSummaryText));
        $this$buildOverview_u24lambda_u240.add(new MonitorPair("TlsVersion", $this$buildOverview.getResponseTlsVersion()));
        $this$buildOverview_u24lambda_u240.add(new MonitorPair("CipherSuite", $this$buildOverview.getResponseCipherSuite()));
        $this$buildOverview_u24lambda_u240.add(new MonitorPair("Request Time", ModelsKt.getDateYMDHMSS($this$buildOverview.getRequestDate())));
        $this$buildOverview_u24lambda_u240.add(new MonitorPair("Response Time", ModelsKt.getDateYMDHMSS($this$buildOverview.getResponseDate())));
        $this$buildOverview_u24lambda_u240.add(new MonitorPair("Duration", $this$buildOverview.getRequestDurationFormat()));
        $this$buildOverview_u24lambda_u240.add(new MonitorPair("Request Size", ModelsKt.formatBytes($this$buildOverview.getRequestContentLength())));
        $this$buildOverview_u24lambda_u240.add(new MonitorPair("Response Size", ModelsKt.formatBytes($this$buildOverview.getResponseContentLength())));
        $this$buildOverview_u24lambda_u240.add(new MonitorPair("Total Size", $this$buildOverview.getTotalSizeFormat()));
        return CollectionsKt.build((List)list);
    }

    private static final String formatBytes(long bytes) {
        String string2 = Formatter.formatFileSize((Context)((Context)ContextProvider.INSTANCE.getContext()), (long)bytes);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"formatFileSize(...)");
        return string2;
    }

    private static final String getDateMDHMS(long date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM-dd HH:mm:ss", Locale.getDefault());
        String string2 = simpleDateFormat.format(new Date(date));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private static final String getDateYMDHMSS(long date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS", Locale.getDefault());
        String string2 = simpleDateFormat.format(new Date(date));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private static final String formatRequestBody(Monitor $this$formatRequestBody) {
        return ModelsKt.formatBody($this$formatRequestBody.getRequestBody(), $this$formatRequestBody.getRequestContentType());
    }

    private static final String formatResponseBody(Monitor $this$formatResponseBody) {
        return ModelsKt.formatBody($this$formatResponseBody.getResponseBody(), $this$formatResponseBody.getResponseContentType());
    }

    private static final String formatBody(String body, String contentType) {
        String string2;
        if (body == null) {
            string2 = "";
        } else if (StringsKt.isBlank((CharSequence)body)) {
            String string3 = ContextProvider.INSTANCE.getContext().getString(R.string.monitor_encoded_body_omitted);
            Intrinsics.checkNotNull((Object)string3);
            string2 = string3;
        } else {
            string2 = StringsKt.contains((CharSequence)contentType, (CharSequence)"json", (boolean)true) ? JsonFormat.INSTANCE.toPrettyJson(body) : (StringsKt.contains((CharSequence)contentType, (CharSequence)"xml", (boolean)true) ? ModelsKt.formatXml(body) : body);
        }
        return string2;
    }

    private static final String formatXml(String xml) {
        String string2;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            Intrinsics.checkNotNullExpressionValue((Object)documentBuilderFactory, (String)"newInstance(...)");
            DocumentBuilderFactory documentFactory = documentBuilderFactory;
            documentFactory.setExpandEntityReferences(false);
            DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)documentBuilder, (String)"newDocumentBuilder(...)");
            DocumentBuilder documentBuilder2 = documentBuilder;
            String string3 = xml;
            Charset charset = Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset(...)");
            byte[] byArray = string3.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            InputSource inputSource = new InputSource(new ByteArrayInputStream(byArray));
            Document document = documentBuilder2.parse(inputSource);
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(...)");
            Document document2 = document;
            DOMSource domSource = new DOMSource(document2);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            Object object = TransformerFactory.newInstance();
            TransformerFactory $this$formatXml_u24lambda_u241 = object;
            boolean bl = false;
            $this$formatXml_u24lambda_u241.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Object $this$formatXml_u24lambda_u242 = object = ((TransformerFactory)object).newTransformer();
            boolean bl2 = false;
            ((Transformer)$this$formatXml_u24lambda_u242).setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            ((Transformer)$this$formatXml_u24lambda_u242).setOutputProperty("indent", "yes");
            ((Transformer)$this$formatXml_u24lambda_u242).transform(domSource, result);
            string2 = writer.toString();
            Intrinsics.checkNotNull((Object)string2);
        }
        catch (SAXParseException e) {
            string2 = xml;
        }
        catch (IOException io) {
            string2 = xml;
        }
        catch (TransformerException t) {
            string2 = xml;
        }
        return string2;
    }

    @NotNull
    public static final String buildShareText(@NotNull Monitor $this$buildShareText) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$buildShareText, (String)"<this>");
        StringBuilder $this$buildShareText_u24lambda_u246 = stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        $this$buildShareText_u24lambda_u246.append(ModelsKt.format(ModelsKt.buildOverview($this$buildShareText)));
        $this$buildShareText_u24lambda_u246.append("\n\n");
        boolean bl3 = false;
        $this$buildShareText_u24lambda_u246.append("----------Request----------");
        $this$buildShareText_u24lambda_u246.append("\n\n");
        $this$buildShareText_u24lambda_u246.append(ModelsKt.format($this$buildShareText.getRequestHeaders()));
        if (!StringsKt.isBlank((CharSequence)$this$buildShareText.getRequestBodyFormat())) {
            $this$buildShareText_u24lambda_u246.append("\n\n");
            $this$buildShareText_u24lambda_u246.append($this$buildShareText.getRequestBodyFormat());
        }
        $this$buildShareText_u24lambda_u246.append("\n\n");
        boolean bl4 = false;
        $this$buildShareText_u24lambda_u246.append("----------Response----------");
        $this$buildShareText_u24lambda_u246.append("\n\n");
        $this$buildShareText_u24lambda_u246.append(ModelsKt.format($this$buildShareText.getResponseHeaders()));
        $this$buildShareText_u24lambda_u246.append("\n\n");
        $this$buildShareText_u24lambda_u246.append($this$buildShareText.getResponseBodyFormat());
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private static final String format(List<MonitorPair> $this$format) {
        StringBuilder stringBuilder;
        StringBuilder $this$format_u24lambda_u248 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Iterable $this$forEachIndexed$iv = $this$format;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void pair;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            MonitorPair monitorPair = (MonitorPair)item$iv;
            int index = n;
            boolean bl2 = false;
            $this$format_u24lambda_u248.append(pair.getName());
            $this$format_u24lambda_u248.append(" : ");
            $this$format_u24lambda_u248.append(pair.getValue());
            if (index == $this$format.size() - 1) continue;
            $this$format_u24lambda_u248.append("\n");
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    public static final /* synthetic */ String access$formatRequestBody(Monitor $receiver) {
        return ModelsKt.formatRequestBody($receiver);
    }

    public static final /* synthetic */ String access$formatResponseBody(Monitor $receiver) {
        return ModelsKt.formatResponseBody($receiver);
    }

    public static final /* synthetic */ String access$getDateMDHMS(long date) {
        return ModelsKt.getDateMDHMS(date);
    }

    public static final /* synthetic */ String access$formatBytes(long bytes) {
        return ModelsKt.formatBytes(bytes);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MonitorStatus.values().length];
            try {
                nArray[MonitorStatus.Requesting.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MonitorStatus.Complete.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MonitorStatus.Failed.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

