/*
 * Decompiled with CFR 0.152.
 */
package github.leavesczy.monitor.internal.db;

import androidx.compose.runtime.Stable;
import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.PrimaryKey;
import github.leavesczy.monitor.internal.db.ModelsKt;
import github.leavesczy.monitor.internal.db.Monitor;
import github.leavesczy.monitor.internal.db.MonitorPair;
import github.leavesczy.monitor.internal.db.MonitorStatus;
import java.util.Arrays;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\bI\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0081\b\u0018\u0000 q2\u00020\u0001:\u0001qB\u00d1\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0010\u001a\u00020\u0005\u0012\u0006\u0010\u0011\u001a\u00020\u0003\u0012\u0006\u0010\u0012\u001a\u00020\u0003\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0015\u001a\u00020\u0005\u0012\u0006\u0010\u0016\u001a\u00020\u0003\u0012\u0006\u0010\u0017\u001a\u00020\u0003\u0012\u0006\u0010\u0018\u001a\u00020\u0005\u0012\u0006\u0010\u0019\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u0005\u0012\b\u0010\u001d\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u001eJ\t\u0010T\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010U\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010V\u001a\u00020\u0005H\u00c6\u0003J\t\u0010W\u001a\u00020\u0003H\u00c6\u0003J\t\u0010X\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u00c6\u0003J\u000b\u0010Z\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010[\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\\\u001a\u00020\u0003H\u00c6\u0003J\t\u0010]\u001a\u00020\u0003H\u00c6\u0003J\t\u0010^\u001a\u00020\u0005H\u00c6\u0003J\t\u0010_\u001a\u00020\u0005H\u00c6\u0003J\t\u0010`\u001a\u00020\u0005H\u00c6\u0003J\t\u0010a\u001a\u00020\u001bH\u00c6\u0003J\t\u0010b\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010c\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010d\u001a\u00020\u0005H\u00c6\u0003J\t\u0010e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010g\u001a\u00020\u0005H\u00c6\u0003J\t\u0010h\u001a\u00020\u0005H\u00c6\u0003J\t\u0010i\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010j\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u00c6\u0003J\u0081\u0002\u0010k\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\u00052\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0010\u001a\u00020\u00052\b\b\u0002\u0010\u0011\u001a\u00020\u00032\b\b\u0002\u0010\u0012\u001a\u00020\u00032\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0015\u001a\u00020\u00052\b\b\u0002\u0010\u0016\u001a\u00020\u00032\b\b\u0002\u0010\u0017\u001a\u00020\u00032\b\b\u0002\u0010\u0018\u001a\u00020\u00052\b\b\u0002\u0010\u0019\u001a\u00020\u00052\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u00052\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010l\u001a\u00020m2\b\u0010n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010o\u001a\u00020\u001bH\u00d6\u0001J\t\u0010p\u001a\u00020\u0005H\u00d6\u0001R\u0018\u0010\u001d\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0016\u0010\u0007\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010 R\u0011\u0010\"\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0016\u0010\u000b\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010 R\u0011\u0010)\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b*\u0010 R\u0016\u0010\b\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010 R\u0011\u0010,\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b-\u0010 R\u0016\u0010\n\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010 R\u0016\u0010\t\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010 R\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010 R\u001b\u00101\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b3\u00104\u001a\u0004\b2\u0010 R\u0016\u0010\u0011\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010'R\u0016\u0010\u0010\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010 R\u0016\u0010\u0012\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010'R\u001b\u00108\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b:\u00104\u001a\u0004\b9\u0010 R\u001b\u0010;\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b=\u00104\u001a\u0004\b<\u0010 R\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010 R\u001b\u0010A\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bC\u00104\u001a\u0004\bB\u0010 R\u0016\u0010\u0019\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010 R\u0016\u0010\u001a\u001a\u00020\u001b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010FR\u0011\u0010G\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\bH\u0010 R\u0016\u0010\u0016\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010'R\u0016\u0010\u0015\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010 R\u0016\u0010\u0017\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010'R\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u0010?R\u0016\u0010\u001c\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010 R\u0016\u0010\u0018\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bN\u0010 R\u0016\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010 R\u001b\u0010P\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bR\u00104\u001a\u0004\bQ\u0010 R\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bS\u0010 \u00a8\u0006r"}, d2={"Lgithub/leavesczy/monitor/internal/db/Monitor;", "", "id", "", "url", "", "scheme", "host", "path", "query", "protocol", "method", "requestHeaders", "", "Lgithub/leavesczy/monitor/internal/db/MonitorPair;", "requestBody", "requestContentType", "requestContentLength", "requestDate", "responseHeaders", "responseBody", "responseContentType", "responseContentLength", "responseDate", "responseTlsVersion", "responseCipherSuite", "responseCode", "", "responseMessage", "error", "(JLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;JJLjava/util/List;Ljava/lang/String;Ljava/lang/String;JJLjava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getError", "()Ljava/lang/String;", "getHost", "httpStatus", "Lgithub/leavesczy/monitor/internal/db/MonitorStatus;", "getHttpStatus", "()Lgithub/leavesczy/monitor/internal/db/MonitorStatus;", "getId", "()J", "getMethod", "notificationText", "getNotificationText", "getPath", "pathWithQuery", "getPathWithQuery", "getProtocol", "getQuery", "getRequestBody", "requestBodyFormat", "getRequestBodyFormat", "requestBodyFormat$delegate", "Lkotlin/Lazy;", "getRequestContentLength", "getRequestContentType", "getRequestDate", "requestDateMDHMS", "getRequestDateMDHMS", "requestDateMDHMS$delegate", "requestDurationFormat", "getRequestDurationFormat", "requestDurationFormat$delegate", "getRequestHeaders", "()Ljava/util/List;", "getResponseBody", "responseBodyFormat", "getResponseBodyFormat", "responseBodyFormat$delegate", "getResponseCipherSuite", "getResponseCode", "()I", "responseCodeFormat", "getResponseCodeFormat", "getResponseContentLength", "getResponseContentType", "getResponseDate", "getResponseHeaders", "getResponseMessage", "getResponseTlsVersion", "getScheme", "totalSizeFormat", "getTotalSizeFormat", "totalSizeFormat$delegate", "getUrl", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "component18", "component19", "component2", "component20", "component21", "component22", "component23", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "toString", "Companion", "monitor_release"})
@Stable
@Entity(tableName="MonitorHttp")
public final class Monitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @PrimaryKey(autoGenerate=true)
    @ColumnInfo(name="id")
    private final long id;
    @ColumnInfo(name="url")
    @NotNull
    private final String url;
    @ColumnInfo(name="scheme")
    @NotNull
    private final String scheme;
    @ColumnInfo(name="host")
    @NotNull
    private final String host;
    @ColumnInfo(name="path")
    @NotNull
    private final String path;
    @ColumnInfo(name="query")
    @NotNull
    private final String query;
    @ColumnInfo(name="protocol")
    @NotNull
    private final String protocol;
    @ColumnInfo(name="method")
    @NotNull
    private final String method;
    @ColumnInfo(name="requestHeaders")
    @NotNull
    private final List<MonitorPair> requestHeaders;
    @ColumnInfo(name="requestBody")
    @Nullable
    private final String requestBody;
    @ColumnInfo(name="requestContentType")
    @NotNull
    private final String requestContentType;
    @ColumnInfo(name="requestContentLength")
    private final long requestContentLength;
    @ColumnInfo(name="requestDate")
    private final long requestDate;
    @ColumnInfo(name="responseHeaders")
    @NotNull
    private final List<MonitorPair> responseHeaders;
    @ColumnInfo(name="responseBody")
    @Nullable
    private final String responseBody;
    @ColumnInfo(name="responseContentType")
    @NotNull
    private final String responseContentType;
    @ColumnInfo(name="responseContentLength")
    private final long responseContentLength;
    @ColumnInfo(name="responseDate")
    private final long responseDate;
    @ColumnInfo(name="responseTlsVersion")
    @NotNull
    private final String responseTlsVersion;
    @ColumnInfo(name="responseCipherSuite")
    @NotNull
    private final String responseCipherSuite;
    @ColumnInfo(name="responseCode")
    private final int responseCode;
    @ColumnInfo(name="responseMessage")
    @NotNull
    private final String responseMessage;
    @ColumnInfo(name="error")
    @Nullable
    private final String error;
    @NotNull
    private final Lazy requestBodyFormat$delegate;
    @NotNull
    private final Lazy responseBodyFormat$delegate;
    @NotNull
    private final Lazy requestDateMDHMS$delegate;
    @NotNull
    private final Lazy requestDurationFormat$delegate;
    @NotNull
    private final Lazy totalSizeFormat$delegate;
    public static final int $stable;
    private static final int DEFAULT_RESPONSE_CODE = -1024;

    public Monitor(long id, @NotNull String url, @NotNull String scheme, @NotNull String host, @NotNull String path, @NotNull String query, @NotNull String protocol, @NotNull String method, @NotNull List<MonitorPair> requestHeaders, @Nullable String requestBody, @NotNull String requestContentType, long requestContentLength, long requestDate, @NotNull List<MonitorPair> responseHeaders, @Nullable String responseBody, @NotNull String responseContentType, long responseContentLength, long responseDate, @NotNull String responseTlsVersion, @NotNull String responseCipherSuite, int responseCode, @NotNull String responseMessage, @Nullable String error) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
        Intrinsics.checkNotNullParameter((Object)requestContentType, (String)"requestContentType");
        Intrinsics.checkNotNullParameter(responseHeaders, (String)"responseHeaders");
        Intrinsics.checkNotNullParameter((Object)responseContentType, (String)"responseContentType");
        Intrinsics.checkNotNullParameter((Object)responseTlsVersion, (String)"responseTlsVersion");
        Intrinsics.checkNotNullParameter((Object)responseCipherSuite, (String)"responseCipherSuite");
        Intrinsics.checkNotNullParameter((Object)responseMessage, (String)"responseMessage");
        this.id = id;
        this.url = url;
        this.scheme = scheme;
        this.host = host;
        this.path = path;
        this.query = query;
        this.protocol = protocol;
        this.method = method;
        this.requestHeaders = requestHeaders;
        this.requestBody = requestBody;
        this.requestContentType = requestContentType;
        this.requestContentLength = requestContentLength;
        this.requestDate = requestDate;
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;
        this.responseContentType = responseContentType;
        this.responseContentLength = responseContentLength;
        this.responseDate = responseDate;
        this.responseTlsVersion = responseTlsVersion;
        this.responseCipherSuite = responseCipherSuite;
        this.responseCode = responseCode;
        this.responseMessage = responseMessage;
        this.error = error;
        this.requestBodyFormat$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ Monitor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return ModelsKt.access$formatRequestBody(this.this$0);
            }
        }));
        this.responseBodyFormat$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ Monitor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return ModelsKt.access$formatResponseBody(this.this$0);
            }
        }));
        this.requestDateMDHMS$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ Monitor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return ModelsKt.access$getDateMDHMS(this.this$0.getRequestDate());
            }
        }));
        this.requestDurationFormat$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ Monitor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                Object object;
                if (this.this$0.getRequestDate() <= 0L || this.this$0.getResponseDate() <= 0L) {
                    object = "";
                } else {
                    switch (requestDurationFormat.WhenMappings.$EnumSwitchMapping$0[this.this$0.getHttpStatus().ordinal()]) {
                        case 1: {
                            object = "";
                            break;
                        }
                        case 2: {
                            object = this.this$0.getResponseDate() - this.this$0.getRequestDate() + " ms";
                            break;
                        }
                        case 3: {
                            object = "";
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                return object;
            }
        }));
        this.totalSizeFormat$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ Monitor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                String string2;
                switch (totalSizeFormat.WhenMappings.$EnumSwitchMapping$0[this.this$0.getHttpStatus().ordinal()]) {
                    case 1: {
                        string2 = "";
                        break;
                    }
                    case 2: {
                        string2 = ModelsKt.access$formatBytes(this.this$0.getRequestContentLength() + this.this$0.getResponseContentLength());
                        break;
                    }
                    case 3: {
                        string2 = "";
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return string2;
            }
        }));
    }

    public /* synthetic */ Monitor(long l, String string2, String string3, String string4, String string5, String string6, String string7, String string8, List list, String string9, String string10, long l2, long l3, List list2, String string11, String string12, long l4, long l5, String string13, String string14, int n, String string15, String string16, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x100000) != 0) {
            n = -1024;
        }
        this(l, string2, string3, string4, string5, string6, string7, string8, list, string9, string10, l2, l3, list2, string11, string12, l4, l5, string13, string14, n, string15, string16);
    }

    public final long getId() {
        return this.id;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @NotNull
    public final String getScheme() {
        return this.scheme;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final String getQuery() {
        return this.query;
    }

    @NotNull
    public final String getProtocol() {
        return this.protocol;
    }

    @NotNull
    public final String getMethod() {
        return this.method;
    }

    @NotNull
    public final List<MonitorPair> getRequestHeaders() {
        return this.requestHeaders;
    }

    @Nullable
    public final String getRequestBody() {
        return this.requestBody;
    }

    @NotNull
    public final String getRequestContentType() {
        return this.requestContentType;
    }

    public final long getRequestContentLength() {
        return this.requestContentLength;
    }

    public final long getRequestDate() {
        return this.requestDate;
    }

    @NotNull
    public final List<MonitorPair> getResponseHeaders() {
        return this.responseHeaders;
    }

    @Nullable
    public final String getResponseBody() {
        return this.responseBody;
    }

    @NotNull
    public final String getResponseContentType() {
        return this.responseContentType;
    }

    public final long getResponseContentLength() {
        return this.responseContentLength;
    }

    public final long getResponseDate() {
        return this.responseDate;
    }

    @NotNull
    public final String getResponseTlsVersion() {
        return this.responseTlsVersion;
    }

    @NotNull
    public final String getResponseCipherSuite() {
        return this.responseCipherSuite;
    }

    public final int getResponseCode() {
        return this.responseCode;
    }

    @NotNull
    public final String getResponseMessage() {
        return this.responseMessage;
    }

    @Nullable
    public final String getError() {
        return this.error;
    }

    @NotNull
    public final MonitorStatus getHttpStatus() {
        return this.error != null ? MonitorStatus.Failed : (this.responseCode == -1024 ? MonitorStatus.Requesting : MonitorStatus.Complete);
    }

    @NotNull
    public final String getNotificationText() {
        String string2;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getHttpStatus().ordinal()]) {
            case 1: {
                string2 = "..." + this.getPathWithQuery();
                break;
            }
            case 2: {
                string2 = this.responseCode + " " + this.getPathWithQuery();
                break;
            }
            case 3: {
                string2 = "!!!" + this.getPathWithQuery();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string2;
    }

    @NotNull
    public final String getPathWithQuery() {
        String string2;
        if (StringsKt.isBlank((CharSequence)this.query)) {
            string2 = this.path;
        } else {
            String string3 = "%s?%s";
            Object[] objectArray = new Object[]{this.path, this.query};
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        }
        return string2;
    }

    @NotNull
    public final String getRequestBodyFormat() {
        Lazy lazy = this.requestBodyFormat$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getResponseBodyFormat() {
        Lazy lazy = this.responseBodyFormat$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getResponseCodeFormat() {
        String string2;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getHttpStatus().ordinal()]) {
            case 1: {
                string2 = "...";
                break;
            }
            case 2: {
                string2 = String.valueOf(this.responseCode);
                break;
            }
            case 3: {
                string2 = "!!!";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string2;
    }

    @NotNull
    public final String getRequestDateMDHMS() {
        Lazy lazy = this.requestDateMDHMS$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getRequestDurationFormat() {
        Lazy lazy = this.requestDurationFormat$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getTotalSizeFormat() {
        Lazy lazy = this.totalSizeFormat$delegate;
        return (String)lazy.getValue();
    }

    public final long component1() {
        return this.id;
    }

    @NotNull
    public final String component2() {
        return this.url;
    }

    @NotNull
    public final String component3() {
        return this.scheme;
    }

    @NotNull
    public final String component4() {
        return this.host;
    }

    @NotNull
    public final String component5() {
        return this.path;
    }

    @NotNull
    public final String component6() {
        return this.query;
    }

    @NotNull
    public final String component7() {
        return this.protocol;
    }

    @NotNull
    public final String component8() {
        return this.method;
    }

    @NotNull
    public final List<MonitorPair> component9() {
        return this.requestHeaders;
    }

    @Nullable
    public final String component10() {
        return this.requestBody;
    }

    @NotNull
    public final String component11() {
        return this.requestContentType;
    }

    public final long component12() {
        return this.requestContentLength;
    }

    public final long component13() {
        return this.requestDate;
    }

    @NotNull
    public final List<MonitorPair> component14() {
        return this.responseHeaders;
    }

    @Nullable
    public final String component15() {
        return this.responseBody;
    }

    @NotNull
    public final String component16() {
        return this.responseContentType;
    }

    public final long component17() {
        return this.responseContentLength;
    }

    public final long component18() {
        return this.responseDate;
    }

    @NotNull
    public final String component19() {
        return this.responseTlsVersion;
    }

    @NotNull
    public final String component20() {
        return this.responseCipherSuite;
    }

    public final int component21() {
        return this.responseCode;
    }

    @NotNull
    public final String component22() {
        return this.responseMessage;
    }

    @Nullable
    public final String component23() {
        return this.error;
    }

    @NotNull
    public final Monitor copy(long id, @NotNull String url, @NotNull String scheme, @NotNull String host, @NotNull String path, @NotNull String query, @NotNull String protocol, @NotNull String method, @NotNull List<MonitorPair> requestHeaders, @Nullable String requestBody, @NotNull String requestContentType, long requestContentLength, long requestDate, @NotNull List<MonitorPair> responseHeaders, @Nullable String responseBody, @NotNull String responseContentType, long responseContentLength, long responseDate, @NotNull String responseTlsVersion, @NotNull String responseCipherSuite, int responseCode, @NotNull String responseMessage, @Nullable String error) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
        Intrinsics.checkNotNullParameter((Object)requestContentType, (String)"requestContentType");
        Intrinsics.checkNotNullParameter(responseHeaders, (String)"responseHeaders");
        Intrinsics.checkNotNullParameter((Object)responseContentType, (String)"responseContentType");
        Intrinsics.checkNotNullParameter((Object)responseTlsVersion, (String)"responseTlsVersion");
        Intrinsics.checkNotNullParameter((Object)responseCipherSuite, (String)"responseCipherSuite");
        Intrinsics.checkNotNullParameter((Object)responseMessage, (String)"responseMessage");
        return new Monitor(id, url, scheme, host, path, query, protocol, method, requestHeaders, requestBody, requestContentType, requestContentLength, requestDate, responseHeaders, responseBody, responseContentType, responseContentLength, responseDate, responseTlsVersion, responseCipherSuite, responseCode, responseMessage, error);
    }

    public static /* synthetic */ Monitor copy$default(Monitor monitor, long l, String string2, String string3, String string4, String string5, String string6, String string7, String string8, List list, String string9, String string10, long l2, long l3, List list2, String string11, String string12, long l4, long l5, String string13, String string14, int n, String string15, String string16, int n2, Object object) {
        if ((n2 & 1) != 0) {
            l = monitor.id;
        }
        if ((n2 & 2) != 0) {
            string2 = monitor.url;
        }
        if ((n2 & 4) != 0) {
            string3 = monitor.scheme;
        }
        if ((n2 & 8) != 0) {
            string4 = monitor.host;
        }
        if ((n2 & 0x10) != 0) {
            string5 = monitor.path;
        }
        if ((n2 & 0x20) != 0) {
            string6 = monitor.query;
        }
        if ((n2 & 0x40) != 0) {
            string7 = monitor.protocol;
        }
        if ((n2 & 0x80) != 0) {
            string8 = monitor.method;
        }
        if ((n2 & 0x100) != 0) {
            list = monitor.requestHeaders;
        }
        if ((n2 & 0x200) != 0) {
            string9 = monitor.requestBody;
        }
        if ((n2 & 0x400) != 0) {
            string10 = monitor.requestContentType;
        }
        if ((n2 & 0x800) != 0) {
            l2 = monitor.requestContentLength;
        }
        if ((n2 & 0x1000) != 0) {
            l3 = monitor.requestDate;
        }
        if ((n2 & 0x2000) != 0) {
            list2 = monitor.responseHeaders;
        }
        if ((n2 & 0x4000) != 0) {
            string11 = monitor.responseBody;
        }
        if ((n2 & 0x8000) != 0) {
            string12 = monitor.responseContentType;
        }
        if ((n2 & 0x10000) != 0) {
            l4 = monitor.responseContentLength;
        }
        if ((n2 & 0x20000) != 0) {
            l5 = monitor.responseDate;
        }
        if ((n2 & 0x40000) != 0) {
            string13 = monitor.responseTlsVersion;
        }
        if ((n2 & 0x80000) != 0) {
            string14 = monitor.responseCipherSuite;
        }
        if ((n2 & 0x100000) != 0) {
            n = monitor.responseCode;
        }
        if ((n2 & 0x200000) != 0) {
            string15 = monitor.responseMessage;
        }
        if ((n2 & 0x400000) != 0) {
            string16 = monitor.error;
        }
        return monitor.copy(l, string2, string3, string4, string5, string6, string7, string8, list, string9, string10, l2, l3, list2, string11, string12, l4, l5, string13, string14, n, string15, string16);
    }

    @NotNull
    public String toString() {
        return "Monitor(id=" + this.id + ", url=" + this.url + ", scheme=" + this.scheme + ", host=" + this.host + ", path=" + this.path + ", query=" + this.query + ", protocol=" + this.protocol + ", method=" + this.method + ", requestHeaders=" + this.requestHeaders + ", requestBody=" + this.requestBody + ", requestContentType=" + this.requestContentType + ", requestContentLength=" + this.requestContentLength + ", requestDate=" + this.requestDate + ", responseHeaders=" + this.responseHeaders + ", responseBody=" + this.responseBody + ", responseContentType=" + this.responseContentType + ", responseContentLength=" + this.responseContentLength + ", responseDate=" + this.responseDate + ", responseTlsVersion=" + this.responseTlsVersion + ", responseCipherSuite=" + this.responseCipherSuite + ", responseCode=" + this.responseCode + ", responseMessage=" + this.responseMessage + ", error=" + this.error + ")";
    }

    public int hashCode() {
        int result = Long.hashCode(this.id);
        result = result * 31 + this.url.hashCode();
        result = result * 31 + this.scheme.hashCode();
        result = result * 31 + this.host.hashCode();
        result = result * 31 + this.path.hashCode();
        result = result * 31 + this.query.hashCode();
        result = result * 31 + this.protocol.hashCode();
        result = result * 31 + this.method.hashCode();
        result = result * 31 + ((Object)this.requestHeaders).hashCode();
        result = result * 31 + (this.requestBody == null ? 0 : this.requestBody.hashCode());
        result = result * 31 + this.requestContentType.hashCode();
        result = result * 31 + Long.hashCode(this.requestContentLength);
        result = result * 31 + Long.hashCode(this.requestDate);
        result = result * 31 + ((Object)this.responseHeaders).hashCode();
        result = result * 31 + (this.responseBody == null ? 0 : this.responseBody.hashCode());
        result = result * 31 + this.responseContentType.hashCode();
        result = result * 31 + Long.hashCode(this.responseContentLength);
        result = result * 31 + Long.hashCode(this.responseDate);
        result = result * 31 + this.responseTlsVersion.hashCode();
        result = result * 31 + this.responseCipherSuite.hashCode();
        result = result * 31 + Integer.hashCode(this.responseCode);
        result = result * 31 + this.responseMessage.hashCode();
        result = result * 31 + (this.error == null ? 0 : this.error.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Monitor)) {
            return false;
        }
        Monitor monitor = (Monitor)other;
        if (this.id != monitor.id) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.url, (Object)monitor.url)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.scheme, (Object)monitor.scheme)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.host, (Object)monitor.host)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.path, (Object)monitor.path)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.query, (Object)monitor.query)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.protocol, (Object)monitor.protocol)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.method, (Object)monitor.method)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.requestHeaders, monitor.requestHeaders)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.requestBody, (Object)monitor.requestBody)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.requestContentType, (Object)monitor.requestContentType)) {
            return false;
        }
        if (this.requestContentLength != monitor.requestContentLength) {
            return false;
        }
        if (this.requestDate != monitor.requestDate) {
            return false;
        }
        if (!Intrinsics.areEqual(this.responseHeaders, monitor.responseHeaders)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.responseBody, (Object)monitor.responseBody)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.responseContentType, (Object)monitor.responseContentType)) {
            return false;
        }
        if (this.responseContentLength != monitor.responseContentLength) {
            return false;
        }
        if (this.responseDate != monitor.responseDate) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.responseTlsVersion, (Object)monitor.responseTlsVersion)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.responseCipherSuite, (Object)monitor.responseCipherSuite)) {
            return false;
        }
        if (this.responseCode != monitor.responseCode) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.responseMessage, (Object)monitor.responseMessage)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.error, (Object)monitor.error);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lgithub/leavesczy/monitor/internal/db/Monitor$Companion;", "", "()V", "DEFAULT_RESPONSE_CODE", "", "monitor_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MonitorStatus.values().length];
            try {
                nArray[MonitorStatus.Requesting.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MonitorStatus.Complete.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MonitorStatus.Failed.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

