/*
 * Decompiled with CFR 0.152.
 */
package github.leavesczy.monitor.internal.db;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import github.leavesczy.monitor.internal.db.Monitor;
import github.leavesczy.monitor.internal.db.MonitorDao;
import github.leavesczy.monitor.internal.db.MonitorPair;
import github.leavesczy.monitor.internal.db.MonitorTypeConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

public final class MonitorDao_Impl
implements MonitorDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<Monitor> __insertionAdapterOfMonitor;
    private final MonitorTypeConverter __monitorTypeConverter = new MonitorTypeConverter();
    private final EntityDeletionOrUpdateAdapter<Monitor> __updateAdapterOfMonitor;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public MonitorDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfMonitor = new EntityInsertionAdapter<Monitor>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR ABORT INTO `MonitorHttp` (`id`,`url`,`scheme`,`host`,`path`,`query`,`protocol`,`method`,`requestHeaders`,`requestBody`,`requestContentType`,`requestContentLength`,`requestDate`,`responseHeaders`,`responseBody`,`responseContentType`,`responseContentLength`,`responseDate`,`responseTlsVersion`,`responseCipherSuite`,`responseCode`,`responseMessage`,`error`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull Monitor entity) {
                statement.bindLong(1, entity.getId());
                statement.bindString(2, entity.getUrl());
                statement.bindString(3, entity.getScheme());
                statement.bindString(4, entity.getHost());
                statement.bindString(5, entity.getPath());
                statement.bindString(6, entity.getQuery());
                statement.bindString(7, entity.getProtocol());
                statement.bindString(8, entity.getMethod());
                String _tmp = MonitorDao_Impl.this.__monitorTypeConverter.toJson(entity.getRequestHeaders());
                statement.bindString(9, _tmp);
                if (entity.getRequestBody() == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindString(10, entity.getRequestBody());
                }
                statement.bindString(11, entity.getRequestContentType());
                statement.bindLong(12, entity.getRequestContentLength());
                statement.bindLong(13, entity.getRequestDate());
                String _tmp_1 = MonitorDao_Impl.this.__monitorTypeConverter.toJson(entity.getResponseHeaders());
                statement.bindString(14, _tmp_1);
                if (entity.getResponseBody() == null) {
                    statement.bindNull(15);
                } else {
                    statement.bindString(15, entity.getResponseBody());
                }
                statement.bindString(16, entity.getResponseContentType());
                statement.bindLong(17, entity.getResponseContentLength());
                statement.bindLong(18, entity.getResponseDate());
                statement.bindString(19, entity.getResponseTlsVersion());
                statement.bindString(20, entity.getResponseCipherSuite());
                statement.bindLong(21, (long)entity.getResponseCode());
                statement.bindString(22, entity.getResponseMessage());
                if (entity.getError() == null) {
                    statement.bindNull(23);
                } else {
                    statement.bindString(23, entity.getError());
                }
            }
        };
        this.__updateAdapterOfMonitor = new EntityDeletionOrUpdateAdapter<Monitor>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `MonitorHttp` SET `id` = ?,`url` = ?,`scheme` = ?,`host` = ?,`path` = ?,`query` = ?,`protocol` = ?,`method` = ?,`requestHeaders` = ?,`requestBody` = ?,`requestContentType` = ?,`requestContentLength` = ?,`requestDate` = ?,`responseHeaders` = ?,`responseBody` = ?,`responseContentType` = ?,`responseContentLength` = ?,`responseDate` = ?,`responseTlsVersion` = ?,`responseCipherSuite` = ?,`responseCode` = ?,`responseMessage` = ?,`error` = ? WHERE `id` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull Monitor entity) {
                statement.bindLong(1, entity.getId());
                statement.bindString(2, entity.getUrl());
                statement.bindString(3, entity.getScheme());
                statement.bindString(4, entity.getHost());
                statement.bindString(5, entity.getPath());
                statement.bindString(6, entity.getQuery());
                statement.bindString(7, entity.getProtocol());
                statement.bindString(8, entity.getMethod());
                String _tmp = MonitorDao_Impl.this.__monitorTypeConverter.toJson(entity.getRequestHeaders());
                statement.bindString(9, _tmp);
                if (entity.getRequestBody() == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindString(10, entity.getRequestBody());
                }
                statement.bindString(11, entity.getRequestContentType());
                statement.bindLong(12, entity.getRequestContentLength());
                statement.bindLong(13, entity.getRequestDate());
                String _tmp_1 = MonitorDao_Impl.this.__monitorTypeConverter.toJson(entity.getResponseHeaders());
                statement.bindString(14, _tmp_1);
                if (entity.getResponseBody() == null) {
                    statement.bindNull(15);
                } else {
                    statement.bindString(15, entity.getResponseBody());
                }
                statement.bindString(16, entity.getResponseContentType());
                statement.bindLong(17, entity.getResponseContentLength());
                statement.bindLong(18, entity.getResponseDate());
                statement.bindString(19, entity.getResponseTlsVersion());
                statement.bindString(20, entity.getResponseCipherSuite());
                statement.bindLong(21, (long)entity.getResponseCode());
                statement.bindString(22, entity.getResponseMessage());
                if (entity.getError() == null) {
                    statement.bindNull(23);
                } else {
                    statement.bindString(23, entity.getError());
                }
                statement.bindLong(24, entity.getId());
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "delete from MonitorHttp";
                return "delete from MonitorHttp";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(Monitor monitor) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result = this.__insertionAdapterOfMonitor.insertAndReturnId((Object)monitor);
            this.__db.setTransactionSuccessful();
            long l = _result;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(Monitor monitor) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfMonitor.handle((Object)monitor);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public Object deleteAll(Continuation<? super Unit> $completion) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            @NonNull
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = MonitorDao_Impl.this.__preparedStmtOfDeleteAll.acquire();
                try {
                    Unit unit;
                    MonitorDao_Impl.this.__db.beginTransaction();
                    try {
                        _stmt.executeUpdateDelete();
                        MonitorDao_Impl.this.__db.setTransactionSuccessful();
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        MonitorDao_Impl.this.__db.endTransaction();
                        throw throwable;
                    }
                    MonitorDao_Impl.this.__db.endTransaction();
                    return unit;
                }
                finally {
                    MonitorDao_Impl.this.__preparedStmtOfDeleteAll.release(_stmt);
                }
            }
        }, $completion);
    }

    @Override
    public Object query(long id, Continuation<? super Monitor> $completion) {
        String _sql = "select * from MonitorHttp where id =?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from MonitorHttp where id =?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, id);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<Monitor>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Monitor call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)MonitorDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    Monitor _result;
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"url");
                    int _cursorIndexOfScheme = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheme");
                    int _cursorIndexOfHost = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"host");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfQuery = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"query");
                    int _cursorIndexOfProtocol = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"protocol");
                    int _cursorIndexOfMethod = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"method");
                    int _cursorIndexOfRequestHeaders = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestHeaders");
                    int _cursorIndexOfRequestBody = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestBody");
                    int _cursorIndexOfRequestContentType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestContentType");
                    int _cursorIndexOfRequestContentLength = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestContentLength");
                    int _cursorIndexOfRequestDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestDate");
                    int _cursorIndexOfResponseHeaders = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseHeaders");
                    int _cursorIndexOfResponseBody = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseBody");
                    int _cursorIndexOfResponseContentType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseContentType");
                    int _cursorIndexOfResponseContentLength = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseContentLength");
                    int _cursorIndexOfResponseDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseDate");
                    int _cursorIndexOfResponseTlsVersion = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseTlsVersion");
                    int _cursorIndexOfResponseCipherSuite = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseCipherSuite");
                    int _cursorIndexOfResponseCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseCode");
                    int _cursorIndexOfResponseMessage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseMessage");
                    int _cursorIndexOfError = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"error");
                    if (_cursor.moveToFirst()) {
                        long _tmpId = _cursor.getLong(_cursorIndexOfId);
                        String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                        String _tmpScheme = _cursor.getString(_cursorIndexOfScheme);
                        String _tmpHost = _cursor.getString(_cursorIndexOfHost);
                        String _tmpPath = _cursor.getString(_cursorIndexOfPath);
                        String _tmpQuery = _cursor.getString(_cursorIndexOfQuery);
                        String _tmpProtocol = _cursor.getString(_cursorIndexOfProtocol);
                        String _tmpMethod = _cursor.getString(_cursorIndexOfMethod);
                        String _tmp = _cursor.getString(_cursorIndexOfRequestHeaders);
                        List<MonitorPair> _tmpRequestHeaders = MonitorDao_Impl.this.__monitorTypeConverter.fromJsonArray(_tmp);
                        String _tmpRequestBody = _cursor.isNull(_cursorIndexOfRequestBody) ? null : _cursor.getString(_cursorIndexOfRequestBody);
                        String _tmpRequestContentType = _cursor.getString(_cursorIndexOfRequestContentType);
                        long _tmpRequestContentLength = _cursor.getLong(_cursorIndexOfRequestContentLength);
                        long _tmpRequestDate = _cursor.getLong(_cursorIndexOfRequestDate);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfResponseHeaders);
                        List<MonitorPair> _tmpResponseHeaders = MonitorDao_Impl.this.__monitorTypeConverter.fromJsonArray(_tmp_1);
                        String _tmpResponseBody = _cursor.isNull(_cursorIndexOfResponseBody) ? null : _cursor.getString(_cursorIndexOfResponseBody);
                        String _tmpResponseContentType = _cursor.getString(_cursorIndexOfResponseContentType);
                        long _tmpResponseContentLength = _cursor.getLong(_cursorIndexOfResponseContentLength);
                        long _tmpResponseDate = _cursor.getLong(_cursorIndexOfResponseDate);
                        String _tmpResponseTlsVersion = _cursor.getString(_cursorIndexOfResponseTlsVersion);
                        String _tmpResponseCipherSuite = _cursor.getString(_cursorIndexOfResponseCipherSuite);
                        int _tmpResponseCode = _cursor.getInt(_cursorIndexOfResponseCode);
                        String _tmpResponseMessage = _cursor.getString(_cursorIndexOfResponseMessage);
                        String _tmpError = _cursor.isNull(_cursorIndexOfError) ? null : _cursor.getString(_cursorIndexOfError);
                        _result = new Monitor(_tmpId, _tmpUrl, _tmpScheme, _tmpHost, _tmpPath, _tmpQuery, _tmpProtocol, _tmpMethod, _tmpRequestHeaders, _tmpRequestBody, _tmpRequestContentType, _tmpRequestContentLength, _tmpRequestDate, _tmpResponseHeaders, _tmpResponseBody, _tmpResponseContentType, _tmpResponseContentLength, _tmpResponseDate, _tmpResponseTlsVersion, _tmpResponseCipherSuite, _tmpResponseCode, _tmpResponseMessage, _tmpError);
                    } else {
                        _result = null;
                    }
                    Monitor monitor = _result;
                    return monitor;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, $completion);
    }

    @Override
    public Flow<Monitor> queryFlow(long id) {
        String _sql = "select * from MonitorHttp where id =?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from MonitorHttp where id =?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, id);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"MonitorHttp"}, (Callable)new Callable<Monitor>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public Monitor call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)MonitorDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    Monitor _result;
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"url");
                    int _cursorIndexOfScheme = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheme");
                    int _cursorIndexOfHost = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"host");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfQuery = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"query");
                    int _cursorIndexOfProtocol = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"protocol");
                    int _cursorIndexOfMethod = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"method");
                    int _cursorIndexOfRequestHeaders = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestHeaders");
                    int _cursorIndexOfRequestBody = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestBody");
                    int _cursorIndexOfRequestContentType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestContentType");
                    int _cursorIndexOfRequestContentLength = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestContentLength");
                    int _cursorIndexOfRequestDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestDate");
                    int _cursorIndexOfResponseHeaders = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseHeaders");
                    int _cursorIndexOfResponseBody = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseBody");
                    int _cursorIndexOfResponseContentType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseContentType");
                    int _cursorIndexOfResponseContentLength = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseContentLength");
                    int _cursorIndexOfResponseDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseDate");
                    int _cursorIndexOfResponseTlsVersion = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseTlsVersion");
                    int _cursorIndexOfResponseCipherSuite = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseCipherSuite");
                    int _cursorIndexOfResponseCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseCode");
                    int _cursorIndexOfResponseMessage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseMessage");
                    int _cursorIndexOfError = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"error");
                    if (_cursor.moveToFirst()) {
                        long _tmpId = _cursor.getLong(_cursorIndexOfId);
                        String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                        String _tmpScheme = _cursor.getString(_cursorIndexOfScheme);
                        String _tmpHost = _cursor.getString(_cursorIndexOfHost);
                        String _tmpPath = _cursor.getString(_cursorIndexOfPath);
                        String _tmpQuery = _cursor.getString(_cursorIndexOfQuery);
                        String _tmpProtocol = _cursor.getString(_cursorIndexOfProtocol);
                        String _tmpMethod = _cursor.getString(_cursorIndexOfMethod);
                        String _tmp = _cursor.getString(_cursorIndexOfRequestHeaders);
                        List<MonitorPair> _tmpRequestHeaders = MonitorDao_Impl.this.__monitorTypeConverter.fromJsonArray(_tmp);
                        String _tmpRequestBody = _cursor.isNull(_cursorIndexOfRequestBody) ? null : _cursor.getString(_cursorIndexOfRequestBody);
                        String _tmpRequestContentType = _cursor.getString(_cursorIndexOfRequestContentType);
                        long _tmpRequestContentLength = _cursor.getLong(_cursorIndexOfRequestContentLength);
                        long _tmpRequestDate = _cursor.getLong(_cursorIndexOfRequestDate);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfResponseHeaders);
                        List<MonitorPair> _tmpResponseHeaders = MonitorDao_Impl.this.__monitorTypeConverter.fromJsonArray(_tmp_1);
                        String _tmpResponseBody = _cursor.isNull(_cursorIndexOfResponseBody) ? null : _cursor.getString(_cursorIndexOfResponseBody);
                        String _tmpResponseContentType = _cursor.getString(_cursorIndexOfResponseContentType);
                        long _tmpResponseContentLength = _cursor.getLong(_cursorIndexOfResponseContentLength);
                        long _tmpResponseDate = _cursor.getLong(_cursorIndexOfResponseDate);
                        String _tmpResponseTlsVersion = _cursor.getString(_cursorIndexOfResponseTlsVersion);
                        String _tmpResponseCipherSuite = _cursor.getString(_cursorIndexOfResponseCipherSuite);
                        int _tmpResponseCode = _cursor.getInt(_cursorIndexOfResponseCode);
                        String _tmpResponseMessage = _cursor.getString(_cursorIndexOfResponseMessage);
                        String _tmpError = _cursor.isNull(_cursorIndexOfError) ? null : _cursor.getString(_cursorIndexOfError);
                        _result = new Monitor(_tmpId, _tmpUrl, _tmpScheme, _tmpHost, _tmpPath, _tmpQuery, _tmpProtocol, _tmpMethod, _tmpRequestHeaders, _tmpRequestBody, _tmpRequestContentType, _tmpRequestContentLength, _tmpRequestDate, _tmpResponseHeaders, _tmpResponseBody, _tmpResponseContentType, _tmpResponseContentLength, _tmpResponseDate, _tmpResponseTlsVersion, _tmpResponseCipherSuite, _tmpResponseCode, _tmpResponseMessage, _tmpError);
                    } else {
                        _result = null;
                    }
                    Monitor monitor = _result;
                    return monitor;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flow<List<Monitor>> queryFlow(int limit) {
        String _sql = "select * from MonitorHttp order by id desc limit ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from MonitorHttp order by id desc limit ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)limit);
        return CoroutinesRoom.createFlow((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"MonitorHttp"}, (Callable)new Callable<List<Monitor>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NonNull
            public List<Monitor> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)MonitorDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfUrl = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"url");
                    int _cursorIndexOfScheme = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scheme");
                    int _cursorIndexOfHost = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"host");
                    int _cursorIndexOfPath = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"path");
                    int _cursorIndexOfQuery = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"query");
                    int _cursorIndexOfProtocol = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"protocol");
                    int _cursorIndexOfMethod = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"method");
                    int _cursorIndexOfRequestHeaders = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestHeaders");
                    int _cursorIndexOfRequestBody = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestBody");
                    int _cursorIndexOfRequestContentType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestContentType");
                    int _cursorIndexOfRequestContentLength = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestContentLength");
                    int _cursorIndexOfRequestDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"requestDate");
                    int _cursorIndexOfResponseHeaders = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseHeaders");
                    int _cursorIndexOfResponseBody = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseBody");
                    int _cursorIndexOfResponseContentType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseContentType");
                    int _cursorIndexOfResponseContentLength = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseContentLength");
                    int _cursorIndexOfResponseDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseDate");
                    int _cursorIndexOfResponseTlsVersion = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseTlsVersion");
                    int _cursorIndexOfResponseCipherSuite = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseCipherSuite");
                    int _cursorIndexOfResponseCode = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseCode");
                    int _cursorIndexOfResponseMessage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"responseMessage");
                    int _cursorIndexOfError = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"error");
                    ArrayList<Monitor> _result = new ArrayList<Monitor>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        long _tmpId = _cursor.getLong(_cursorIndexOfId);
                        String _tmpUrl = _cursor.getString(_cursorIndexOfUrl);
                        String _tmpScheme = _cursor.getString(_cursorIndexOfScheme);
                        String _tmpHost = _cursor.getString(_cursorIndexOfHost);
                        String _tmpPath = _cursor.getString(_cursorIndexOfPath);
                        String _tmpQuery = _cursor.getString(_cursorIndexOfQuery);
                        String _tmpProtocol = _cursor.getString(_cursorIndexOfProtocol);
                        String _tmpMethod = _cursor.getString(_cursorIndexOfMethod);
                        String _tmp = _cursor.getString(_cursorIndexOfRequestHeaders);
                        List<MonitorPair> _tmpRequestHeaders = MonitorDao_Impl.this.__monitorTypeConverter.fromJsonArray(_tmp);
                        String _tmpRequestBody = _cursor.isNull(_cursorIndexOfRequestBody) ? null : _cursor.getString(_cursorIndexOfRequestBody);
                        String _tmpRequestContentType = _cursor.getString(_cursorIndexOfRequestContentType);
                        long _tmpRequestContentLength = _cursor.getLong(_cursorIndexOfRequestContentLength);
                        long _tmpRequestDate = _cursor.getLong(_cursorIndexOfRequestDate);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfResponseHeaders);
                        List<MonitorPair> _tmpResponseHeaders = MonitorDao_Impl.this.__monitorTypeConverter.fromJsonArray(_tmp_1);
                        String _tmpResponseBody = _cursor.isNull(_cursorIndexOfResponseBody) ? null : _cursor.getString(_cursorIndexOfResponseBody);
                        String _tmpResponseContentType = _cursor.getString(_cursorIndexOfResponseContentType);
                        long _tmpResponseContentLength = _cursor.getLong(_cursorIndexOfResponseContentLength);
                        long _tmpResponseDate = _cursor.getLong(_cursorIndexOfResponseDate);
                        String _tmpResponseTlsVersion = _cursor.getString(_cursorIndexOfResponseTlsVersion);
                        String _tmpResponseCipherSuite = _cursor.getString(_cursorIndexOfResponseCipherSuite);
                        int _tmpResponseCode = _cursor.getInt(_cursorIndexOfResponseCode);
                        String _tmpResponseMessage = _cursor.getString(_cursorIndexOfResponseMessage);
                        String _tmpError = _cursor.isNull(_cursorIndexOfError) ? null : _cursor.getString(_cursorIndexOfError);
                        Monitor _item = new Monitor(_tmpId, _tmpUrl, _tmpScheme, _tmpHost, _tmpPath, _tmpQuery, _tmpProtocol, _tmpMethod, _tmpRequestHeaders, _tmpRequestBody, _tmpRequestContentType, _tmpRequestContentLength, _tmpRequestDate, _tmpResponseHeaders, _tmpResponseBody, _tmpResponseContentType, _tmpResponseContentLength, _tmpResponseDate, _tmpResponseTlsVersion, _tmpResponseCipherSuite, _tmpResponseCode, _tmpResponseMessage, _tmpError);
                        _result.add(_item);
                    }
                    ArrayList<Monitor> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

