/*
 * Decompiled with CFR 0.152.
 */
package github.leavesczy.monitor.internal.db;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.migration.AutoMigrationSpec;
import androidx.room.migration.Migration;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import github.leavesczy.monitor.internal.db.MonitorDao;
import github.leavesczy.monitor.internal.db.MonitorDao_Impl;
import github.leavesczy.monitor.internal.db.MonitorDatabase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class MonitorDatabase_Impl
extends MonitorDatabase {
    private volatile MonitorDao _monitorDao;

    @NonNull
    protected SupportSQLiteOpenHelper createOpenHelper(@NonNull DatabaseConfiguration config) {
        RoomOpenHelper _openCallback = new RoomOpenHelper(config, new RoomOpenHelper.Delegate(35){

            public void createAllTables(@NonNull SupportSQLiteDatabase db) {
                db.execSQL("CREATE TABLE IF NOT EXISTS `MonitorHttp` (`id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `url` TEXT NOT NULL, `scheme` TEXT NOT NULL, `host` TEXT NOT NULL, `path` TEXT NOT NULL, `query` TEXT NOT NULL, `protocol` TEXT NOT NULL, `method` TEXT NOT NULL, `requestHeaders` TEXT NOT NULL, `requestBody` TEXT, `requestContentType` TEXT NOT NULL, `requestContentLength` INTEGER NOT NULL, `requestDate` INTEGER NOT NULL, `responseHeaders` TEXT NOT NULL, `responseBody` TEXT, `responseContentType` TEXT NOT NULL, `responseContentLength` INTEGER NOT NULL, `responseDate` INTEGER NOT NULL, `responseTlsVersion` TEXT NOT NULL, `responseCipherSuite` TEXT NOT NULL, `responseCode` INTEGER NOT NULL, `responseMessage` TEXT NOT NULL, `error` TEXT)");
                db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
                db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, '394157e88d91181878212d91a5178ad2')");
            }

            public void dropAllTables(@NonNull SupportSQLiteDatabase db) {
                db.execSQL("DROP TABLE IF EXISTS `MonitorHttp`");
                List _callbacks = MonitorDatabase_Impl.this.mCallbacks;
                if (_callbacks != null) {
                    for (RoomDatabase.Callback _callback : _callbacks) {
                        _callback.onDestructiveMigration(db);
                    }
                }
            }

            public void onCreate(@NonNull SupportSQLiteDatabase db) {
                List _callbacks = MonitorDatabase_Impl.this.mCallbacks;
                if (_callbacks != null) {
                    for (RoomDatabase.Callback _callback : _callbacks) {
                        _callback.onCreate(db);
                    }
                }
            }

            public void onOpen(@NonNull SupportSQLiteDatabase db) {
                MonitorDatabase_Impl.this.mDatabase = db;
                MonitorDatabase_Impl.this.internalInitInvalidationTracker(db);
                List _callbacks = MonitorDatabase_Impl.this.mCallbacks;
                if (_callbacks != null) {
                    for (RoomDatabase.Callback _callback : _callbacks) {
                        _callback.onOpen(db);
                    }
                }
            }

            public void onPreMigrate(@NonNull SupportSQLiteDatabase db) {
                DBUtil.dropFtsSyncTriggers((SupportSQLiteDatabase)db);
            }

            public void onPostMigrate(@NonNull SupportSQLiteDatabase db) {
            }

            @NonNull
            public RoomOpenHelper.ValidationResult onValidateSchema(@NonNull SupportSQLiteDatabase db) {
                HashMap<String, TableInfo.Column> _columnsMonitorHttp = new HashMap<String, TableInfo.Column>(23);
                _columnsMonitorHttp.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, 1));
                _columnsMonitorHttp.put("url", new TableInfo.Column("url", "TEXT", true, 0, null, 1));
                _columnsMonitorHttp.put("scheme", new TableInfo.Column("scheme", "TEXT", true, 0, null, 1));
                _columnsMonitorHttp.put("host", new TableInfo.Column("host", "TEXT", true, 0, null, 1));
                _columnsMonitorHttp.put("path", new TableInfo.Column("path", "TEXT", true, 0, null, 1));
                _columnsMonitorHttp.put("query", new TableInfo.Column("query", "TEXT", true, 0, null, 1));
                _columnsMonitorHttp.put("protocol", new TableInfo.Column("protocol", "TEXT", true, 0, null, 1));
                _columnsMonitorHttp.put("method", new TableInfo.Column("method", "TEXT", true, 0, null, 1));
                _columnsMonitorHttp.put("requestHeaders", new TableInfo.Column("requestHeaders", "TEXT", true, 0, null, 1));
                _columnsMonitorHttp.put("requestBody", new TableInfo.Column("requestBody", "TEXT", false, 0, null, 1));
                _columnsMonitorHttp.put("requestContentType", new TableInfo.Column("requestContentType", "TEXT", true, 0, null, 1));
                _columnsMonitorHttp.put("requestContentLength", new TableInfo.Column("requestContentLength", "INTEGER", true, 0, null, 1));
                _columnsMonitorHttp.put("requestDate", new TableInfo.Column("requestDate", "INTEGER", true, 0, null, 1));
                _columnsMonitorHttp.put("responseHeaders", new TableInfo.Column("responseHeaders", "TEXT", true, 0, null, 1));
                _columnsMonitorHttp.put("responseBody", new TableInfo.Column("responseBody", "TEXT", false, 0, null, 1));
                _columnsMonitorHttp.put("responseContentType", new TableInfo.Column("responseContentType", "TEXT", true, 0, null, 1));
                _columnsMonitorHttp.put("responseContentLength", new TableInfo.Column("responseContentLength", "INTEGER", true, 0, null, 1));
                _columnsMonitorHttp.put("responseDate", new TableInfo.Column("responseDate", "INTEGER", true, 0, null, 1));
                _columnsMonitorHttp.put("responseTlsVersion", new TableInfo.Column("responseTlsVersion", "TEXT", true, 0, null, 1));
                _columnsMonitorHttp.put("responseCipherSuite", new TableInfo.Column("responseCipherSuite", "TEXT", true, 0, null, 1));
                _columnsMonitorHttp.put("responseCode", new TableInfo.Column("responseCode", "INTEGER", true, 0, null, 1));
                _columnsMonitorHttp.put("responseMessage", new TableInfo.Column("responseMessage", "TEXT", true, 0, null, 1));
                _columnsMonitorHttp.put("error", new TableInfo.Column("error", "TEXT", false, 0, null, 1));
                HashSet _foreignKeysMonitorHttp = new HashSet(0);
                HashSet _indicesMonitorHttp = new HashSet(0);
                TableInfo _infoMonitorHttp = new TableInfo("MonitorHttp", _columnsMonitorHttp, _foreignKeysMonitorHttp, _indicesMonitorHttp);
                TableInfo _existingMonitorHttp = TableInfo.read((SupportSQLiteDatabase)db, (String)"MonitorHttp");
                if (!_infoMonitorHttp.equals((Object)_existingMonitorHttp)) {
                    return new RoomOpenHelper.ValidationResult(false, "MonitorHttp(github.leavesczy.monitor.internal.db.Monitor).\n Expected:\n" + _infoMonitorHttp + "\n Found:\n" + _existingMonitorHttp);
                }
                return new RoomOpenHelper.ValidationResult(true, null);
            }
        }, "394157e88d91181878212d91a5178ad2", "eca971dc8036eddb7be260b8f0831740");
        SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder((Context)config.context).name(config.name).callback((SupportSQLiteOpenHelper.Callback)_openCallback).build();
        SupportSQLiteOpenHelper _helper = config.sqliteOpenHelperFactory.create(_sqliteConfig);
        return _helper;
    }

    @NonNull
    protected InvalidationTracker createInvalidationTracker() {
        HashMap _shadowTablesMap = new HashMap(0);
        HashMap _viewTables = new HashMap(0);
        return new InvalidationTracker((RoomDatabase)this, _shadowTablesMap, _viewTables, new String[]{"MonitorHttp"});
    }

    public void clearAllTables() {
        super.assertNotMainThread();
        SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
        try {
            super.beginTransaction();
            _db.execSQL("DELETE FROM `MonitorHttp`");
            super.setTransactionSuccessful();
        }
        finally {
            super.endTransaction();
            _db.query("PRAGMA wal_checkpoint(FULL)").close();
            if (!_db.inTransaction()) {
                _db.execSQL("VACUUM");
            }
        }
    }

    @NonNull
    protected Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
        HashMap _typeConvertersMap = new HashMap();
        _typeConvertersMap.put(MonitorDao.class, MonitorDao_Impl.getRequiredConverters());
        return _typeConvertersMap;
    }

    @NonNull
    public Set<Class<? extends AutoMigrationSpec>> getRequiredAutoMigrationSpecs() {
        HashSet<Class<? extends AutoMigrationSpec>> _autoMigrationSpecsSet = new HashSet<Class<? extends AutoMigrationSpec>>();
        return _autoMigrationSpecsSet;
    }

    @NonNull
    public List<Migration> getAutoMigrations(@NonNull Map<Class<? extends AutoMigrationSpec>, AutoMigrationSpec> autoMigrationSpecs) {
        ArrayList<Migration> _autoMigrations = new ArrayList<Migration>();
        return _autoMigrations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MonitorDao getMonitorDao() {
        if (this._monitorDao != null) {
            return this._monitorDao;
        }
        MonitorDatabase_Impl monitorDatabase_Impl = this;
        synchronized (monitorDatabase_Impl) {
            if (this._monitorDao == null) {
                this._monitorDao = new MonitorDao_Impl(this);
            }
            return this._monitorDao;
        }
    }
}

