/*
 * Decompiled with CFR 0.152.
 */
package io.github.lemonsalve.sfxnavigator;

import io.github.lemonsalve.sfxnavigator.analyzers.NavigationNodeAnalyzer;
import io.github.lemonsalve.sfxnavigator.contexts.ApplicationContext;
import io.github.lemonsalve.sfxnavigator.contexts.NavigationContext;
import io.github.lemonsalve.sfxnavigator.contexts.RoutesContext;
import io.github.lemonsalve.sfxnavigator.exceptions.RouteRendererNotFoundException;
import io.github.lemonsalve.sfxnavigator.exceptions.SceneCreationFailedException;
import io.github.lemonsalve.sfxnavigator.routes.Route;
import io.github.lemonsalve.sfxnavigator.routes.RouteConfiguration;
import io.github.lemonsalve.sfxnavigator.routes.RouteHistory;
import java.io.IOException;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class Navigator {
    private final ApplicationContext appContext;
    private final RouteHistory routeHistory;
    private final RoutesContext routesContext;
    private final NavigationNodeAnalyzer navigationNodeAnalyzer;
    private final Class<? extends Application> fxAppClass;
    private Stage primaryStage;

    public Navigator(ApplicationContext appContext, RouteHistory routeHistory, RoutesContext routesContext, NavigationNodeAnalyzer navigationNodeAnalyzer, Class<? extends Application> fxAppClass) {
        this.appContext = appContext;
        this.routeHistory = routeHistory;
        this.routesContext = routesContext;
        this.navigationNodeAnalyzer = navigationNodeAnalyzer;
        this.fxAppClass = fxAppClass;
    }

    public void init(Stage stage) {
        this.primaryStage = stage;
    }

    public void navigateTo(@NotNull String routeName) {
        Route route = this.routesContext.findRoute(routeName);
        Route nextRoute = this.executeGuard(route);
        while (!nextRoute.equals(route)) {
            route = nextRoute;
            nextRoute = this.executeGuard(route);
        }
        Route parentRoute = this.routesContext.findParentRoute(nextRoute.name());
        if (parentRoute == null) {
            this.loadBaseRoute(route);
            return;
        }
        Route parentNextRoute = this.executeGuard(parentRoute);
        if (!parentNextRoute.equals(parentRoute) && !this.routeHistory.getHistory().contains(parentNextRoute.name())) {
            this.navigateTo(parentNextRoute.name());
            return;
        }
        Route actualParentRoute = parentRoute;
        if (!actualParentRoute.equals(nextRoute)) {
            this.loadParentRoute(parentRoute);
        }
        this.loadChildRoute(nextRoute);
    }

    private void loadBaseRoute(@NotNull Route route) {
        Scene scene;
        FXMLLoader loader = this.getFXMLLoader(route);
        RouteConfiguration routeConfiguration = route.configuration();
        try {
            scene = new Scene((Parent)loader.load(), (double)routeConfiguration.width().intValue(), (double)routeConfiguration.height().intValue());
        }
        catch (IOException e) {
            throw new SceneCreationFailedException("Failed to create scene", e);
        }
        this.onNavigateAction(route, scene, true);
    }

    private void loadParentRoute(@NotNull Route parentRoute) {
        Scene scene;
        FXMLLoader loader = this.getFXMLLoader(parentRoute);
        RouteConfiguration parentConfiguration = parentRoute.configuration();
        try {
            scene = new Scene((Parent)loader.load(), (double)parentConfiguration.width().intValue(), (double)parentConfiguration.height().intValue());
        }
        catch (IOException e) {
            throw new SceneCreationFailedException("Failed to create parent scene", e);
        }
        this.onNavigateAction(parentRoute, scene, false);
    }

    private void loadChildRoute(@NotNull Route childRoute) {
        FXMLLoader loader = this.getFXMLLoader(childRoute);
        try {
            BorderPane parentRoot = (BorderPane)this.primaryStage.getScene().lookup("#routeRenderer");
            if (parentRoot == null) {
                throw new RouteRendererNotFoundException("No BorderPane with id 'routeRenderer' found in the parent scene.");
            }
            BorderPane childPane = (BorderPane)loader.load();
            parentRoot.setCenter((Node)childPane);
        }
        catch (IOException e) {
            throw new SceneCreationFailedException("Failed to create child scene", e);
        }
        this.routeHistory.add(childRoute.name());
        this.navigationNodeAnalyzer.analyzeNodeAndCreateHandlers(this.primaryStage.getScene(), this::navigateTo);
        this.primaryStage.setResizable(false);
        this.setWindowTitle(childRoute.title());
        this.primaryStage.show();
    }

    public Route executeGuard(@NotNull Route route) {
        return route.guard().protect().apply(this.getNavigationContext(), route);
    }

    private void onNavigateAction(@NotNull Route route, Scene scene, boolean addToHistory) {
        if (addToHistory) {
            this.routeHistory.add(route.name());
        }
        this.navigationNodeAnalyzer.analyzeNodeAndCreateHandlers(scene, this::navigateTo);
        this.primaryStage.setScene(scene);
        this.primaryStage.setResizable(false);
        this.setWindowTitle(route.title());
        this.primaryStage.show();
    }

    @Contract(value="_ -> new")
    @NotNull
    private FXMLLoader getFXMLLoader(@NotNull Route route) {
        FXMLLoader loader = new FXMLLoader(this.fxAppClass.getResource(route.path()));
        loader.setControllerFactory(this.appContext::getBean);
        return loader;
    }

    public NavigationContext getNavigationContext() {
        return new NavigationContext(this.appContext, this.routesContext, this.routeHistory);
    }

    private void setWindowTitle(String title) {
        this.primaryStage.setTitle("");
        this.primaryStage.setTitle(title);
    }
}

