/*
 * Decompiled with CFR 0.152.
 */
package io.github.lemonsalve.sfxnavigator.analyzers;

import io.github.lemonsalve.sfxnavigator.contexts.RoutesContext;
import io.github.lemonsalve.sfxnavigator.routes.Route;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.MouseEvent;
import org.jetbrains.annotations.NotNull;

public class NavigationNodeAnalyzer {
    private static final String NAVIGATE_TO_PREFIX = "navigateTo";
    private final Map<Node, Route> navigationNodes = new HashMap<Node, Route>();
    private final RoutesContext routesContext;

    public NavigationNodeAnalyzer(RoutesContext routesContext) {
        this.routesContext = routesContext;
    }

    public void analyzeNodeAndCreateHandlers(@NotNull Scene scene, Consumer<String> navigationConsumer) {
        this.analyzeNode((Node)scene.getRoot());
        this.createNavigationHandlers(navigationConsumer);
    }

    private void analyzeNode(Node node) {
        if (node instanceof Parent) {
            Parent parent = (Parent)node;
            for (Node child : parent.getChildrenUnmodifiable()) {
                this.analyzeNode(child);
            }
        }
        if (!this.isNavigationNode(node)) {
            return;
        }
        String routeName = this.getRouteName(node);
        Route route = this.routesContext.findRoute(routeName);
        this.navigationNodes.put(node, route);
    }

    private void createNavigationHandlers(Consumer<String> navigationConsumer) {
        this.navigationNodes.forEach((node, route) -> this.createNavigationHandler((Node)node, (Route)route, navigationConsumer));
        this.navigationNodes.clear();
    }

    private void createNavigationHandler(@NotNull Node node, @NotNull Route route, @NotNull Consumer<String> navigationConsumer) {
        node.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> navigationConsumer.accept(route.name()));
    }

    private boolean isNavigationNode(@NotNull Node node) {
        return node.getId() != null && node.getId().startsWith(NAVIGATE_TO_PREFIX);
    }

    @NotNull
    private String getRouteName(@NotNull Node node) {
        return node.getId().substring(NAVIGATE_TO_PREFIX.length());
    }
}

