/*
 * Decompiled with CFR 0.152.
 */
package io.github.lemonsalve.sfxnavigator.contexts;

import io.github.lemonsalve.sfxnavigator.exceptions.RouteNotFoundException;
import io.github.lemonsalve.sfxnavigator.routes.Route;
import io.github.lemonsalve.sfxnavigator.utils.RouteFinder;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RoutesContext {
    private final List<Route> routes;

    public RoutesContext(List<Route> routes) {
        this.routes = routes;
    }

    public Route findRoute(@NotNull String routeName) {
        return this.routes.stream().map(route -> this.findRouteRecursive((Route)route, routeName)).filter(Objects::nonNull).findFirst().orElseThrow(() -> new RouteNotFoundException("Route not found: " + routeName));
    }

    @Nullable
    private Route findRouteRecursive(@NotNull Route route, String routeName) {
        if (route.name().equals(routeName)) {
            return route;
        }
        for (Route childRoute : route.childRoutes()) {
            Route found = this.findRouteRecursive(childRoute, routeName);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public Route findParentRoute(String routeName) {
        Route route = this.findRoute(routeName);
        return RouteFinder.findParent(route, this.routes);
    }

    public boolean hasParentRoute(String routeName) {
        return this.findParentRoute(routeName) != null;
    }
}

