/*
 * Decompiled with CFR 0.152.
 */
package ktx.assets;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.utils.ObjectSet;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ktx.assets.Asset;
import ktx.assets.AssetGroup;
import ktx.assets.DelayedAsset;
import ktx.assets.ManagedAsset;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J5\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00110\r\"\n\b\u0000\u0010\u0011\u0018\u0001*\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00052\u0010\b\u0002\u0010\u0013\u001a\n\u0012\u0004\u0012\u0002H\u0011\u0018\u00010\u0014H\u0084\bJ5\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00110\r\"\n\b\u0000\u0010\u0011\u0018\u0001*\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00052\u0010\b\u0002\u0010\u0013\u001a\n\u0012\u0004\u0012\u0002H\u0011\u0018\u00010\u0014H\u0084\bJ\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0017J\u0006\u0010\u001b\u001a\u00020\u0017J*\u0010\u001c\u001a\u00020\u00172\"\b\u0002\u0010\u001d\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\b\u0012\u00060\u001fj\u0002` \u0012\u0004\u0012\u00020\u00170\u001eJ\u0006\u0010!\u001a\u00020\u0019R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\""}, d2={"Lktx/assets/AssetGroup;", "", "manager", "Lcom/badlogic/gdx/assets/AssetManager;", "filePrefix", "", "(Lcom/badlogic/gdx/assets/AssetManager;Ljava/lang/String;)V", "getFilePrefix", "()Ljava/lang/String;", "getManager", "()Lcom/badlogic/gdx/assets/AssetManager;", "members", "Lcom/badlogic/gdx/utils/ObjectSet;", "Lktx/assets/Asset;", "getMembers", "()Lcom/badlogic/gdx/utils/ObjectSet;", "asset", "T", "fileName", "params", "Lcom/badlogic/gdx/assets/AssetLoaderParameters;", "delayedAsset", "finishLoading", "", "isLoaded", "", "loadAll", "unloadAll", "unloadAllSafely", "onError", "Lkotlin/Function2;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "update", "ktx-assets"})
@SourceDebugExtension(value={"SMAP\nassets.kt\nKotlin\n*S Kotlin\n*F\n+ 1 assets.kt\nktx/assets/AssetGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 assets.kt\nktx/assets/AssetsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,318:1\n1726#2,3:319\n118#3,3:322\n141#3:326\n1#4:325\n*S KotlinDebug\n*F\n+ 1 assets.kt\nktx/assets/AssetGroup\n*L\n294#1:319,3\n304#1:322,3\n316#1:326\n*E\n"})
public abstract class AssetGroup {
    @NotNull
    private final AssetManager manager;
    @NotNull
    private final String filePrefix;
    @NotNull
    private final ObjectSet<Asset<?>> members;

    public AssetGroup(@NotNull AssetManager manager, @NotNull String filePrefix) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)filePrefix, (String)"filePrefix");
        this.manager = manager;
        this.filePrefix = filePrefix;
        this.members = new ObjectSet();
    }

    public /* synthetic */ AssetGroup(AssetManager assetManager, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "";
        }
        this(assetManager, string);
    }

    @NotNull
    public final AssetManager getManager() {
        return this.manager;
    }

    @NotNull
    protected final String getFilePrefix() {
        return this.filePrefix;
    }

    @NotNull
    protected final ObjectSet<Asset<?>> getMembers() {
        return this.members;
    }

    public final void loadAll() {
        for (Asset member : this.members) {
            member.load();
        }
    }

    public final void unloadAll() {
        for (Asset member : this.members) {
            member.unload();
        }
    }

    public final void unloadAllSafely(@NotNull Function2<? super Asset<?>, ? super Exception, Unit> onError) {
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        for (Asset member : this.members) {
            try {
                member.unload();
            }
            catch (Exception exception) {
                Intrinsics.checkNotNull((Object)member);
                onError.invoke((Object)member, (Object)exception);
            }
        }
    }

    public static /* synthetic */ void unloadAllSafely$default(AssetGroup assetGroup, Function2 function2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: unloadAllSafely");
        }
        if ((n & 1) != 0) {
            function2 = unloadAllSafely.1.INSTANCE;
        }
        assetGroup.unloadAllSafely(function2);
    }

    public final boolean update() {
        return this.isLoaded() || this.manager.update();
    }

    public final void finishLoading() {
        for (Asset member : this.members) {
            this.manager.finishLoadingAsset(member.getAssetDescriptor());
        }
    }

    public final boolean isLoaded() {
        boolean bl;
        block3: {
            Iterable $this$all$iv = (Iterable)this.members;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Asset it = (Asset)element$iv;
                    boolean bl2 = false;
                    if (it.isLoaded()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    protected final /* synthetic */ <T> Asset<T> asset(String fileName, AssetLoaderParameters<T> params) {
        void $this$load$iv;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        boolean $i$f$asset = false;
        Object object = this.getManager();
        String path$iv = this.filePrefix + fileName;
        boolean $i$f$load = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        AssetDescriptor assetDescriptor$iv = new AssetDescriptor(path$iv, Object.class, params);
        $this$load$iv.load(assetDescriptor$iv);
        object = new ManagedAsset((AssetManager)$this$load$iv, assetDescriptor$iv);
        Asset it = (Asset)object;
        boolean bl = false;
        this.members.add((Object)it);
        return (Asset)object;
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ Asset asset$default(AssetGroup $this, String fileName, AssetLoaderParameters params, int n, Object object) {
        void $this$load$iv;
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: asset");
        }
        if ((n & 2) != 0) {
            params = null;
        }
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        boolean $i$f$asset = false;
        object = $this.getManager();
        String path$iv = $this.filePrefix + fileName;
        boolean $i$f$load = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        AssetDescriptor assetDescriptor$iv = new AssetDescriptor(path$iv, Object.class, params);
        $this$load$iv.load(assetDescriptor$iv);
        object = new ManagedAsset((AssetManager)$this$load$iv, assetDescriptor$iv);
        Asset it = (Asset)object;
        boolean bl = false;
        $this.members.add((Object)it);
        return (Asset)object;
    }

    /*
     * WARNING - void declaration
     */
    protected final /* synthetic */ <T> Asset<T> delayedAsset(String fileName, AssetLoaderParameters<T> params) {
        void $this$loadOnDemand$iv;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        boolean $i$f$delayedAsset = false;
        Object object = this.getManager();
        String path$iv = this.filePrefix + fileName;
        boolean $i$f$loadOnDemand = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        object = new DelayedAsset((AssetManager)$this$loadOnDemand$iv, new AssetDescriptor(path$iv, Object.class, params));
        Asset it = (Asset)object;
        boolean bl = false;
        this.members.add((Object)it);
        return (Asset)object;
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ Asset delayedAsset$default(AssetGroup $this, String fileName, AssetLoaderParameters params, int n, Object object) {
        void $this$loadOnDemand$iv;
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: delayedAsset");
        }
        if ((n & 2) != 0) {
            params = null;
        }
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        boolean $i$f$delayedAsset = false;
        object = $this.getManager();
        String path$iv = $this.filePrefix + fileName;
        boolean $i$f$loadOnDemand = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        object = new DelayedAsset((AssetManager)$this$loadOnDemand$iv, new AssetDescriptor(path$iv, Object.class, params));
        Asset it = (Asset)object;
        boolean bl = false;
        $this.members.add((Object)it);
        return (Asset)object;
    }
}

