/*
 * Decompiled with CFR 0.152.
 */
package ktx.assets;

import com.badlogic.gdx.utils.Disposable;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ktx.assets.DisposableRegistry;
import ktx.assets.DisposablesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lktx/assets/DisposableContainer;", "Lktx/assets/DisposableRegistry;", "()V", "registeredDisposables", "", "Lcom/badlogic/gdx/utils/Disposable;", "getRegisteredDisposables", "()Ljava/util/List;", "registry", "", "deregister", "", "disposable", "deregisterAll", "dispose", "", "register", "ktx-assets"})
public class DisposableContainer
implements DisposableRegistry {
    @NotNull
    private final Set<Disposable> registry;

    public DisposableContainer() {
        Set set = Collections.newSetFromMap(new IdentityHashMap());
        Intrinsics.checkNotNullExpressionValue(set, (String)"newSetFromMap(...)");
        this.registry = set;
    }

    @Override
    @NotNull
    public List<Disposable> getRegisteredDisposables() {
        return CollectionsKt.toList((Iterable)this.registry);
    }

    @Override
    public boolean register(@NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        return this.registry.add(disposable);
    }

    @Override
    public boolean deregister(@NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        return this.registry.remove(disposable);
    }

    @Override
    public boolean deregisterAll() {
        boolean hadItems = !((Collection)this.registry).isEmpty();
        this.registry.clear();
        return hadItems;
    }

    @Override
    public void dispose() {
        DisposablesKt.dispose((Iterable)this.registry);
    }

    @Override
    @NotNull
    public <T extends Disposable> T alsoRegister(@NotNull T $this$alsoRegister) {
        return DisposableRegistry.DefaultImpls.alsoRegister(this, $this$alsoRegister);
    }

    @Override
    @NotNull
    public <T extends Disposable> T alsoDeregister(@NotNull T $this$alsoDeregister) {
        return DisposableRegistry.DefaultImpls.alsoDeregister(this, $this$alsoDeregister);
    }
}

