/*
 * Decompiled with CFR 0.152.
 */
package ktx.log;

import com.badlogic.gdx.Gdx;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J'\u0010\u000f\u001a\u00020\u00102\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0000J/\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0002 \u0000J'\u0010\u0014\u001a\u00020\u00102\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0000J/\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0002 \u0000J'\u0010\u0015\u001a\u00020\u00102\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0000J/\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0002 \u0000J\u001a\u0010\u0016\u001a\u00020\u00102\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0086\n\u00f8\u0001\u0000J\"\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0086\n\u00f8\u0001\u0000R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0017"}, d2={"Lktx/log/Logger;", "", "name", "", "debugTag", "infoTag", "errorTag", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getDebugTag", "()Ljava/lang/String;", "getErrorTag", "getInfoTag", "getName", "buildMessage", "message", "debug", "", "Lkotlin/Function0;", "cause", "", "error", "info", "invoke", "ktx-log"})
public class Logger {
    @NotNull
    private final String name;
    @NotNull
    private final String debugTag;
    @NotNull
    private final String infoTag;
    @NotNull
    private final String errorTag;

    public Logger(@NotNull String name, @NotNull String debugTag, @NotNull String infoTag, @NotNull String errorTag) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)debugTag, (String)"debugTag");
        Intrinsics.checkNotNullParameter((Object)infoTag, (String)"infoTag");
        Intrinsics.checkNotNullParameter((Object)errorTag, (String)"errorTag");
        this.name = name;
        this.debugTag = debugTag;
        this.infoTag = infoTag;
        this.errorTag = errorTag;
    }

    public /* synthetic */ Logger(String string, String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = "DEBUG";
        }
        if ((n & 4) != 0) {
            string3 = "INFO";
        }
        if ((n & 8) != 0) {
            string4 = "ERROR";
        }
        this(string, string2, string3, string4);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getDebugTag() {
        return this.debugTag;
    }

    @NotNull
    public String getInfoTag() {
        return this.infoTag;
    }

    @NotNull
    public String getErrorTag() {
        return this.errorTag;
    }

    @NotNull
    public String buildMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return this.getName() + " - " + message;
    }

    public final void invoke(@NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        boolean $i$f$invoke = false;
        if (Gdx.app.getLogLevel() >= 2) {
            Gdx.app.log(this.getInfoTag(), this.buildMessage((String)message.invoke()));
        }
    }

    public final void invoke(@NotNull Throwable cause, @NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        Intrinsics.checkNotNullParameter(message, (String)"message");
        boolean $i$f$invoke = false;
        if (Gdx.app.getLogLevel() >= 2) {
            Gdx.app.log(this.getInfoTag(), this.buildMessage((String)message.invoke()), cause);
        }
    }

    public final void debug(@NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        boolean $i$f$debug = false;
        if (Gdx.app.getLogLevel() >= 3) {
            Gdx.app.debug(this.getDebugTag(), this.buildMessage((String)message.invoke()));
        }
    }

    public final void debug(@NotNull Throwable cause, @NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        Intrinsics.checkNotNullParameter(message, (String)"message");
        boolean $i$f$debug = false;
        if (Gdx.app.getLogLevel() >= 3) {
            Gdx.app.debug(this.getDebugTag(), this.buildMessage((String)message.invoke()), cause);
        }
    }

    public final void info(@NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        boolean $i$f$info = false;
        if (Gdx.app.getLogLevel() >= 2) {
            Gdx.app.log(this.getInfoTag(), this.buildMessage((String)message.invoke()));
        }
    }

    public final void info(@NotNull Throwable cause, @NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        Intrinsics.checkNotNullParameter(message, (String)"message");
        boolean $i$f$info = false;
        if (Gdx.app.getLogLevel() >= 2) {
            Gdx.app.log(this.getInfoTag(), this.buildMessage((String)message.invoke()), cause);
        }
    }

    public final void error(@NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        boolean $i$f$error = false;
        if (Gdx.app.getLogLevel() >= 1) {
            Gdx.app.error(this.getErrorTag(), this.buildMessage((String)message.invoke()));
        }
    }

    public final void error(@NotNull Throwable cause, @NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        Intrinsics.checkNotNullParameter(message, (String)"message");
        boolean $i$f$error = false;
        if (Gdx.app.getLogLevel() >= 1) {
            Gdx.app.error(this.getErrorTag(), this.buildMessage((String)message.invoke()), cause);
        }
    }
}

