/*
 * Decompiled with CFR 0.152.
 */
package com.orion.http.apache;

import com.orion.http.BaseHttpResponse;
import com.orion.http.support.HttpCookie;
import com.orion.lang.define.collect.MutableArrayList;
import com.orion.lang.define.mutable.MutableString;
import com.orion.lang.utils.Strings;
import com.orion.lang.utils.io.Streams;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;

public class ApacheResponse
extends BaseHttpResponse
implements Serializable {
    private final HttpResponse response;
    private final String url;
    private byte[] body;

    public ApacheResponse(String url, HttpResponse response) throws IOException {
        this.url = url;
        this.response = response;
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            this.body = Streams.toByteArray((InputStream)entity.getContent());
        }
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public String getUrl() {
        return this.url;
    }

    public int getCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    public String getMessage() {
        return this.response.getStatusLine().getReasonPhrase();
    }

    @Override
    public byte[] getBody() {
        return this.body;
    }

    @Override
    public String getBodyString() {
        if (this.body != null) {
            return new String(this.body);
        }
        return null;
    }

    public Map<String, MutableArrayList<String>> getHeaders() {
        LinkedHashMap<String, MutableArrayList<String>> headers = new LinkedHashMap<String, MutableArrayList<String>>();
        for (Header header : this.response.getAllHeaders()) {
            MutableArrayList list = headers.computeIfAbsent(header.getName(), k -> new MutableArrayList());
            list.add((Object)header.getValue());
        }
        return headers;
    }

    public MutableArrayList<String> getHeaders(String key) {
        MutableArrayList list = new MutableArrayList();
        for (Header header : this.response.getHeaders(key)) {
            list.add((Object)header.getValue());
        }
        return list;
    }

    public MutableString getHeader(String key) {
        Header header = this.response.getFirstHeader(key);
        if (header != null) {
            return new MutableString(header.getValue());
        }
        return new MutableString();
    }

    public MutableString getHeader(String key, String def) {
        Header header = this.response.getFirstHeader(key);
        if (header != null) {
            return new MutableString(header.getValue());
        }
        return new MutableString(def);
    }

    public List<HttpCookie> getCookies() {
        ArrayList<HttpCookie> list = new ArrayList<HttpCookie>();
        for (Header header : this.response.getHeaders("Set-Cookie")) {
            list.add(new HttpCookie(header.getValue()));
        }
        return list;
    }

    public String toString() {
        return this.getCode() + " " + Strings.def((String)this.getMessage());
    }
}

