/*
 * Decompiled with CFR 0.152.
 */
package com.orion.http.apache;

import com.orion.http.BaseHttpRequest;
import com.orion.http.apache.ApacheResponse;
import com.orion.http.support.HttpContentType;
import com.orion.http.support.HttpMethod;
import com.orion.lang.able.Awaitable;
import com.orion.lang.utils.Charsets;
import java.util.ArrayList;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;

public abstract class BaseApacheRequest
extends BaseHttpRequest
implements Awaitable<ApacheResponse> {
    protected CloseableHttpClient client;
    protected HttpRequestBase request;

    public BaseApacheRequest client(CloseableHttpClient client) {
        this.client = client;
        return this;
    }

    public BaseApacheRequest cancel() {
        this.request.abort();
        return this;
    }

    @Override
    protected void buildRequest() {
        super.buildRequest();
        this.getRequestByMethod();
        if (this.headers != null) {
            this.headers.forEach((k, v) -> this.request.addHeader((Header)new BasicHeader(k, v)));
        }
        if (this.cookies != null) {
            this.cookies.forEach(c -> this.request.addHeader((Header)new BasicHeader("Cookie", c.toString())));
        }
        if (this.ignoreHeaders != null) {
            this.ignoreHeaders.forEach(ignoreHeader -> this.request.removeHeader((Header)new BasicHeader(ignoreHeader, null)));
        }
        if (!super.isNoBodyRequest()) {
            return;
        }
        this.request.setHeader((Header)new BasicHeader("Content-Type", this.contentType + "; charset=" + this.charset));
    }

    protected void getRequestByMethod() {
        HttpMethod.valid(this.method);
        if (HttpMethod.POST.method().equals(this.method)) {
            this.request = new HttpPost(this.url);
        } else if (HttpMethod.PATCH.method().equals(this.method)) {
            this.request = new HttpPatch(this.url);
        } else if (HttpMethod.PUT.method().equals(this.method)) {
            this.request = new HttpPut(this.url);
        } else if (HttpMethod.GET.method().equals(this.method)) {
            this.request = new HttpGet(this.url);
        } else if (HttpMethod.DELETE.method().equals(this.method)) {
            this.request = new HttpDelete(this.url);
        } else if (HttpMethod.HEAD.method().equals(this.method)) {
            this.request = new HttpHead(this.url);
        } else if (HttpMethod.TRACE.method().equals(this.method)) {
            this.request = new HttpTrace(this.url);
        } else if (HttpMethod.OPTIONS.method().equals(this.method)) {
            this.request = new HttpOptions(this.url);
        }
        if (this.request instanceof HttpEntityEnclosingRequestBase) {
            ((HttpEntityEnclosingRequestBase)this.request).setEntity(this.getEntry());
        }
    }

    protected HttpEntity getEntry() {
        if (this.body != null) {
            return new ByteArrayEntity(this.body, this.bodyOffset, this.bodyLen);
        }
        if (this.formParts != null) {
            ArrayList pairs = new ArrayList();
            this.formParts.forEach((k, v) -> pairs.add(new BasicNameValuePair(k, v)));
            this.contentType = HttpContentType.APPLICATION_FORM.getType();
            return new UrlEncodedFormEntity(pairs, Charsets.of((String)this.charset));
        }
        return null;
    }

    public CloseableHttpClient getClient() {
        return this.client;
    }
}

