/*
 * Decompiled with CFR 0.152.
 */
package com.orion.http.apache.file;

import com.orion.http.apache.ApacheRequest;
import com.orion.http.apache.ApacheResponse;
import com.orion.lang.utils.io.Files1;
import com.orion.lang.utils.io.Streams;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.http.impl.client.CloseableHttpClient;

public class ApacheDownload {
    private final ApacheRequest request;
    private ApacheResponse response;

    public ApacheDownload(String url) {
        this(new ApacheRequest(url), null);
    }

    public ApacheDownload(String url, CloseableHttpClient client) {
        this(new ApacheRequest(url), client);
    }

    public ApacheDownload(ApacheRequest request) {
        this(request, null);
    }

    public ApacheDownload(ApacheRequest request, CloseableHttpClient client) {
        this.request = request;
        if (client != null) {
            this.request.client(client);
        }
    }

    public ApacheDownload client(CloseableHttpClient client) {
        this.request.client(client);
        return this;
    }

    public ApacheDownload download(String file) throws IOException {
        Files1.touch((String)file);
        this.download(Files1.openOutputStream((String)file), true);
        return this;
    }

    public ApacheDownload download(File file) throws IOException {
        Files1.touch((File)file);
        this.download(Files1.openOutputStream((File)file), true);
        return this;
    }

    public ApacheDownload download(OutputStream out) throws IOException {
        this.download(out, false);
        return this;
    }

    public ApacheDownload download(OutputStream out, boolean autoClose) throws IOException {
        this.response = this.request.await();
        out.write(this.response.getBody());
        if (autoClose) {
            Streams.close((AutoCloseable)out);
        }
        return this;
    }

    public ApacheRequest getRequest() {
        return this.request;
    }

    public ApacheResponse getResponse() {
        return this.response;
    }
}

