/*
 * Decompiled with CFR 0.152.
 */
package com.orion.http.ok;

import com.orion.http.ok.OkLoggerInterceptor;
import com.orion.lang.able.Buildable;
import com.orion.lang.utils.collect.Lists;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionSpec;
import okhttp3.CookieJar;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class OkClientBuilder
implements Buildable<OkHttpClient> {
    private long callTimeout = 15000L;
    private long connectTimeout = 10000L;
    private long readTimeout = 15000L;
    private long writeTimeout = 15000L;
    private boolean logInterceptor;
    private CookieJar cookies;
    private String proxyHost;
    private int proxyPort;
    private int maxRoute = 12;
    private int maxRequest = 64;
    private List<Interceptor> interceptors;
    private List<Interceptor> networkInterceptors;
    private ExecutorService dispatcherPool;
    private Dispatcher dispatcher;
    private SSLSocketFactory sslSocketFactory;
    private X509TrustManager trustManager;
    private List<ConnectionSpec> connectionSpecs;

    public static OkClientBuilder create() {
        return new OkClientBuilder();
    }

    public OkClientBuilder proxy(String host, int port) {
        this.proxyHost = host;
        this.proxyPort = port;
        return this;
    }

    public OkClientBuilder cookies(CookieJar cookies) {
        this.cookies = cookies;
        return this;
    }

    public OkClientBuilder logInterceptor(boolean open) {
        this.logInterceptor = open;
        return this;
    }

    public OkClientBuilder logInterceptor() {
        this.logInterceptor = true;
        return this;
    }

    public OkClientBuilder interceptor(Interceptor interceptor) {
        if (this.interceptors == null) {
            this.interceptors = new ArrayList<Interceptor>();
        }
        this.interceptors.add(interceptor);
        return this;
    }

    public OkClientBuilder networkInterceptor(Interceptor interceptor) {
        if (this.networkInterceptors == null) {
            this.networkInterceptors = new ArrayList<Interceptor>();
        }
        this.networkInterceptors.add(interceptor);
        return this;
    }

    public OkClientBuilder callTimeout(long callTimeout) {
        this.callTimeout = callTimeout;
        return this;
    }

    public OkClientBuilder connectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public OkClientBuilder readTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public OkClientBuilder writeTimeout(long writeTimeout) {
        this.writeTimeout = writeTimeout;
        return this;
    }

    public OkClientBuilder maxRoute(int maxRoute) {
        this.maxRoute = maxRoute;
        return this;
    }

    public OkClientBuilder maxRequest(int maxRequest) {
        this.maxRequest = maxRequest;
        return this;
    }

    public OkClientBuilder dispatcherPool(ExecutorService dispatcherPool) {
        this.dispatcherPool = dispatcherPool;
        return this;
    }

    public OkClientBuilder dispatcher(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
        return this;
    }

    public OkClientBuilder sslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
        return this;
    }

    public OkClientBuilder trustManager(X509TrustManager trustManager) {
        this.trustManager = trustManager;
        return this;
    }

    public OkClientBuilder connectionSpecs(List<ConnectionSpec> connectionSpecs) {
        if (this.connectionSpecs == null) {
            this.connectionSpecs = connectionSpecs;
        } else {
            this.connectionSpecs.addAll(connectionSpecs);
        }
        return this;
    }

    public OkClientBuilder connectionSpecs(ConnectionSpec connectionSpec) {
        if (this.connectionSpecs == null) {
            this.connectionSpecs = new ArrayList<ConnectionSpec>();
        }
        this.connectionSpecs.add(connectionSpec);
        return this;
    }

    public long getCallTimeout() {
        return this.callTimeout;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public long getWriteTimeout() {
        return this.writeTimeout;
    }

    public boolean isLogInterceptor() {
        return this.logInterceptor;
    }

    public CookieJar getCookies() {
        return this.cookies;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public int getMaxRoute() {
        return this.maxRoute;
    }

    public int getMaxRequest() {
        return this.maxRequest;
    }

    public ExecutorService getDispatcherPool() {
        return this.dispatcherPool;
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public X509TrustManager getTrustManager() {
        return this.trustManager;
    }

    public List<ConnectionSpec> getConnectionSpecs() {
        return this.connectionSpecs;
    }

    public OkHttpClient.Builder buildClientBuilder() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().callTimeout(this.callTimeout, TimeUnit.MILLISECONDS).connectTimeout(this.connectTimeout, TimeUnit.MILLISECONDS).readTimeout(this.readTimeout, TimeUnit.MILLISECONDS).writeTimeout(this.writeTimeout, TimeUnit.MILLISECONDS);
        if (this.dispatcher != null) {
            builder.dispatcher(this.dispatcher);
        } else if (this.dispatcherPool != null || this.maxRoute != 0 || this.maxRequest != 0) {
            this.dispatcher = this.dispatcherPool != null ? new Dispatcher(this.dispatcherPool) : new Dispatcher();
            if (this.maxRoute != 0) {
                this.dispatcher.setMaxRequestsPerHost(this.maxRoute);
            }
            if (this.maxRequest != 0) {
                this.dispatcher.setMaxRequests(this.maxRequest);
            }
            builder.dispatcher(this.dispatcher);
        }
        if (this.logInterceptor) {
            builder.addInterceptor((Interceptor)new OkLoggerInterceptor());
        }
        if (!Lists.isEmpty(this.interceptors)) {
            this.interceptors.forEach(arg_0 -> ((OkHttpClient.Builder)builder).addInterceptor(arg_0));
        }
        if (!Lists.isEmpty(this.networkInterceptors)) {
            this.interceptors.forEach(arg_0 -> ((OkHttpClient.Builder)builder).addNetworkInterceptor(arg_0));
        }
        if (this.proxyHost != null && this.proxyPort != 0) {
            builder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyHost, this.proxyPort)));
        }
        if (this.cookies != null) {
            builder.cookieJar(this.cookies);
        }
        if (this.sslSocketFactory != null && this.trustManager != null) {
            builder.sslSocketFactory(this.sslSocketFactory, this.trustManager);
        }
        if (this.connectionSpecs != null) {
            builder.connectionSpecs(this.connectionSpecs);
        }
        return builder;
    }

    public OkHttpClient build() {
        return this.buildClientBuilder().build();
    }

    public String toString() {
        return "OkHttpConfig{callTimeout=" + this.callTimeout + ", connectTimeout=" + this.connectTimeout + ", readTimeout=" + this.readTimeout + ", writeTimeout=" + this.writeTimeout + ", logInterceptor=" + this.logInterceptor + ", proxyHost='" + this.proxyHost + '\'' + ", proxyPort=" + this.proxyPort + '}';
    }
}

