/*
 * Decompiled with CFR 0.152.
 */
package com.orion.http.ok;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;

public class OkCookieStore
implements CookieJar {
    private final ArrayList<Cookie> defaultList = new ArrayList();
    private final Map<String, List<Cookie>> urlCookies = new HashMap<String, List<Cookie>>();

    public void saveFromResponse(HttpUrl url, List<Cookie> cookies) {
    }

    public List<Cookie> loadForRequest(HttpUrl url) {
        ArrayList clone = (ArrayList)this.defaultList.clone();
        List<Cookie> cookies = this.urlCookies.get(url.toString());
        if (cookies != null) {
            clone.addAll(cookies);
        }
        return clone;
    }

    public OkCookieStore addCookie(Cookie cookie) {
        this.defaultList.add(cookie);
        return this;
    }

    public OkCookieStore addCookies(Collection<Cookie> cookies) {
        this.defaultList.addAll(cookies);
        return this;
    }

    public OkCookieStore addCookie(String url, Cookie cookie) {
        List cookies = this.urlCookies.computeIfAbsent(url, k -> new ArrayList());
        cookies.add(cookie);
        return this;
    }

    public OkCookieStore addCookie(String url, Collection<Cookie> cookies) {
        List store = this.urlCookies.computeIfAbsent(url, k -> new ArrayList());
        store.addAll(cookies);
        return this;
    }

    public OkCookieStore addCookie(String key, String value, String domain) {
        this.defaultList.add(new Cookie.Builder().name(key).value(value).domain(domain).build());
        return this;
    }

    public OkCookieStore addCookie(Map<String, String> cookies, String domain) {
        cookies.forEach((k, v) -> this.defaultList.add(new Cookie.Builder().name(k).value(v).domain(domain).build()));
        return this;
    }

    public OkCookieStore addCookie(String url, String key, String value, String domain) {
        List cookies = this.urlCookies.computeIfAbsent(url, k -> new ArrayList());
        cookies.add(new Cookie.Builder().name(key).value(value).domain(domain).build());
        return this;
    }

    public OkCookieStore addCookie(String url, Map<String, String> cookies, String domain) {
        List store = this.urlCookies.computeIfAbsent(url, k -> new ArrayList());
        cookies.forEach((k, v) -> store.add(new Cookie.Builder().name(k).value(v).domain(domain).build()));
        return this;
    }
}

