/*
 * Decompiled with CFR 0.152.
 */
package com.orion.http.ok;

import com.orion.http.BaseHttpResponse;
import com.orion.http.support.HttpCookie;
import com.orion.lang.define.mutable.MutableString;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Strings;
import com.orion.lang.utils.Valid;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class OkResponse
extends BaseHttpResponse
implements Serializable {
    private Response response;
    private final String url;
    private final Object tag;
    private byte[] body;
    private Exception exception;
    private volatile boolean done;

    public OkResponse(String url, Object tag) {
        this.done = false;
        this.url = url;
        this.tag = tag;
    }

    public OkResponse(String url, Object tag, Response response) {
        this.done = true;
        this.url = url;
        this.tag = tag;
        this.response = response;
        this.setBody();
    }

    public void asyncSetResponse(Response response) {
        this.asyncSetResponse(response, true);
    }

    public void asyncSetResponse(Response response, boolean setBody) {
        this.done = true;
        this.response = response;
        if (setBody) {
            this.setBody();
        }
    }

    public void error(Exception exception) {
        this.done = true;
        this.exception = exception;
    }

    public String getUrl() {
        return this.url;
    }

    public int getCode() {
        this.validDone();
        return this.response.code();
    }

    public String getMessage() {
        this.validDone();
        return this.response.message();
    }

    @Override
    public byte[] getBody() {
        this.validDone();
        return this.body;
    }

    @Override
    public String getBodyString() {
        this.validDone();
        return new String(this.body);
    }

    public Response getResponse() {
        return this.response;
    }

    public Exception getException() {
        return this.exception;
    }

    public Object getTag() {
        return this.tag;
    }

    public Map<String, List<String>> getHeaders() {
        this.validDone();
        return this.response.headers().toMultimap();
    }

    public List<String> getHeaders(String key) {
        this.validDone();
        return this.response.headers(key);
    }

    public MutableString getHeader(String key) {
        this.validDone();
        return new MutableString(this.response.header(key));
    }

    public MutableString getHeader(String key, String def) {
        this.validDone();
        return new MutableString(this.response.header(key, def));
    }

    public List<HttpCookie> getCookies() {
        ArrayList<HttpCookie> list = new ArrayList<HttpCookie>();
        for (String value : this.response.headers().values("Set-Cookie")) {
            list.add(new HttpCookie(value));
        }
        return list;
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean isError() {
        return this.exception != null;
    }

    public boolean isOk() {
        this.validDone();
        return super.isOk();
    }

    private void validDone() {
        Valid.isTrue((boolean)this.done, (String)"ok request is not done", (Object[])new Object[0]);
    }

    private void setBody() {
        try {
            ResponseBody b = this.response.body();
            if (b != null) {
                this.body = b.bytes();
            }
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime((String)"ok response get body error", (Throwable)e);
        }
    }

    public String toString() {
        return this.getCode() + " " + Strings.def((String)this.getMessage());
    }
}

