/*
 * Decompiled with CFR 0.152.
 */
package com.orion.http.parse;

import com.orion.http.BaseHttpResponse;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Strings;
import java.io.IOException;
import java.io.Serializable;
import org.jsoup.Connection;
import org.jsoup.nodes.Document;

public class ParseResponse
extends BaseHttpResponse
implements Serializable {
    private final Connection.Response response;
    private final byte[] body;
    private final String url;
    private Document document;

    public ParseResponse(String url, Connection.Response response) {
        this.url = url;
        this.response = response;
        this.body = response.bodyAsBytes();
    }

    public ParseResponse parse() {
        try {
            this.document = this.response.parse();
            return this;
        }
        catch (IOException e) {
            throw Exceptions.parse((Throwable)e);
        }
    }

    public String getContentType() {
        return this.response.contentType();
    }

    public String getCharset() {
        return this.response.charset();
    }

    public String getUrl() {
        return this.url;
    }

    public int getCode() {
        return this.response.statusCode();
    }

    public String getMessage() {
        return this.response.statusMessage();
    }

    @Override
    public byte[] getBody() {
        return this.body;
    }

    @Override
    public String getBodyString() {
        return new String(this.body);
    }

    public Connection.Response getResponse() {
        return this.response;
    }

    public Document getDocument() {
        return this.document;
    }

    public String toString() {
        return this.getCode() + " " + Strings.def((String)this.getMessage());
    }
}

