/*
 * Decompiled with CFR 0.152.
 */
package com.orion.http.support;

import com.orion.lang.define.collect.MutableHashMap;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.convert.Converts;
import com.orion.lang.utils.time.Dates;
import java.io.Serializable;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

public class HttpCookie
implements Serializable {
    public static final String[] EXPIRES_DATE = new String[]{"EEE, dd MMM yyyy HH:mm:ss 'GMT'", "EEE, dd-MMM-yyyy HH:mm:ss 'GMT'", "EEE, d MMM yyyy HH:mm:ss 'GMT'", "EEE, d-MMM-yyyy HH:mm:ss 'GMT'"};
    public static final String COOKIE = "Cookie";
    public static final String SET_COOKIE = "Set-Cookie";
    private MutableHashMap<String, String> values;
    private Date expires;
    private Integer maxAge;
    private String domain;
    private String path;
    private boolean secure;
    private boolean httpOnly;

    public HttpCookie() {
    }

    public HttpCookie(String cookie) {
        this.analysisCookie(cookie);
    }

    private void analysisCookie(String cookie) {
        String[] entities;
        int cookieIndex = (cookie = cookie.trim()).toLowerCase().indexOf("cookie:");
        if (cookieIndex != -1) {
            cookie = cookie.substring(cookieIndex + 7);
        }
        for (String entity : entities = cookie.split(";")) {
            this.analysisEntry(entity);
        }
    }

    private void analysisEntry(String entity) {
        String[] kv = entity.split("=");
        String key = kv[0].toLowerCase().trim();
        if (kv.length == 1) {
            switch (key) {
                case "secure": {
                    this.secure = true;
                    break;
                }
                case "httponly": {
                    this.httpOnly = true;
                    break;
                }
                default: {
                    if (this.values == null) {
                        this.values = new MutableHashMap();
                    }
                    this.values.put((Object)key, null);
                    break;
                }
            }
        } else if (kv.length == 2) {
            String value = kv[1].trim();
            switch (key) {
                case "expires": {
                    this.expires = Dates.parse((String)value, (Locale)Locale.US, (String[])EXPIRES_DATE);
                    break;
                }
                case "max-age": {
                    this.maxAge = Converts.toInt((String)value);
                    break;
                }
                case "domain": {
                    this.domain = value;
                    break;
                }
                case "path": {
                    this.path = value;
                    break;
                }
                default: {
                    if (this.values == null) {
                        this.values = new MutableHashMap();
                    }
                    this.values.put((Object)key, (Object)value);
                }
            }
        }
    }

    public HttpCookie addValue(String key, String value) {
        if (this.values == null) {
            this.values = new MutableHashMap();
        }
        this.values.put((Object)key, (Object)value);
        return this;
    }

    public MutableHashMap<String, String> getValues() {
        return this.values;
    }

    public void setValues(MutableHashMap<String, String> values) {
        this.values = values;
    }

    public Date getExpires() {
        return this.expires;
    }

    public void setExpires(Date expires) {
        this.expires = expires;
    }

    public Integer getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public void setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    public String cookie() {
        return "Cookie: " + this;
    }

    public String setCookie() {
        return "Set-Cookie: " + this;
    }

    public String toString() {
        Valid.notNull(this.values, (String)"cookies value is null", (Object[])new Object[0]);
        StringBuilder cookie = new StringBuilder();
        int i = 0;
        for (Map.Entry entry : this.values.entrySet()) {
            if (i != 0) {
                cookie.append("; ");
            }
            cookie.append((String)entry.getKey()).append("=").append((String)entry.getValue());
            ++i;
        }
        if (this.expires != null) {
            cookie.append("; ").append("expires").append("=").append(Dates.format((Date)this.expires, (String)EXPIRES_DATE[0], (Locale)Locale.US));
        }
        if (this.maxAge != null) {
            cookie.append("; ").append("max-age").append("=").append(this.maxAge);
        }
        if (this.domain != null) {
            cookie.append("; ").append("domain").append("=").append(this.domain);
        }
        if (this.path != null) {
            cookie.append("; ").append("path").append("=").append(this.path);
        }
        if (this.secure) {
            cookie.append("; ").append("secure");
        }
        if (this.httpOnly) {
            cookie.append("; ").append("HttpOnly");
        }
        return cookie.toString();
    }
}

