/*
 * Decompiled with CFR 0.152.
 */
package com.orion.http.support;

import com.orion.lang.id.UUIds;
import com.orion.lang.utils.io.Files1;
import java.io.File;
import java.io.InputStream;

public class HttpUploadPart {
    private String param;
    private String suffix;
    private String fileName;
    private String contentType = "application/octet-stream";
    private File file;
    private InputStream in;
    private byte[] bytes;
    private int off;
    private int len;

    public HttpUploadPart(String param) {
        this.param = param;
    }

    public HttpUploadPart(String param, String suffix) {
        this.param = param;
        this.suffix = suffix;
    }

    public HttpUploadPart(String param, File file) {
        this.param = param;
        this.file = file;
        this.suffix = Files1.getSuffix((File)file);
    }

    public HttpUploadPart(String param, byte[] bytes) {
        this.param = param;
        this.bytes = bytes;
        this.len = bytes.length;
    }

    public HttpUploadPart(String param, byte[] bytes, String suffix) {
        this.param = param;
        this.bytes = bytes;
        this.len = bytes.length;
        this.suffix = suffix;
    }

    public HttpUploadPart(String param, byte[] bytes, int off, int len) {
        this.param = param;
        this.bytes = bytes;
        this.off = off;
        this.len = len;
    }

    public HttpUploadPart(String param, byte[] bytes, int off, int len, String suffix) {
        this.param = param;
        this.bytes = bytes;
        this.off = off;
        this.len = len;
        this.suffix = suffix;
    }

    public HttpUploadPart(String param, InputStream in) {
        this.param = param;
        this.in = in;
    }

    public HttpUploadPart(String param, InputStream in, String suffix) {
        this.param = param;
        this.in = in;
        this.suffix = suffix;
    }

    public String getParam() {
        return this.param;
    }

    public String getFileName() {
        if (this.fileName == null) {
            if (this.file != null) {
                this.fileName = Files1.getFileName((File)this.file);
            } else {
                this.fileName = UUIds.random32();
                if (this.suffix != null) {
                    this.fileName = this.fileName + this.suffix;
                }
            }
        }
        return this.fileName;
    }

    public void setParam(String param) {
        this.param = param;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setIn(InputStream in) {
        this.in = in;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setBytes(byte[] bytes, int off, int len) {
        this.bytes = bytes;
        this.off = off;
        this.len = len;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
        this.off = 0;
        this.len = bytes.length;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public File getFile() {
        return this.file;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getOff() {
        return this.off;
    }

    public int getLen() {
        return this.len;
    }

    public InputStream getIn() {
        return this.in;
    }
}

