/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.ftp.client;

import com.orion.lang.utils.Exceptions;
import com.orion.net.ftp.client.config.FtpConfig;
import com.orion.net.ftp.client.instance.IFtpInstance;
import com.orion.net.ftp.client.pool.FtpClientFactory;
import com.orion.net.ftp.client.pool.FtpClientPool;
import org.apache.commons.net.ftp.FTPClient;

public class Ftps {
    private Ftps() {
    }

    public static void destroy(FTPClient client) {
        if (client != null && client.isConnected()) {
            try {
                client.logout();
            }
            catch (Exception e) {
                Exceptions.printStacks((Throwable)e);
            }
            finally {
                try {
                    client.disconnect();
                }
                catch (Exception e) {
                    Exceptions.printStacks((Throwable)e);
                }
            }
        }
    }

    public static boolean isActive(FTPClient client) {
        if (client != null && client.isConnected()) {
            try {
                return client.sendNoOp();
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static IFtpInstance createInstance(FtpConfig ftpConfig) {
        return new FtpClientFactory(ftpConfig).createInstance();
    }

    public static FtpClientPool createClientPool(FtpConfig ftpConfig) {
        return new FtpClientPool(new FtpClientFactory(ftpConfig));
    }

    public static FtpClientPool createClientPool(FtpConfig ftpConfig, int size) {
        return new FtpClientPool(new FtpClientFactory(ftpConfig), size);
    }
}

