/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.ftp.client.config;

import com.orion.lang.able.IJsonObject;
import com.orion.lang.utils.Charsets;
import java.io.Serializable;
import java.nio.charset.Charset;

public class FtpConfig
implements Serializable,
IJsonObject {
    private String host;
    private int port;
    private String username;
    private String password;
    private String remoteRootDir;
    private String remoteContentCharset;
    private String localContentCharset;
    private Charset remoteFileNameCharset;
    private Charset localFileNameCharset;
    private boolean showHidden;
    public int buffSize;
    private boolean passiveMode;
    private int dateTimeout;
    private int connTimeout;

    public FtpConfig(String host) {
        this(host, 21);
    }

    public FtpConfig(String host, int port) {
        this.host = host;
        this.port = port;
        this.remoteRootDir = "/";
        this.remoteContentCharset = "UTF-8";
        this.localContentCharset = "UTF-8";
        this.remoteFileNameCharset = Charsets.UTF_8;
        this.localFileNameCharset = Charsets.UTF_8;
        this.showHidden = false;
        this.buffSize = 8192;
        this.passiveMode = false;
        this.dateTimeout = 60000;
        this.connTimeout = 5000;
    }

    public FtpConfig auth(String username, String password) {
        this.username = username;
        this.password = password;
        return this;
    }

    public FtpConfig rootDir(String base) {
        this.remoteRootDir = base;
        return this;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setRemoteRootDir(String remoteRootDir) {
        this.remoteRootDir = remoteRootDir;
    }

    public void setRemoteContentCharset(String remoteContentCharset) {
        this.remoteContentCharset = remoteContentCharset;
    }

    public void setLocalContentCharset(String localContentCharset) {
        this.localContentCharset = localContentCharset;
    }

    public void setRemoteFileNameCharset(String remoteFileNameCharset) {
        this.remoteFileNameCharset = Charsets.of((String)remoteFileNameCharset);
    }

    public void setLocalFileNameCharset(String localFileNameCharset) {
        this.localFileNameCharset = Charsets.of((String)localFileNameCharset);
    }

    public void setRemoteFileNameCharset(Charset remoteFileNameCharset) {
        this.remoteFileNameCharset = remoteFileNameCharset;
    }

    public void setLocalFileNameCharset(Charset localFileNameCharset) {
        this.localFileNameCharset = localFileNameCharset;
    }

    public void setShowHidden(boolean showHidden) {
        this.showHidden = showHidden;
    }

    public void setBuffSize(int buffSize) {
        this.buffSize = buffSize;
    }

    public void setPassiveMode(boolean passiveMode) {
        this.passiveMode = passiveMode;
    }

    public void setDateTimeout(int dateTimeout) {
        this.dateTimeout = dateTimeout;
    }

    public void setConnTimeout(int connTimeout) {
        this.connTimeout = connTimeout;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getRemoteRootDir() {
        return this.remoteRootDir;
    }

    public String getRemoteContentCharset() {
        return this.remoteContentCharset;
    }

    public String getLocalContentCharset() {
        return this.localContentCharset;
    }

    public Charset getRemoteFileNameCharset() {
        return this.remoteFileNameCharset;
    }

    public Charset getLocalFileNameCharset() {
        return this.localFileNameCharset;
    }

    public boolean isShowHidden() {
        return this.showHidden;
    }

    public int getBuffSize() {
        return this.buffSize;
    }

    public boolean isPassiveMode() {
        return this.passiveMode;
    }

    public int getDateTimeout() {
        return this.dateTimeout;
    }

    public int getConnTimeout() {
        return this.connTimeout;
    }

    public String toString() {
        return this.toJsonString();
    }
}

