/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.ftp.client.instance;

import com.orion.lang.able.Destroyable;
import com.orion.lang.able.SafeCloseable;
import com.orion.lang.utils.Strings;
import com.orion.net.ftp.client.FtpFile;
import com.orion.net.ftp.client.FtpFileFilter;
import com.orion.net.ftp.client.config.FtpConfig;
import com.orion.net.ftp.client.pool.FtpClientPool;
import com.orion.net.specification.transfer.IFileDownloader;
import com.orion.net.specification.transfer.IFileUploader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;

public interface IFtpInstance
extends SafeCloseable,
Destroyable {
    public void change();

    public void change(String var1);

    public String getWorkDirectory();

    public int replyCode();

    public String replyMsg();

    public boolean reply();

    public boolean isExist(String var1);

    public FtpFile getFile(String var1);

    public long getSize(String var1);

    public long getModifyTime(String var1);

    public void setModifyTime(String var1, Date var2);

    public void truncate(String var1) throws IOException;

    public void remove(String var1);

    public void removeFile(String var1);

    public void removeDir(String var1);

    public void makeDirectories(String var1);

    public void touch(String var1);

    public void move(String var1, String var2);

    default public InputStream openInputStream(String file) throws IOException {
        return this.openInputStream(file, 0L);
    }

    public InputStream openInputStream(String var1, long var2) throws IOException;

    default public OutputStream openOutputStream(String file) throws IOException {
        return this.openOutputStream(file, false);
    }

    public OutputStream openOutputStream(String var1, boolean var2) throws IOException;

    default public int read(String file, byte[] bs) throws IOException {
        return this.read(file, 0L, bs, 0, bs.length);
    }

    default public int read(String file, long skip, byte[] bs) throws IOException {
        return this.read(file, skip, bs, 0, bs.length);
    }

    default public int read(String file, byte[] bs, int off, int len) throws IOException {
        return this.read(file, 0L, bs, off, len);
    }

    public int read(String var1, long var2, byte[] var4, int var5, int var6) throws IOException;

    default public long transfer(String path, File file) throws IOException {
        return this.transfer(path, file.getAbsolutePath(), 0L, -1);
    }

    default public long transfer(String path, File file, long skip) throws IOException {
        return this.transfer(path, file.getAbsolutePath(), skip, -1);
    }

    default public long transfer(String path, String file) throws IOException {
        return this.transfer(path, file, 0L, -1);
    }

    default public long transfer(String path, String file, long skip) throws IOException {
        return this.transfer(path, file, skip, -1);
    }

    public long transfer(String var1, String var2, long var3, int var5) throws IOException;

    default public long transfer(String path, OutputStream out) throws IOException {
        return this.transfer(path, out, 0L, -1);
    }

    default public long transfer(String path, OutputStream out, long skip) throws IOException {
        return this.transfer(path, out, skip, -1);
    }

    public long transfer(String var1, OutputStream var2, long var3, int var5) throws IOException;

    public void write(String var1, InputStream var2) throws IOException;

    default public void write(String file, String str) throws IOException {
        this.write(file, Strings.bytes((String)str));
    }

    default public void write(String file, byte[] bs) throws IOException {
        this.write(file, bs, 0, bs.length);
    }

    public void write(String var1, byte[] var2, int var3, int var4) throws IOException;

    public void append(String var1, InputStream var2) throws IOException;

    default public void append(String file, String str) throws IOException {
        this.append(file, Strings.bytes((String)str));
    }

    default public void append(String file, byte[] bs) throws IOException {
        this.append(file, bs, 0, bs.length);
    }

    public void append(String var1, byte[] var2, int var3, int var4) throws IOException;

    default public void uploadFile(String remoteFile, File localFile) throws IOException {
        this.uploadFile(remoteFile, localFile.getAbsolutePath());
    }

    public void uploadFile(String var1, String var2) throws IOException;

    default public void uploadFile(String remoteFile, InputStream in) throws IOException {
        this.uploadFile(remoteFile, in, false);
    }

    public void uploadFile(String var1, InputStream var2, boolean var3) throws IOException;

    default public void uploadDir(String remoteDir, File localDir) throws IOException {
        this.uploadDir(remoteDir, localDir.getAbsolutePath(), true);
    }

    default public void uploadDir(String remoteDir, String localDir) throws IOException {
        this.uploadDir(remoteDir, localDir, true);
    }

    default public void uploadDir(String remoteDir, File localDir, boolean child) throws IOException {
        this.uploadDir(remoteDir, localDir.getAbsolutePath(), child);
    }

    public void uploadDir(String var1, String var2, boolean var3) throws IOException;

    default public void downloadFile(String remoteFile, File localFile) throws IOException {
        this.downloadFile(remoteFile, localFile.getAbsolutePath());
    }

    public void downloadFile(String var1, String var2) throws IOException;

    default public void downloadFile(String remoteFile, OutputStream out) throws IOException {
        this.downloadFile(remoteFile, out, false);
    }

    public void downloadFile(String var1, OutputStream var2, boolean var3) throws IOException;

    default public void downloadDir(String remoteDir, File localDir) throws IOException {
        this.downloadDir(remoteDir, localDir.getAbsolutePath(), true);
    }

    default public void downloadDir(String remoteDir, String localDir) throws IOException {
        this.downloadDir(remoteDir, localDir, true);
    }

    default public void downloadDir(String remoteDir, File localDir, boolean child) throws IOException {
        this.downloadDir(remoteDir, localDir.getAbsolutePath(), child);
    }

    public void downloadDir(String var1, String var2, boolean var3) throws IOException;

    public IFileUploader upload(String var1, String var2);

    public IFileUploader upload(String var1, File var2);

    public IFileDownloader download(String var1, String var2);

    public IFileDownloader download(String var1, File var2);

    default public List<FtpFile> listFiles(String path) {
        return this.listFiles(path, false, false);
    }

    default public List<FtpFile> listFiles(String path, boolean child) {
        return this.listFiles(path, child, false);
    }

    public List<FtpFile> listFiles(String var1, boolean var2, boolean var3);

    default public List<FtpFile> listDirs(String path) {
        return this.listDirs(path, false);
    }

    public List<FtpFile> listDirs(String var1, boolean var2);

    default public List<FtpFile> listFilesFilter(String path, FtpFileFilter filter) {
        return this.listFilesFilter(path, filter, false, false);
    }

    default public List<FtpFile> listFilesFilter(String path, FtpFileFilter filter, boolean child) {
        return this.listFilesFilter(path, filter, child, false);
    }

    public List<FtpFile> listFilesFilter(String var1, FtpFileFilter var2, boolean var3, boolean var4);

    public boolean pending() throws IOException;

    public void restartOffset(long var1);

    public void reset();

    public String getSystemType();

    public String getStatus();

    public String getStatus(String var1);

    public FTPClient getClient();

    public FtpConfig getConfig();

    public FtpClientPool getPool();

    public boolean sendNoop() throws IOException;

    public String serverCharset(String var1);

    public String localCharset(String var1);
}

