/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.ftp.client.pool;

import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Valid;
import com.orion.net.ftp.client.config.FtpConfig;
import com.orion.net.ftp.client.config.FtpsConfig;
import com.orion.net.ftp.client.instance.FtpInstance;
import com.orion.net.ftp.client.instance.IFtpInstance;
import java.io.IOException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTPSClient;

public class FtpClientFactory {
    private final FtpConfig config;

    public FtpClientFactory(FtpConfig config) {
        Valid.notNull((Object)config, (String)"config is null", (Object[])new Object[0]);
        this.config = config;
    }

    public FTPClient createClient() {
        Object client = this.config instanceof FtpsConfig ? new FTPSClient(((FtpsConfig)this.config).getProtocol(), ((FtpsConfig)this.config).isImplicit()) : new FTPClient();
        try {
            client.setDataTimeout(this.config.getDateTimeout());
            client.setConnectTimeout(this.config.getConnTimeout());
            client.setListHiddenFiles(this.config.isShowHidden());
            client.setControlEncoding(this.config.getRemoteContentCharset());
            client.setBufferSize(this.config.getBuffSize());
            client.connect(this.config.getHost(), this.config.getPort());
            if (this.config instanceof FtpsConfig && client instanceof FTPSClient) {
                ((FTPSClient)client).execPROT(((FtpsConfig)this.config).getProtect());
                SSLSocketFactory socketFactory = ((FtpsConfig)this.config).getSocketFactory();
                if (socketFactory != null) {
                    client.setSocketFactory((SocketFactory)socketFactory);
                }
            }
            client.login(this.config.getUsername(), this.config.getPassword());
            int reply = client.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                client.disconnect();
                throw Exceptions.ftp((String)"connection FTP client error because not ready");
            }
            client.setFileType(2);
            if (this.config.isPassiveMode()) {
                client.enterLocalPassiveMode();
                client.enterRemotePassiveMode();
            }
            client.cwd(this.config.getRemoteRootDir());
            return client;
        }
        catch (IOException e) {
            throw Exceptions.ftp((String)"connection FTP client error", (Throwable)e);
        }
    }

    public IFtpInstance createInstance() {
        return new FtpInstance(this.createClient(), this.config);
    }

    public FtpConfig getConfig() {
        return this.config;
    }
}

