/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.ftp.client.pool;

import com.orion.lang.constant.Const;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.io.Streams;
import com.orion.net.ftp.client.Ftps;
import com.orion.net.ftp.client.config.FtpConfig;
import com.orion.net.ftp.client.instance.FtpInstance;
import com.orion.net.ftp.client.instance.IFtpInstance;
import com.orion.net.ftp.client.pool.FtpClientFactory;
import com.orion.net.ftp.client.pool.FtpClientKeepAlive;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.net.ftp.FTPClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpClientPool
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FtpClientPool.class);
    private boolean noAvailableThenCreate;
    private int timeout;
    private final BlockingQueue<FTPClient> pool;
    private final FtpClientFactory factory;
    private FtpClientKeepAlive keepAlive;

    public FtpClientPool(FtpClientFactory factory) {
        this(factory, Const.N_10);
    }

    public FtpClientPool(FtpClientFactory factory, int size) {
        Valid.notNull((Object)factory, (String)"ftp client factory is null", (Object[])new Object[0]);
        this.timeout = 5000;
        this.noAvailableThenCreate = false;
        this.factory = factory;
        this.pool = new ArrayBlockingQueue<FTPClient>(size);
        this.init(size);
    }

    private void init(int maxPoolSize) {
        try {
            for (int i = 0; i < maxPoolSize; ++i) {
                this.addClient();
            }
        }
        catch (Exception e) {
            throw Exceptions.ftp((String)"init ftp client to pool error", (Throwable)e);
        }
    }

    public FtpClientPool timeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public FtpClientPool noAvailableThenCreate(boolean noAvailableThenCreate) {
        this.noAvailableThenCreate = noAvailableThenCreate;
        return this;
    }

    public FtpClientPool keepAliveListener() {
        this.keepAlive = new FtpClientKeepAlive(this);
        this.keepAlive.listener(this.factory.getConfig().getConnTimeout() / 2);
        return this;
    }

    public synchronized FTPClient getClient() {
        LOGGER.debug("get ftp client with pool");
        try {
            if (this.pool.size() == 0 && this.noAvailableThenCreate) {
                LOGGER.debug("there are no free ftp connections in the pool, used create temp client");
                return this.factory.createClient();
            }
            FTPClient client = this.pool.poll(this.timeout, TimeUnit.MILLISECONDS);
            if (client == null) {
                LOGGER.error("cannot get ftp client with pool, not have more free ftp connection");
                throw Exceptions.ftp((String)"cannot get ftp client with pool, not have more free ftp connection");
            }
            if (!Ftps.isActive(client)) {
                this.invalidClient(client);
                this.addClient();
                return this.getClient();
            }
            return client;
        }
        catch (InterruptedException e) {
            LOGGER.error("get ftp client with pool error", (Throwable)e);
            throw Exceptions.ftp((String)"get ftp client with pool error", (Throwable)e);
        }
    }

    public synchronized IFtpInstance getInstance() {
        return new FtpInstance(this);
    }

    public synchronized void returnClient(FTPClient client) {
        try {
            Valid.notNull((Object)client, (String)"return client is null", (Object[])new Object[0]);
            LOGGER.debug("return ftp client with pool");
            if (!this.pool.offer(client, this.timeout, TimeUnit.MILLISECONDS)) {
                Ftps.destroy(client);
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("return ftp client with to pool error", (Throwable)e);
        }
    }

    protected synchronized void addClient() {
        try {
            this.pool.offer(this.factory.createClient(), this.timeout, TimeUnit.MILLISECONDS);
            LOGGER.debug("add ftp client with pool");
        }
        catch (InterruptedException e) {
            LOGGER.error("cannot add a new connection to the pool", (Throwable)e);
        }
    }

    protected synchronized void invalidClient(FTPClient client) {
        LOGGER.debug("invalid ftp client with pool");
        this.pool.remove(client);
        Ftps.destroy(client);
    }

    @Override
    public void close() throws InterruptedException {
        LOGGER.debug("ftp client pool closing...");
        Streams.close((AutoCloseable)((Object)this.keepAlive));
        while (this.pool.iterator().hasNext()) {
            FTPClient client = this.pool.take();
            Ftps.destroy(client);
        }
    }

    protected BlockingQueue<FTPClient> getPool() {
        return this.pool;
    }

    public boolean isNoAvailableThenCreate() {
        return this.noAvailableThenCreate;
    }

    public FtpClientFactory getFactory() {
        return this.factory;
    }

    public FtpConfig getConfig() {
        return this.factory.getConfig();
    }

    public int getFreeSize() {
        return this.pool.size();
    }
}

