/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.ftp.server;

import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.collect.Lists;
import com.orion.net.ftp.server.FtpServerConfig;
import com.orion.net.ftp.server.FtpServerSslConfig;
import com.orion.net.ftp.server.FtpUser;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.ftpserver.ConnectionConfig;
import org.apache.ftpserver.FtpServer;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.impl.DefaultConnectionConfig;
import org.apache.ftpserver.listener.Listener;
import org.apache.ftpserver.listener.ListenerFactory;
import org.apache.ftpserver.ssl.SslConfiguration;
import org.apache.ftpserver.ssl.SslConfigurationFactory;
import org.apache.ftpserver.usermanager.impl.BaseUser;
import org.apache.ftpserver.usermanager.impl.TransferRatePermission;
import org.apache.ftpserver.usermanager.impl.WritePermission;

public class FtpServerInstance {
    private FtpServerFactory serverFactory;
    private ListenerFactory factory;
    private UserManager userManager;
    private FtpServer ftpServer;
    private FtpServerConfig serverConfig;
    private FtpServerSslConfig sslConfig;
    private final List<User> initUsers;
    private String host;
    private int port;
    private int idleTimeout;

    public FtpServerInstance() {
        this("127.0.0.1", 21);
    }

    public FtpServerInstance(String host) {
        this(host, 21);
    }

    public FtpServerInstance(int port) {
        this("127.0.0.1", port);
    }

    public FtpServerInstance(String host, int port) {
        this.host = host;
        this.port = port;
        this.idleTimeout = 300;
        this.serverConfig = new FtpServerConfig();
        this.initUsers = new ArrayList<User>();
    }

    public static FtpServerInstance newInstance() {
        return new FtpServerInstance();
    }

    public static FtpServerInstance newInstance(int port) {
        return new FtpServerInstance(port);
    }

    public FtpServerInstance host(String hostName) {
        this.host = hostName;
        return this;
    }

    public FtpServerInstance port(int port) {
        this.port = port;
        return this;
    }

    public FtpServerInstance idleTimeout(int timeout) {
        this.idleTimeout = timeout;
        return this;
    }

    public FtpServerInstance serverConfig(FtpServerConfig serverConfig) {
        this.serverConfig = serverConfig;
        return this;
    }

    public FtpServerInstance sslConfig(FtpServerSslConfig sslConfig) {
        this.sslConfig = sslConfig;
        return this;
    }

    private ConnectionConfig convertConnectionConfig() {
        return new DefaultConnectionConfig(this.serverConfig.isAnonymousLogin(), this.serverConfig.getLoginFailureDelay(), this.serverConfig.getMaxLogin(), this.serverConfig.getMaxAnonymousLogin(), this.serverConfig.getMaxLoginFailures(), this.serverConfig.getMaxThreads());
    }

    private SslConfiguration convertSslConfig() {
        String keyAlias;
        String keyStoreAlgorithm;
        SslConfigurationFactory ssl = new SslConfigurationFactory();
        File keyStoreFile = (File)Valid.notNull((Object)this.sslConfig.getKeyStoreFile(), (String)"key store file is null", (Object[])new Object[0]);
        String keyStorePassword = (String)Valid.notNull((Object)this.sslConfig.getKeyStorePassword(), (String)"key store password is null", (Object[])new Object[0]);
        ssl.setKeystoreFile(keyStoreFile);
        ssl.setKeystorePassword(keyStorePassword);
        String sslProtocol = this.sslConfig.getSslProtocol();
        if (sslProtocol != null) {
            ssl.setSslProtocol(new String[]{sslProtocol});
        }
        if ((keyStoreAlgorithm = this.sslConfig.getKeyStoreAlgorithm()) != null) {
            ssl.setKeystoreAlgorithm(keyStoreAlgorithm);
        }
        if ((keyAlias = this.sslConfig.getKeyAlias()) != null) {
            ssl.setKeyAlias(keyAlias);
        }
        return ssl.createSslConfiguration();
    }

    public FtpServerInstance addUser(FtpUser user) {
        User u = this.convertUser(user);
        if (this.serverFactory == null) {
            this.initUsers.add(u);
            return this;
        }
        try {
            this.userManager.save(u);
            return this;
        }
        catch (Exception e) {
            throw Exceptions.ftp((Throwable)e);
        }
    }

    public FtpServerInstance addUser(String username, String password) {
        return this.addUser(username, password, "/home/" + username);
    }

    public FtpServerInstance addUser(String username, String password, String homePath) {
        User u = this.convertUser(new FtpUser(username, password, homePath));
        if (this.serverFactory == null) {
            this.initUsers.add(u);
            return this;
        }
        try {
            this.userManager.save(u);
            return this;
        }
        catch (Exception e) {
            throw Exceptions.ftp((Throwable)e);
        }
    }

    public FtpServerInstance addUsers(Collection<FtpUser> users) {
        for (FtpUser user : users) {
            User u = this.convertUser(user);
            if (this.serverFactory == null) {
                this.initUsers.add(u);
                continue;
            }
            try {
                this.userManager.save(u);
            }
            catch (Exception e) {
                throw Exceptions.ftp((Throwable)e);
            }
        }
        return this;
    }

    public FtpServerInstance deleteUser(String user) {
        try {
            this.userManager.delete(user);
            return this;
        }
        catch (Exception e) {
            throw Exceptions.ftp((Throwable)e);
        }
    }

    public FtpServerInstance deleteUsers(Collection<String> users) {
        for (String user : users) {
            try {
                this.userManager.delete(user);
            }
            catch (Exception e) {
                throw Exceptions.ftp((Throwable)e);
            }
        }
        return this;
    }

    public boolean userExists(String user) {
        try {
            return this.userManager.doesExist(user);
        }
        catch (Exception e) {
            throw Exceptions.ftp((Throwable)e);
        }
    }

    public List<String> getUserNames() {
        try {
            Object[] userNames = this.userManager.getAllUserNames();
            return Lists.of((Object[])userNames);
        }
        catch (Exception e) {
            throw Exceptions.ftp((Throwable)e);
        }
    }

    private User convertUser(FtpUser ftpUser) {
        BaseUser user = new BaseUser();
        user.setName(ftpUser.getUsername());
        user.setPassword(ftpUser.getPassword());
        user.setHomeDirectory(ftpUser.getHomePath());
        user.setMaxIdleTime(ftpUser.getMaxIdleTime());
        ArrayList<Object> authorities = new ArrayList<Object>();
        if (ftpUser.isWritePermission()) {
            authorities.add(new WritePermission());
        }
        if (ftpUser.getMaxUploadRate() != 0 || ftpUser.getMaxDownloadRate() != 0) {
            authorities.add(new TransferRatePermission(ftpUser.getMaxDownloadRate(), ftpUser.getMaxUploadRate()));
        }
        user.setAuthorities(authorities);
        return user;
    }

    public FtpServerInstance listener() {
        this.serverFactory = new FtpServerFactory();
        this.serverFactory.setConnectionConfig(this.convertConnectionConfig());
        this.factory = new ListenerFactory();
        if (this.sslConfig != null) {
            this.factory.setSslConfiguration(this.convertSslConfig());
        }
        this.factory.setPort(this.port);
        if (this.host != null) {
            this.factory.setServerAddress(this.host);
        }
        this.factory.setIdleTimeout(this.idleTimeout);
        Listener listener = this.factory.createListener();
        this.serverFactory.addListener("default", listener);
        this.userManager = this.serverFactory.getUserManager();
        for (User initUser : this.initUsers) {
            try {
                this.userManager.save(initUser);
            }
            catch (Exception e) {
                throw Exceptions.ftp((Throwable)e);
            }
        }
        this.ftpServer = this.serverFactory.createServer();
        return this;
    }

    public FtpServerInstance start() {
        try {
            this.ftpServer.start();
            return this;
        }
        catch (Exception e) {
            throw Exceptions.ftp((Throwable)e);
        }
    }

    public FtpServerInstance stop() {
        this.ftpServer.stop();
        return this;
    }

    public FtpServerInstance suspend() {
        this.ftpServer.suspend();
        return this;
    }

    public FtpServerInstance resume() {
        this.ftpServer.resume();
        return this;
    }

    public boolean isStopped() {
        return this.ftpServer.isStopped();
    }

    public boolean isSuspended() {
        return this.ftpServer.isSuspended();
    }

    public FtpServerFactory getServerFactory() {
        return this.serverFactory;
    }

    public ListenerFactory getFactory() {
        return this.factory;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public FtpServer getFtpServer() {
        return this.ftpServer;
    }

    public FtpServerConfig getServerConfig() {
        return this.serverConfig;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }
}

