/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.host;

import com.jcraft.jsch.Identity;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Strings;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.io.Files1;
import com.orion.net.host.SessionLogger;
import com.orion.net.host.SessionStore;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class SessionHolder {
    public static final int DEFAULT_SSH_PORT = 22;
    public final JSch ch;

    public SessionHolder() {
        this(new JSch());
    }

    public SessionHolder(JSch ch) {
        Valid.notNull((Object)ch, (String)"jsch is null", (Object[])new Object[0]);
        this.ch = ch;
    }

    public static SessionHolder create() {
        return new SessionHolder();
    }

    public void setLogger(SessionLogger logger) {
        final int loggerLevel = logger.getLevel();
        this.ch.setInstanceLogger(new Logger(){

            public boolean isEnabled(int level) {
                return loggerLevel <= level;
            }

            public void log(int level, String message) {
                SessionLogger.log(level, message);
            }
        });
    }

    public void addIdentity(String privateKeyPath) {
        this.addIdentity(privateKeyPath, null, null);
    }

    public void addIdentity(String privateKeyPath, String password) {
        this.addIdentity(privateKeyPath, null, password);
    }

    public void addIdentity(String privateKeyPath, String publicKeyPath, String password) {
        Valid.notNull((Object)privateKeyPath, (String)"private key is null", (Object[])new Object[0]);
        try {
            this.ch.addIdentity(privateKeyPath, publicKeyPath, password == null ? null : Strings.bytes((String)password));
        }
        catch (Exception e) {
            throw Exceptions.runtime((String)("add identity error " + e.getMessage()), (Throwable)e);
        }
    }

    public void addIdentityValue(String keyName, String privateKeyValue) {
        this.addIdentityValue(keyName, privateKeyValue, null, null);
    }

    public void addIdentityValue(String keyName, String privateKeyValue, String password) {
        this.addIdentityValue(keyName, privateKeyValue, null, password);
    }

    public void addIdentityValue(String keyName, String privateKeyValue, String publicKeyValue, String password) {
        Valid.notNull((Object)keyName, (String)"key name is null", (Object[])new Object[0]);
        Valid.notNull((Object)privateKeyValue, (String)"private key is null", (Object[])new Object[0]);
        try {
            this.ch.addIdentity(keyName, Strings.bytes((String)privateKeyValue), publicKeyValue == null ? null : Strings.bytes((String)publicKeyValue), password == null ? null : Strings.bytes((String)password));
        }
        catch (Exception e) {
            throw Exceptions.runtime((String)("add identity error " + e.getMessage()), (Throwable)e);
        }
    }

    public void removeIdentity(String key) {
        Vector identities = this.ch.getIdentityRepository().getIdentities();
        for (Object identity : identities) {
            String keyName;
            if (!(identity instanceof Identity) || !(keyName = ((Identity)identity).getName()).equals(key) && !Files1.getPath((String)keyName).equals(Files1.getPath((String)key))) continue;
            try {
                this.ch.removeIdentity((Identity)identity);
            }
            catch (Exception e) {
                throw Exceptions.runtime((String)("remove identity error " + e.getMessage()));
            }
        }
    }

    public void removeAllIdentity() {
        try {
            this.ch.removeAllIdentity();
        }
        catch (JSchException e) {
            throw Exceptions.runtime((String)("remove all identity error " + e.getMessage()));
        }
    }

    public List<String> getLoadKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        Vector identities = this.ch.getIdentityRepository().getIdentities();
        for (Object identity : identities) {
            if (!(identity instanceof Identity)) continue;
            keys.add(Files1.getPath((String)((Identity)identity).getName()));
        }
        return keys;
    }

    public void setKnownHosts(String filePath) {
        try {
            this.ch.setKnownHosts(filePath);
        }
        catch (Exception e) {
            throw Exceptions.runtime((String)("set unknown hosts error " + e.getMessage()));
        }
    }

    public void setKnownHosts(InputStream inputStream) {
        try {
            this.ch.setKnownHosts(inputStream);
        }
        catch (Exception e) {
            throw Exceptions.runtime((String)("set unknown hosts error " + e.getMessage()));
        }
    }

    public SessionStore getSession(String host, String username) {
        return this.getSession(host, 22, username);
    }

    public SessionStore getSession(String host, int port, String username) {
        try {
            return new SessionStore(this.ch.getSession(username, host, port));
        }
        catch (Exception e) {
            throw Exceptions.connection((Throwable)e);
        }
    }

    static {
        JSch.setConfig((String)"StrictHostKeyChecking", (String)"no");
        JSch.setConfig((String)"server_host_key", (String)(JSch.getConfig((String)"server_host_key") + ",ssh-rsa"));
        JSch.setConfig((String)"PubkeyAcceptedAlgorithms", (String)(JSch.getConfig((String)"PubkeyAcceptedAlgorithms") + ",ssh-rsa"));
    }
}

