/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.host;

import com.orion.lang.utils.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum SessionLogger {
    DEBUG(0),
    INFO(1),
    WARN(2),
    ERROR(3),
    FATAL(4);

    private static final Logger LOGGER;
    private static String debugTag;
    private static String infoTag;
    private static String warnTag;
    private static String errorTag;
    private static String fatalTag;
    private final int level;

    private SessionLogger(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public static SessionLogger getLogger(int level) {
        for (SessionLogger value : SessionLogger.values()) {
            if (value.level != level) continue;
            return value;
        }
        throw Exceptions.runtime();
    }

    protected static void log(int level, String msg) {
        switch (level) {
            case 0: {
                LOGGER.debug(debugTag, (Object)msg);
                return;
            }
            case 1: {
                LOGGER.info(infoTag, (Object)msg);
                return;
            }
            case 2: {
                LOGGER.warn(warnTag, (Object)msg);
                return;
            }
            case 3: {
                LOGGER.error(errorTag, (Object)msg);
                return;
            }
            case 4: {
                LOGGER.error(fatalTag, (Object)msg);
                return;
            }
        }
    }

    public static void setDebugTag(String debugTag) {
        SessionLogger.debugTag = debugTag;
    }

    public static void setInfoTag(String infoTag) {
        SessionLogger.infoTag = infoTag;
    }

    public static void setWarnTag(String warnTag) {
        SessionLogger.warnTag = warnTag;
    }

    public static void setErrorTag(String errorTag) {
        SessionLogger.errorTag = errorTag;
    }

    public static void setFatalTag(String fatalTag) {
        SessionLogger.fatalTag = fatalTag;
    }

    static {
        LOGGER = LoggerFactory.getLogger(SessionLogger.class);
        debugTag = "{}";
        infoTag = "{}";
        warnTag = "{}";
        errorTag = "{}";
        fatalTag = "{}";
    }
}

