/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.host;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.ProxySOCKS4;
import com.jcraft.jsch.ProxySOCKS5;
import com.jcraft.jsch.Session;
import com.orion.lang.able.SafeCloseable;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Strings;
import com.orion.lang.utils.Valid;
import com.orion.net.host.sftp.SftpExecutor;
import com.orion.net.host.ssh.command.CommandExecutor;
import com.orion.net.host.ssh.shell.ShellExecutor;

public class SessionStore
implements SafeCloseable {
    private static final String COMMAND_TYPE = "exec";
    private static final String SHELL_TYPE = "shell";
    private static final String SFTP_TYPE = "sftp";
    private static final String AUTH_FAIL_MESSAGE = "auth fail";
    private final Session session;

    public SessionStore(Session session) {
        this.session = session;
    }

    public SessionStore config(String key, String value) {
        this.session.setConfig(key, value);
        return this;
    }

    public SessionStore password(String password) {
        this.session.setPassword(password);
        return this;
    }

    public SessionStore password(byte[] password) {
        this.session.setPassword(password);
        return this;
    }

    public SessionStore httpProxy(String host, int port) {
        this.session.setProxy((Proxy)new ProxyHTTP(host, port));
        return this;
    }

    public SessionStore httpProxy(String host, int port, String username, String password) {
        ProxyHTTP proxy = new ProxyHTTP(host, port);
        if (!Strings.isBlank((String)username)) {
            proxy.setUserPasswd(username, password);
        }
        this.session.setProxy((Proxy)proxy);
        return this;
    }

    public SessionStore socks4Proxy(String host, int port) {
        this.session.setProxy((Proxy)new ProxySOCKS4(host, port));
        return this;
    }

    public SessionStore socks4Proxy(String host, int port, String username, String password) {
        ProxySOCKS4 proxy = new ProxySOCKS4(host, port);
        if (!Strings.isBlank((String)username)) {
            proxy.setUserPasswd(username, password);
        }
        this.session.setProxy((Proxy)proxy);
        return this;
    }

    public SessionStore socks5Proxy(String host, int port) {
        this.session.setProxy((Proxy)new ProxySOCKS5(host, port));
        return this;
    }

    public SessionStore socks5Proxy(String host, int port, String username, String password) {
        ProxySOCKS5 proxy = new ProxySOCKS5(host, port);
        if (!Strings.isBlank((String)username)) {
            proxy.setUserPasswd(username, password);
        }
        this.session.setProxy((Proxy)proxy);
        return this;
    }

    public SessionStore clientVersion(String version) {
        this.session.setClientVersion(version);
        return this;
    }

    public SessionStore daemonThread(boolean daemon) {
        this.session.setDaemonThread(daemon);
        return this;
    }

    public String getConfig(String key) {
        return this.session.getConfig(key);
    }

    public void setConfig(String key, String value) {
        this.session.setConfig(key, value);
    }

    public SessionStore timeout(int timeout) {
        Valid.gte((Comparable)Integer.valueOf(timeout), (Comparable)Integer.valueOf(0), (String)"the time must greater than or equal 0", (Object[])new Object[0]);
        try {
            this.session.setServerAliveInterval(timeout);
            this.session.setServerAliveCountMax(2);
            this.session.setTimeout(timeout);
        }
        catch (Exception e) {
            throw Exceptions.runtime((Throwable)e);
        }
        return this;
    }

    public SessionStore connect() {
        return this.connect(this.session.getTimeout());
    }

    public SessionStore connect(int timeout) {
        try {
            this.session.connect(timeout);
        }
        catch (Exception e) {
            if (Strings.def((String)e.getMessage()).contains(AUTH_FAIL_MESSAGE)) {
                throw Exceptions.authentication((Throwable)e);
            }
            throw Exceptions.connection((Throwable)e);
        }
        return this;
    }

    public CommandExecutor getCommandExecutor(String command) {
        return this.getCommandExecutor(Strings.bytes((String)command, (String)"UTF-8"));
    }

    public CommandExecutor getCommandExecutor(String command, String charset) {
        return this.getCommandExecutor(Strings.bytes((String)command, (String)charset));
    }

    public CommandExecutor getCommandExecutor(byte[] command) {
        try {
            return new CommandExecutor((ChannelExec)this.session.openChannel(COMMAND_TYPE), command);
        }
        catch (JSchException e) {
            throw Exceptions.state((String)"could not open channel", (Throwable)e);
        }
    }

    public ShellExecutor getShellExecutor() {
        try {
            return new ShellExecutor((ChannelShell)this.session.openChannel(SHELL_TYPE));
        }
        catch (JSchException e) {
            throw Exceptions.state((String)"could not open channel", (Throwable)e);
        }
    }

    public SftpExecutor getSftpExecutor() {
        return this.getSftpExecutor("UTF-8");
    }

    public SftpExecutor getSftpExecutor(String fileNameCharset) {
        try {
            return new SftpExecutor((ChannelSftp)this.session.openChannel(SFTP_TYPE), fileNameCharset);
        }
        catch (JSchException e) {
            throw Exceptions.state((String)"could not open channel", (Throwable)e);
        }
    }

    public void disconnect() {
        this.session.disconnect();
    }

    public boolean isConnected() {
        return this.session.isConnected();
    }

    public Session getSession() {
        return this.session;
    }

    public String getHost() {
        return this.session.getHost();
    }

    public int getPort() {
        return this.session.getPort();
    }

    public String getUsername() {
        return this.session.getUserName();
    }

    public void close() {
        if (this.isConnected()) {
            this.disconnect();
        }
    }
}

