/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.host.sftp;

import com.orion.lang.able.SafeCloseable;
import com.orion.lang.utils.Strings;
import com.orion.net.host.sftp.SftpFile;
import com.orion.net.host.sftp.SftpFileFilter;
import com.orion.net.specification.transfer.IFileDownloader;
import com.orion.net.specification.transfer.IFileUploader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;

public interface ISftpExecutor
extends SafeCloseable {
    public void bufferSize(int var1);

    public void charset(String var1);

    public void sendSignal(String var1);

    public String getHome();

    public boolean isExist(String var1);

    public String getPath(String var1);

    public String getLinkPath(String var1);

    public SftpFile getFile(String var1);

    public SftpFile getFile(String var1, boolean var2);

    public long getSize(String var1);

    public void setFileAttribute(SftpFile var1);

    public void setModifyTime(String var1, Date var2);

    public void changeMode(String var1, int var2);

    public void changeOwner(String var1, int var2);

    public void changeGroup(String var1, int var2);

    public void makeDirectory(String var1);

    public void makeDirectories(String var1);

    public void removeDir(String var1);

    public void removeFile(String var1);

    public void remove(String var1);

    public void touch(String var1);

    public void touchTruncate(String var1);

    public void touch(String var1, boolean var2);

    public void truncate(String var1);

    default public void hardLink(String source, String target) {
        this.link(source, target, true);
    }

    default public void symLink(String source, String target) {
        this.link(source, target, false);
    }

    public void link(String var1, String var2, boolean var3);

    public void move(String var1, String var2);

    default public InputStream openInputStream(String path) throws IOException {
        return this.openInputStream(path, 0L);
    }

    public InputStream openInputStream(String var1, long var2) throws IOException;

    default public OutputStream openOutputStream(String path) throws IOException {
        return this.openOutputStream(path, false);
    }

    public OutputStream openOutputStream(String var1, boolean var2) throws IOException;

    default public int read(String path, byte[] bs) throws IOException {
        return this.read(path, 0L, bs, 0, bs.length);
    }

    default public int read(String path, byte[] bs, int offset, int len) throws IOException {
        return this.read(path, 0L, bs, offset, len);
    }

    default public int read(String path, long skip, byte[] bs) throws IOException {
        return this.read(path, skip, bs, 0, bs.length);
    }

    public int read(String var1, long var2, byte[] var4, int var5, int var6) throws IOException;

    default public long transfer(String path, OutputStream out) throws IOException {
        return this.transfer(path, out, 0L, -1);
    }

    default public long transfer(String path, OutputStream out, long skip) throws IOException {
        return this.transfer(path, out, skip, -1);
    }

    public long transfer(String var1, OutputStream var2, long var3, int var5) throws IOException;

    default public long transfer(String path, File file) throws IOException {
        return this.transfer(path, file.getAbsolutePath(), 0L);
    }

    default public long transfer(String path, File file, long skip) throws IOException {
        return this.transfer(path, file.getAbsolutePath(), skip);
    }

    default public long transfer(String path, String file) throws IOException {
        return this.transfer(path, file, 0L);
    }

    public long transfer(String var1, String var2, long var3) throws IOException;

    public void write(String var1, InputStream var2) throws IOException;

    default public void write(String path, String str) throws IOException {
        this.write(path, Strings.bytes((String)str));
    }

    default public void write(String path, byte[] bs) throws IOException {
        this.write(path, bs, 0, bs.length);
    }

    public void write(String var1, byte[] var2, int var3, int var4) throws IOException;

    public void append(String var1, InputStream var2) throws IOException;

    default public void append(String path, String str) throws IOException {
        this.append(path, Strings.bytes((String)str));
    }

    default public void append(String path, byte[] bs) throws IOException {
        this.append(path, bs, 0, bs.length);
    }

    public void append(String var1, byte[] var2, int var3, int var4) throws IOException;

    default public void uploadFile(String remoteFile, File localFile) throws IOException {
        this.uploadFile(remoteFile, localFile.getAbsolutePath());
    }

    public void uploadFile(String var1, String var2) throws IOException;

    default public void uploadFile(String remoteFile, InputStream in) throws IOException {
        this.uploadFile(remoteFile, in, false);
    }

    public void uploadFile(String var1, InputStream var2, boolean var3) throws IOException;

    default public void uploadDir(String remoteDir, File localDir) throws IOException {
        this.uploadDir(remoteDir, localDir.getAbsolutePath(), true);
    }

    default public void uploadDir(String remoteDir, String localDir) throws IOException {
        this.uploadDir(remoteDir, localDir, true);
    }

    default public void uploadDir(String remoteDir, File localDir, boolean child) throws IOException {
        this.uploadDir(remoteDir, localDir.getAbsolutePath(), child);
    }

    public void uploadDir(String var1, String var2, boolean var3) throws IOException;

    default public void downloadFile(String remoteFile, File localFile) throws IOException {
        this.downloadFile(remoteFile, localFile.getAbsolutePath());
    }

    public void downloadFile(String var1, String var2) throws IOException;

    default public void downloadFile(String remoteFile, OutputStream out) throws IOException {
        this.downloadFile(remoteFile, out, false);
    }

    public void downloadFile(String var1, OutputStream var2, boolean var3) throws IOException;

    default public void downloadDir(String remoteDir, File localDir) throws IOException {
        this.downloadDir(remoteDir, localDir.getAbsolutePath(), true);
    }

    default public void downloadDir(String remoteDir, String localDir) throws IOException {
        this.downloadDir(remoteDir, localDir, true);
    }

    default public void downloadDir(String remoteDir, File localDir, boolean child) throws IOException {
        this.downloadDir(remoteDir, localDir.getAbsolutePath(), child);
    }

    public void downloadDir(String var1, String var2, boolean var3) throws IOException;

    public IFileUploader upload(String var1, File var2);

    public IFileUploader upload(String var1, String var2);

    public IFileDownloader download(String var1, File var2);

    public IFileDownloader download(String var1, String var2);

    public List<SftpFile> list(String var1);

    default public List<SftpFile> listFiles(String path) {
        return this.listFiles(path, false, false);
    }

    default public List<SftpFile> listFiles(String path, boolean child) {
        return this.listFiles(path, child, false);
    }

    public List<SftpFile> listFiles(String var1, boolean var2, boolean var3);

    default public List<SftpFile> listDirs(String path) {
        return this.listDirs(path, false);
    }

    public List<SftpFile> listDirs(String var1, boolean var2);

    default public List<SftpFile> listFilesFilter(String path, SftpFileFilter filter) {
        return this.listFilesFilter(path, filter, false, false);
    }

    default public List<SftpFile> listFilesFilter(String path, SftpFileFilter filter, boolean child) {
        return this.listFilesFilter(path, filter, child, false);
    }

    public List<SftpFile> listFilesFilter(String var1, SftpFileFilter var2, boolean var3, boolean var4);

    public boolean isConnected();

    public int getServerVersion();

    public int getBufferSize();

    public String getCharset();
}

