/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.host.ssh.command;

import com.jcraft.jsch.ChannelExec;
import com.orion.lang.support.Attempt;
import com.orion.lang.support.timeout.TimeoutChecker;
import com.orion.lang.support.timeout.TimeoutEndpoint;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Strings;
import com.orion.lang.utils.io.Streams;
import com.orion.net.host.ssh.BaseHostExecutor;
import com.orion.net.host.ssh.command.ICommandExecutor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;

public class CommandExecutor
extends BaseHostExecutor<ChannelExec>
implements ICommandExecutor {
    private final byte[] command;
    private InputStream errorStream;
    private boolean merge;
    private Consumer<InputStream> errorStreamHandler;
    private long timeout;
    private TimeoutChecker checker;
    private long startTime;
    private volatile boolean expired;

    public CommandExecutor(ChannelExec channel, String command) {
        this(channel, Strings.bytes((String)command, (Charset)StandardCharsets.UTF_8));
    }

    public CommandExecutor(ChannelExec channel, String command, String charset) {
        this(channel, Strings.bytes((String)command, (String)charset));
    }

    public CommandExecutor(ChannelExec channel, byte[] command) {
        super(channel);
        this.command = command;
        ((ChannelExec)this.channel).setCommand(command);
        channel.setPty(true);
    }

    @Override
    public void pty(boolean enable) {
        ((ChannelExec)this.channel).setPty(enable);
    }

    @Override
    public void env(byte[] key, byte[] value) {
        ((ChannelExec)this.channel).setEnv(key, value);
    }

    @Override
    public void env(String key, String value) {
        ((ChannelExec)this.channel).setEnv(key, value);
    }

    @Override
    public void x11Forward(boolean enable) {
        ((ChannelExec)this.channel).setXForwarding(enable);
    }

    @Override
    public void setAgentForwarding(boolean enable) {
        ((ChannelExec)this.channel).setAgentForwarding(enable);
    }

    @Override
    public void merge() {
        this.merge = true;
    }

    @Override
    public void errorStreamHandler(Consumer<InputStream> errorStreamHandler) {
        this.errorStreamHandler = errorStreamHandler;
    }

    @Override
    public void transferError(OutputStream out) throws IOException {
        this.errorStreamHandler = Attempt.rethrows(i -> Streams.transfer((InputStream)i, (OutputStream)out));
    }

    @Override
    public void timeout(long timeout, TimeoutChecker checker) {
        this.timeout = timeout;
        this.checker = checker;
    }

    public boolean checkTimeout() {
        if (this.timeout == 0L) {
            return false;
        }
        if (System.currentTimeMillis() - this.startTime < this.timeout) {
            return false;
        }
        this.expired = true;
        Streams.close((AutoCloseable)((Object)this));
        return true;
    }

    @Override
    protected void listenerOutput() {
        this.startTime = System.currentTimeMillis();
        if (this.timeout > 0L && this.checker != null) {
            this.checker.addTask((TimeoutEndpoint)this);
        }
        try {
            this.streamHandler.accept(this.inputStream);
            if (this.errorStreamHandler != null) {
                this.errorStreamHandler.accept(this.errorStream);
            }
        }
        catch (Exception e) {
            if (this.expired) {
                throw Exceptions.timeout((Throwable)e);
            }
            throw e;
        }
        finally {
            this.done = true;
            if (this.callback != null) {
                this.callback.run();
            }
        }
    }

    public void exec() {
        if (this.streamHandler == null) {
            throw Exceptions.runtime((String)"command std out stream handler is null");
        }
        if (!this.isConnected()) {
            throw Exceptions.runtime((String)"channel is not connected");
        }
        try {
            if (this.merge) {
                this.inputStream = new SequenceInputStream(((ChannelExec)this.channel).getInputStream(), ((ChannelExec)this.channel).getErrStream());
            } else {
                this.inputStream = ((ChannelExec)this.channel).getInputStream();
                if (this.errorStreamHandler != null) {
                    this.errorStream = ((ChannelExec)this.channel).getErrStream();
                }
            }
            this.outputStream = ((ChannelExec)this.channel).getOutputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.listenerOutput();
    }

    @Override
    public void close() {
        super.close();
        Streams.close((AutoCloseable)this.errorStream);
        this.disconnectChannel();
    }

    @Override
    public int getExitCode() {
        return ((ChannelExec)this.channel).getExitStatus();
    }

    @Override
    public String getCommand() {
        return new String(this.command, StandardCharsets.UTF_8);
    }

    @Override
    public byte[] getCommandBytes() {
        return this.command;
    }

    @Override
    public boolean isTimeout() {
        return this.expired;
    }

    @Override
    public InputStream getErrorStream() {
        return this.errorStream;
    }

    public String toString() {
        return this.command == null ? "" : this.getCommand();
    }
}

