/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.host.ssh.command;

import com.orion.lang.support.timeout.TimeoutChecker;
import com.orion.lang.support.timeout.TimeoutEndpoint;
import com.orion.net.host.HostConnector;
import com.orion.net.host.ssh.ExitCode;
import com.orion.net.host.ssh.IHostExecutor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public interface ICommandExecutor
extends IHostExecutor,
HostConnector,
TimeoutEndpoint {
    public void merge();

    public void pty(boolean var1);

    public void errorStreamHandler(Consumer<InputStream> var1);

    public void transferError(OutputStream var1) throws IOException;

    public void timeout(long var1, TimeoutChecker var3);

    default public void timeout(long timeout, TimeUnit unit, TimeoutChecker checker) {
        this.timeout(unit.toMillis(timeout), checker);
    }

    public int getExitCode();

    default public boolean isSuccessExit() {
        return ExitCode.isSuccess(this.getExitCode());
    }

    public boolean isTimeout();

    public String getCommand();

    public byte[] getCommandBytes();

    public InputStream getErrorStream();
}

