/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.host.ssh.shell;

import com.jcraft.jsch.ChannelShell;
import com.orion.lang.utils.Exceptions;
import com.orion.net.host.ssh.BaseHostExecutor;
import com.orion.net.host.ssh.TerminalType;
import com.orion.net.host.ssh.shell.IShellExecutor;
import java.io.IOException;

public class ShellExecutor
extends BaseHostExecutor<ChannelShell>
implements IShellExecutor {
    private String terminalType = TerminalType.XTERM.getType();
    private int cols = 180;
    private int rows = 36;
    private int width = 1366;
    private int height = 768;

    public ShellExecutor(ChannelShell channel) {
        super(channel);
        try {
            this.inputStream = channel.getInputStream();
            this.outputStream = channel.getOutputStream();
        }
        catch (IOException e) {
            throw Exceptions.ioRuntime((Throwable)e);
        }
    }

    @Override
    public void x11Forward(boolean enable) {
        ((ChannelShell)this.channel).setXForwarding(enable);
    }

    @Override
    public void setAgentForwarding(boolean enable) {
        ((ChannelShell)this.channel).setAgentForwarding(enable);
    }

    @Override
    public void terminalType(String terminalType) {
        this.terminalType = terminalType;
    }

    @Override
    public void size(int cols, int rows) {
        this.cols = cols;
        this.rows = rows;
    }

    @Override
    public void dpi(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public void size(int cols, int rows, int width, int height) {
        this.cols = cols;
        this.rows = rows;
        this.width = width;
        this.height = height;
    }

    @Override
    public void resize() {
        try {
            ((ChannelShell)this.channel).setPtySize(this.cols, this.rows, this.width, this.height);
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime((Throwable)e);
        }
    }

    @Override
    public void connect() {
        ((ChannelShell)this.channel).setPtyType(this.terminalType, this.cols, this.rows, this.width, this.height);
        try {
            ((ChannelShell)this.channel).connect();
        }
        catch (Exception e) {
            throw Exceptions.connection((Throwable)e);
        }
    }

    @Override
    public void connect(int timeout) {
        ((ChannelShell)this.channel).setPtyType(this.terminalType, this.cols, this.rows, this.width, this.height);
        try {
            ((ChannelShell)this.channel).connect(timeout);
        }
        catch (Exception e) {
            throw Exceptions.connection((Throwable)e);
        }
    }

    @Override
    public void env(byte[] key, byte[] value) {
        ((ChannelShell)this.channel).setEnv(key, value);
    }

    @Override
    public void env(String key, String value) {
        ((ChannelShell)this.channel).setEnv(key, value);
    }

    @Override
    protected void listenerOutput() {
        try {
            this.streamHandler.accept(this.inputStream);
        }
        finally {
            this.done = true;
            if (this.callback != null) {
                this.callback.run();
            }
        }
    }

    public void exec() {
        if (this.streamHandler == null) {
            throw Exceptions.runtime((String)"shell std output stream handler is null");
        }
        if (!this.isConnected()) {
            throw Exceptions.runtime((String)"channel is not connected");
        }
        this.listenerOutput();
    }

    @Override
    public void close() {
        super.close();
        this.disconnectChannel();
    }

    @Override
    public String getTerminalType() {
        return this.terminalType;
    }

    @Override
    public int getCols() {
        return this.cols;
    }

    @Override
    public int getRows() {
        return this.rows;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }
}

