/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.socket;

import com.orion.lang.utils.Valid;
import java.io.IOException;
import java.net.ServerSocket;

public class Sockets {
    private Sockets() {
    }

    public static ServerSocket create(int[] ports) {
        for (int port : ports) {
            try {
                return new ServerSocket(port);
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    public static ServerSocket create() {
        return Sockets.create(5001, 65535);
    }

    public static ServerSocket create(int start, int end) {
        Valid.gt((Comparable)Integer.valueOf(start), (Comparable)Integer.valueOf(1000), (String)"start port must greater than 1000", (Object[])new Object[0]);
        Valid.gt((Comparable)Integer.valueOf(end), (Comparable)Integer.valueOf(1000), (String)"end port must greater than 1000", (Object[])new Object[0]);
        Valid.lte((Comparable)Integer.valueOf(end), (Comparable)Integer.valueOf(65535), (String)"end port must less than 65536", (Object[])new Object[0]);
        for (int i = start; i <= end; ++i) {
            try {
                return new ServerSocket(i);
            }
            catch (IOException iOException) {
                continue;
            }
        }
        return null;
    }
}

