/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.socket;

import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Threads;
import com.orion.lang.utils.io.Streams;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class TcpReceive
implements AutoCloseable {
    private final int port;
    private final ServerSocket serverSocket;
    private final List<Socket> receiveSocketList;
    private ExecutorService acceptThreadPool;

    public TcpReceive(int port) throws IOException {
        this.port = port;
        this.serverSocket = new ServerSocket(port);
        this.serverSocket.setReceiveBufferSize(4096);
        this.receiveSocketList = new ArrayList<Socket>();
        this.acceptThreadPool = Threads.CACHE_EXECUTOR;
    }

    public TcpReceive bufferSize(int bufferSize) throws SocketException {
        this.serverSocket.setReceiveBufferSize(bufferSize);
        return this;
    }

    public TcpReceive timeout(int timeOut) throws SocketException {
        this.serverSocket.setSoTimeout(timeOut);
        return this;
    }

    public TcpReceive acceptThreadPool(ExecutorService acceptThreadPool) {
        this.acceptThreadPool = acceptThreadPool;
        return this;
    }

    public TcpReceive accept(int count) {
        this.acceptThreadPool.execute(() -> {
            for (int i = 0; i < count; ++i) {
                try {
                    this.receiveSocketList.add(this.serverSocket.accept());
                    continue;
                }
                catch (IOException e) {
                    Exceptions.printStacks((Throwable)e);
                }
            }
        });
        return this;
    }

    public TcpReceive sendAll(byte b) throws IOException {
        for (Socket socket : this.receiveSocketList) {
            if (!socket.isConnected() || socket.isOutputShutdown()) continue;
            OutputStream o = socket.getOutputStream();
            o.write(b);
            o.flush();
        }
        return this;
    }

    public TcpReceive sendAll(byte[] bs) throws IOException {
        return this.sendAll(bs, 0, bs.length);
    }

    public TcpReceive sendAll(byte[] bs, int off, int len) throws IOException {
        Iterator<Socket> iterator = this.receiveSocketList.iterator();
        while (iterator.hasNext()) {
            Socket socket = iterator.next();
            if (socket.isConnected() && !socket.isOutputShutdown()) {
                OutputStream o = socket.getOutputStream();
                o.write(bs, off, len);
                o.flush();
                continue;
            }
            iterator.remove();
        }
        return this;
    }

    public Socket findSocket(String host, int port) {
        Iterator<Socket> iterator = this.receiveSocketList.iterator();
        while (iterator.hasNext()) {
            Socket socket = iterator.next();
            if (socket.isConnected() && !socket.isOutputShutdown()) {
                if (!socket.getInetAddress().getCanonicalHostName().equals(host) || socket.getPort() != port) continue;
                return socket;
            }
            iterator.remove();
        }
        return null;
    }

    public List<Socket> findSocket(String host) {
        ArrayList<Socket> list = new ArrayList<Socket>();
        Iterator<Socket> iterator = this.receiveSocketList.iterator();
        while (iterator.hasNext()) {
            Socket socket = iterator.next();
            if (socket.isConnected() && !socket.isOutputShutdown()) {
                if (!socket.getInetAddress().getCanonicalHostName().equals(host)) continue;
                list.add(socket);
                continue;
            }
            iterator.remove();
        }
        return list;
    }

    public TcpReceive closePool() {
        Threads.shutdownPoolNow((ExecutorService)this.acceptThreadPool, (int)5000, (TimeUnit)TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public void close() {
        this.receiveSocketList.forEach(Streams::close);
        Streams.close((AutoCloseable)this.serverSocket);
    }

    public int getPort() {
        return this.port;
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public List<Socket> getReceiveSocketList() {
        return this.receiveSocketList;
    }
}

