/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.specification.transfer;

import com.orion.lang.support.progress.ByteTransferRateProgress;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.io.FileLocks;
import com.orion.lang.utils.io.Files1;
import com.orion.lang.utils.io.Streams;
import com.orion.net.specification.transfer.IFileDownloader;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public abstract class BaseFileDownloader
implements IFileDownloader {
    protected final String remote;
    protected final File local;
    protected final FileLocks.NamedFileLock lock;
    protected final ByteTransferRateProgress progress;
    protected int bufferSize;
    protected boolean forceOverride;
    protected boolean fileSizeEqualOverride;
    protected Long remoteFileLength;

    public BaseFileDownloader(String remote, File local, String lockSuffix, int bufferSize) {
        Valid.notEmpty((String)remote, (String)"download remote file is empty", (Object[])new Object[0]);
        Valid.notNull((Object)local, (String)"local file is null", (Object[])new Object[0]);
        this.remote = remote;
        this.local = local;
        this.bufferSize = bufferSize;
        this.lock = FileLocks.getSuffixFileLock((String)lockSuffix, (File)local);
        this.progress = new ByteTransferRateProgress(0L);
    }

    @Override
    public void forceOverride(boolean forceOverride) {
        this.forceOverride = forceOverride;
    }

    @Override
    public void fileSizeEqualOverride(boolean fileSizeEqualOverride) {
        this.fileSizeEqualOverride = fileSizeEqualOverride;
    }

    @Override
    public long getRemoteFileLength() throws IOException {
        if (this.remoteFileLength != null) {
            return this.remoteFileLength;
        }
        this.remoteFileLength = this.getRemoteFileSize();
        return this.remoteFileLength;
    }

    @Override
    public boolean checkRemoteFilePresentSizeEqual() throws IOException {
        long remoteLength = this.getRemoteFileLength();
        return remoteLength == -1L || remoteLength == this.local.length();
    }

    protected void startDownload() throws IOException {
        boolean error = false;
        try {
            long remoteSize = this.getRemoteFileLength();
            this.progress.setEnd(remoteSize);
            if (this.forceOverride) {
                Files1.touch((File)this.local);
                this.download();
                return;
            }
            if (Files1.isFile((File)this.local)) {
                long localSize = this.local.length();
                if (localSize == remoteSize) {
                    if (this.fileSizeEqualOverride) {
                        this.download();
                    } else {
                        this.lock.unLock();
                        this.progress.startTime(System.currentTimeMillis());
                        this.transferFinish();
                    }
                } else if (this.lock.isLocked()) {
                    this.breakPointResume(localSize);
                } else {
                    this.download();
                }
            } else {
                Files1.touch((File)this.local);
                this.download();
            }
        }
        catch (Exception e) {
            error = true;
            throw e;
        }
        finally {
            this.progress.finish(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void download() throws IOException {
        this.initDownload(false, 0L);
        this.progress.start();
        this.lock.tryLock();
        BufferedOutputStream out = null;
        try {
            int read;
            out = new BufferedOutputStream(Files1.openOutputStreamFastSafe((File)this.local), this.bufferSize);
            byte[] bs = new byte[this.bufferSize];
            while ((read = this.read(bs)) != -1) {
                this.progress.accept((long)read);
                ((OutputStream)out).write(bs, 0, read);
            }
            this.lock.unLock();
        }
        catch (Throwable throwable) {
            Streams.close(out);
            this.transferFinish();
            throw throwable;
        }
        Streams.close((AutoCloseable)out);
        this.transferFinish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void breakPointResume(long skip) throws IOException {
        this.initDownload(true, skip);
        this.progress.setStart(skip);
        this.progress.setCurrent(skip);
        this.progress.start();
        BufferedOutputStream out = null;
        try {
            int read;
            out = new BufferedOutputStream(Files1.openOutputStreamFastSafe((File)this.local, (boolean)true), this.bufferSize);
            byte[] bs = new byte[this.bufferSize];
            while ((read = this.read(bs)) != -1) {
                this.progress.accept((long)read);
                ((OutputStream)out).write(bs, 0, read);
            }
            this.lock.unLock();
        }
        catch (Throwable throwable) {
            Streams.close(out);
            this.transferFinish();
            throw throwable;
        }
        Streams.close((AutoCloseable)out);
        this.transferFinish();
    }

    protected abstract long getRemoteFileSize() throws IOException;

    protected abstract void initDownload(boolean var1, long var2) throws IOException;

    protected abstract int read(byte[] var1) throws IOException;

    protected abstract void transferFinish() throws IOException;

    @Override
    public ByteTransferRateProgress getProgress() {
        return this.progress;
    }
}

