/*
 * Decompiled with CFR 0.152.
 */
package com.orion.net.specification.transfer;

import com.orion.lang.support.progress.ByteTransferRateProgress;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.io.FileLocks;
import com.orion.lang.utils.io.Files1;
import com.orion.lang.utils.io.Streams;
import com.orion.net.specification.transfer.IFileUploader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public abstract class BaseFileUploader
implements IFileUploader {
    protected final String remote;
    protected final File local;
    protected final FileLocks.NamedFileLock lock;
    protected final ByteTransferRateProgress progress;
    protected int bufferSize;
    protected boolean forceOverride;
    protected boolean fileSizeEqualOverride;
    protected Long remoteFileLength;

    protected BaseFileUploader(String remote, File local, String lockSuffix, int bufferSize) {
        Valid.notEmpty((String)remote, (String)"remote file is empty", (Object[])new Object[0]);
        Valid.notNull((Object)local, (String)"upload file is null", (Object[])new Object[0]);
        if (!local.exists() || !local.isFile()) {
            throw Exceptions.notFound((String)"not found upload local file");
        }
        this.remote = remote;
        this.local = local;
        this.bufferSize = bufferSize;
        this.lock = FileLocks.getSuffixFileLock((String)lockSuffix, (File)local);
        this.progress = new ByteTransferRateProgress(local.length());
    }

    @Override
    public void forceOverride(boolean forceOverride) {
        this.forceOverride = forceOverride;
    }

    @Override
    public void fileSizeEqualOverride(boolean fileSizeEqualOverride) {
        this.fileSizeEqualOverride = fileSizeEqualOverride;
    }

    @Override
    public long getRemoteFileLength() throws IOException {
        if (this.remoteFileLength != null) {
            return this.remoteFileLength;
        }
        this.remoteFileLength = this.getRemoteFileSize();
        return this.remoteFileLength;
    }

    @Override
    public boolean checkRemoteFilePresentSizeEqual() throws IOException {
        long remoteLength = this.getRemoteFileLength();
        return remoteLength == -1L || remoteLength == this.local.length();
    }

    protected void startUpload() throws IOException {
        boolean error = false;
        try {
            if (this.forceOverride) {
                this.upload();
                return;
            }
            long remoteSize = this.getRemoteFileLength();
            if (remoteSize == -1L) {
                this.upload();
            } else if (remoteSize == this.local.length()) {
                if (this.fileSizeEqualOverride) {
                    this.upload();
                } else {
                    this.lock.unLock();
                    this.progress.startTime(System.currentTimeMillis());
                    this.transferFinish();
                }
            } else if (this.lock.isLocked()) {
                this.breakPointResume(remoteSize);
            } else {
                this.upload();
            }
        }
        catch (Exception e) {
            error = true;
            throw e;
        }
        finally {
            this.progress.finish(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void upload() throws IOException {
        this.initUpload(false, 0L);
        this.progress.start();
        this.lock.tryLock();
        BufferedInputStream in = null;
        try {
            int read;
            in = new BufferedInputStream(Files1.openInputStreamFastSafe((File)this.local), this.bufferSize);
            byte[] bs = new byte[this.bufferSize];
            while ((read = ((InputStream)in).read(bs)) != -1) {
                this.progress.accept((long)read);
                this.write(bs, read);
            }
            this.lock.unLock();
        }
        catch (Throwable throwable) {
            Streams.close(in);
            this.transferFinish();
            throw throwable;
        }
        Streams.close((AutoCloseable)in);
        this.transferFinish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void breakPointResume(long skip) throws IOException {
        this.initUpload(true, skip);
        this.progress.setStart(skip);
        this.progress.setCurrent(skip);
        this.progress.start();
        RandomAccessFile access = null;
        try {
            int read;
            access = Files1.openRandomAccessSafe((File)this.local, (String)"r");
            access.seek(skip);
            byte[] bs = new byte[this.bufferSize];
            while ((read = access.read(bs)) != -1) {
                this.progress.accept((long)read);
                this.write(bs, read);
            }
            this.lock.unLock();
        }
        catch (Throwable throwable) {
            Streams.close(access);
            this.transferFinish();
            throw throwable;
        }
        Streams.close((AutoCloseable)access);
        this.transferFinish();
    }

    protected abstract long getRemoteFileSize() throws IOException;

    protected abstract void initUpload(boolean var1, long var2) throws IOException;

    protected abstract void write(byte[] var1, int var2) throws IOException;

    protected abstract void transferFinish() throws IOException;

    @Override
    public ByteTransferRateProgress getProgress() {
        return this.progress;
    }
}

