/*
 * Decompiled with CFR 0.152.
 */
package com.orion.office.csv.core;

import com.orion.lang.able.SafeCloseable;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Objects1;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.io.Files1;
import com.orion.lang.utils.io.Streams;
import com.orion.office.csv.option.CsvOption;
import com.orion.office.csv.option.CsvReaderOption;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;

public class CsvReader
implements SafeCloseable {
    private Reader reader;
    private final DataBuffer dataBuffer = new DataBuffer();
    private final ColumnBuffer columnBuffer = new ColumnBuffer();
    private final RawRecordBuffer rawBuffer = new RawRecordBuffer();
    private final HeadersHolder headersHolder = new HeadersHolder();
    private boolean[] isQualified;
    private String rawRecord = "";
    private boolean startedColumn;
    private boolean startedWithQualifier;
    private boolean hasMoreData = true;
    private char lastLetter = '\u0000';
    private boolean hasReadNextLine;
    private int currentColumnCount;
    private long currentRecord;
    private CsvReaderOption option;
    private boolean closed;
    private String[] values = new String[10];

    public CsvReader(String file) {
        this(file, ',', StandardCharsets.UTF_8);
    }

    public CsvReader(String file, char delimiter) {
        this(file, delimiter, StandardCharsets.UTF_8);
    }

    public CsvReader(String file, char delimiter, Charset charset) {
        this(file, new CsvReaderOption(delimiter, charset));
    }

    public CsvReader(String file, CsvReaderOption option) {
        this((InputStream)Files1.openInputStreamSafe((String)file), option);
    }

    public CsvReader(File file) {
        this(file, ',', StandardCharsets.UTF_8);
    }

    public CsvReader(File file, char delimiter) {
        this(file, delimiter, StandardCharsets.UTF_8);
    }

    public CsvReader(File file, char delimiter, Charset charset) {
        this(file, new CsvReaderOption(delimiter, charset));
    }

    public CsvReader(File file, CsvReaderOption option) {
        this((InputStream)Files1.openInputStreamSafe((File)file), option);
    }

    public CsvReader(InputStream in) {
        this(new InputStreamReader(in, StandardCharsets.UTF_8));
    }

    public CsvReader(InputStream in, Charset charset) {
        this(new InputStreamReader(in, charset));
    }

    public CsvReader(InputStream in, char delimiter, Charset charset) {
        this((Reader)new InputStreamReader(in, charset), delimiter);
    }

    public CsvReader(InputStream in, CsvReaderOption option) {
        Valid.notNull((Object)in, (String)"inputStream can not be null", (Object[])new Object[0]);
        this.option = (CsvReaderOption)Objects1.def((Object)option, CsvReaderOption::new);
        this.reader = new InputStreamReader(in, this.option.getCharset());
        this.isQualified = new boolean[this.values.length];
    }

    public CsvReader(Reader reader) {
        this(reader, new CsvReaderOption(','));
    }

    public CsvReader(Reader reader, char delimiter) {
        this(reader, new CsvReaderOption(delimiter));
    }

    public CsvReader(Reader reader, CsvReaderOption option) {
        Valid.notNull((Object)reader, (String)"reader can not be null", (Object[])new Object[0]);
        this.reader = reader;
        this.option = (CsvReaderOption)Objects1.def((Object)option, CsvReaderOption::new);
        this.isQualified = new boolean[this.values.length];
    }

    public static CsvReader parse(String data) {
        Valid.notBlank((String)data, (String)"data is blank", (Object[])new Object[0]);
        return new CsvReader(new StringReader(data));
    }

    public static CsvReader parse(String data, char delimiter) {
        Valid.notBlank((String)data, (String)"data is blank", (Object[])new Object[0]);
        return new CsvReader((Reader)new StringReader(data), new CsvReaderOption(delimiter));
    }

    public static CsvReader parse(String data, CsvReaderOption option) {
        Valid.notBlank((String)data, (String)"data is blank", (Object[])new Object[0]);
        return new CsvReader((Reader)new StringReader(data), option);
    }

    public String[] getRow() {
        String[] clone = new String[this.currentColumnCount];
        System.arraycopy(this.values, 0, clone, 0, this.currentColumnCount);
        return clone;
    }

    public String getRawRow() {
        return this.rawRecord;
    }

    public String get(int columnIndex) {
        if (columnIndex > -1 && columnIndex < this.currentColumnCount) {
            return this.values[columnIndex];
        }
        return "";
    }

    public String get(String headerName) {
        return this.get(this.getHeaderIndex(headerName));
    }

    public void setHeaders(String[] headers) {
        this.headersHolder.headers = headers;
        this.headersHolder.indexByName.clear();
        this.headersHolder.length = headers != null ? headers.length : 0;
        for (int i = 0; i < this.headersHolder.length; ++i) {
            this.headersHolder.indexByName.put(headers[i], i);
        }
    }

    public boolean readHeaders() throws IOException {
        boolean result = this.readRow();
        this.headersHolder.length = this.currentColumnCount;
        this.headersHolder.headers = new String[this.currentColumnCount];
        for (int i = 0; i < this.headersHolder.length; ++i) {
            String columnValue;
            this.headersHolder.headers[i] = columnValue = this.get(i);
            this.headersHolder.indexByName.put(columnValue, i);
        }
        if (result) {
            --this.currentRecord;
        }
        this.currentColumnCount = 0;
        return result;
    }

    public boolean readRow() throws IOException {
        this.checkClosed();
        this.currentColumnCount = 0;
        this.rawBuffer.position = 0;
        this.dataBuffer.lineStart = this.dataBuffer.position;
        this.hasReadNextLine = false;
        if (this.hasMoreData) {
            do {
                if (this.dataBuffer.position == this.dataBuffer.count) {
                    this.checkDataLength();
                    continue;
                }
                this.startedWithQualifier = false;
                char currentLetter = this.dataBuffer.buffer[this.dataBuffer.position];
                if (this.option.isUseTextQualifier() && currentLetter == this.option.getTextQualifier()) {
                    this.lastLetter = currentLetter;
                    this.startedColumn = true;
                    this.dataBuffer.columnStart = this.dataBuffer.position + 1;
                    this.startedWithQualifier = true;
                    boolean lastLetterWasQualifier = false;
                    char escapeChar = this.option.getTextQualifier();
                    if (this.option.getEscapeMode() == CsvOption.ESCAPE_MODE_BACKSLASH) {
                        escapeChar = '\\';
                    }
                    boolean eatingTrailingJunk = false;
                    boolean lastLetterWasEscape = false;
                    boolean readingComplexEscape = false;
                    int escape = 1;
                    int escapeLength = 0;
                    char escapeValue = '\u0000';
                    ++this.dataBuffer.position;
                    do {
                        if (this.dataBuffer.position == this.dataBuffer.count) {
                            this.checkDataLength();
                            continue;
                        }
                        currentLetter = this.dataBuffer.buffer[this.dataBuffer.position];
                        if (eatingTrailingJunk) {
                            this.dataBuffer.columnStart = this.dataBuffer.position + 1;
                            if (currentLetter == this.option.getDelimiter()) {
                                this.endColumn();
                            } else if (!this.option.isUseCustomLineDelimiter() && (currentLetter == '\r' || currentLetter == '\n') || this.option.isUseCustomLineDelimiter() && currentLetter == this.option.getLineDelimiter()) {
                                this.endColumn();
                                this.endRecord();
                            }
                        } else if (readingComplexEscape) {
                            ++escapeLength;
                            switch (escape) {
                                case 1: {
                                    escapeValue = (char)(escapeValue * 16);
                                    escapeValue = (char)(escapeValue + CsvReader.hexToDec(currentLetter));
                                    if (escapeLength != 4) break;
                                    readingComplexEscape = false;
                                    break;
                                }
                                case 2: {
                                    escapeValue = (char)(escapeValue * 8);
                                    escapeValue = (char)(escapeValue + (char)(currentLetter - 48));
                                    if (escapeLength != 3) break;
                                    readingComplexEscape = false;
                                    break;
                                }
                                case 3: {
                                    escapeValue = (char)(escapeValue * 10);
                                    escapeValue = (char)(escapeValue + (char)(currentLetter - 48));
                                    if (escapeLength != 3) break;
                                    readingComplexEscape = false;
                                    break;
                                }
                                case 4: {
                                    escapeValue = (char)(escapeValue * 16);
                                    escapeValue = (char)(escapeValue + CsvReader.hexToDec(currentLetter));
                                    if (escapeLength != 2) break;
                                    readingComplexEscape = false;
                                }
                            }
                            if (!readingComplexEscape) {
                                this.appendLetter(escapeValue);
                            } else {
                                this.dataBuffer.columnStart = this.dataBuffer.position + 1;
                            }
                        } else if (currentLetter == this.option.getTextQualifier()) {
                            if (lastLetterWasEscape) {
                                lastLetterWasEscape = false;
                                lastLetterWasQualifier = false;
                            } else {
                                this.updateCurrentValue();
                                if (this.option.getEscapeMode() == CsvOption.ESCAPE_MODE_DOUBLED) {
                                    lastLetterWasEscape = true;
                                }
                                lastLetterWasQualifier = true;
                            }
                        } else if (this.option.getEscapeMode() == CsvOption.ESCAPE_MODE_BACKSLASH && lastLetterWasEscape) {
                            switch (currentLetter) {
                                case 'n': {
                                    this.appendLetter('\n');
                                    break;
                                }
                                case 'r': {
                                    this.appendLetter('\r');
                                    break;
                                }
                                case 't': {
                                    this.appendLetter('\t');
                                    break;
                                }
                                case 'b': {
                                    this.appendLetter('\b');
                                    break;
                                }
                                case 'f': {
                                    this.appendLetter('\f');
                                    break;
                                }
                                case 'e': {
                                    this.appendLetter('\u001b');
                                    break;
                                }
                                case 'v': {
                                    this.appendLetter('\u000b');
                                    break;
                                }
                                case 'a': {
                                    this.appendLetter('\u0007');
                                    break;
                                }
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': {
                                    escape = 2;
                                    readingComplexEscape = true;
                                    escapeLength = 1;
                                    escapeValue = (char)(currentLetter - 48);
                                    this.dataBuffer.columnStart = this.dataBuffer.position + 1;
                                    break;
                                }
                                case 'D': 
                                case 'O': 
                                case 'U': 
                                case 'X': 
                                case 'd': 
                                case 'o': 
                                case 'u': 
                                case 'x': {
                                    switch (currentLetter) {
                                        case 'U': 
                                        case 'u': {
                                            escape = 1;
                                            break;
                                        }
                                        case 'X': 
                                        case 'x': {
                                            escape = 4;
                                            break;
                                        }
                                        case 'O': 
                                        case 'o': {
                                            escape = 2;
                                            break;
                                        }
                                        case 'D': 
                                        case 'd': {
                                            escape = 3;
                                        }
                                    }
                                    readingComplexEscape = true;
                                    escapeLength = 0;
                                    escapeValue = '\u0000';
                                    this.dataBuffer.columnStart = this.dataBuffer.position + 1;
                                    break;
                                }
                            }
                            lastLetterWasEscape = false;
                        } else if (currentLetter == escapeChar) {
                            this.updateCurrentValue();
                            lastLetterWasEscape = true;
                        } else if (lastLetterWasQualifier) {
                            if (currentLetter == this.option.getDelimiter()) {
                                this.endColumn();
                            } else if (!this.option.isUseCustomLineDelimiter() && (currentLetter == '\r' || currentLetter == '\n') || this.option.isUseCustomLineDelimiter() && currentLetter == this.option.getLineDelimiter()) {
                                this.endColumn();
                                this.endRecord();
                            } else {
                                this.dataBuffer.columnStart = this.dataBuffer.position + 1;
                                eatingTrailingJunk = true;
                            }
                            lastLetterWasQualifier = false;
                        }
                        this.lastLetter = currentLetter;
                        if (!this.startedColumn) continue;
                        ++this.dataBuffer.position;
                        if (!this.option.isSafetySwitch() || this.dataBuffer.position - this.dataBuffer.columnStart + this.columnBuffer.position <= 100000) continue;
                        this.close();
                        throw Exceptions.unsafe((String)("maximum column length of 100,000 exceeded in column " + NumberFormat.getIntegerInstance().format(this.currentColumnCount) + " in record " + NumberFormat.getIntegerInstance().format(this.currentRecord) + ". Set the SafetySwitch property to false if you're expecting column lengths greater than 100,000 characters to avoid this error."));
                    } while (this.hasMoreData && this.startedColumn);
                } else if (currentLetter == this.option.getDelimiter()) {
                    this.lastLetter = currentLetter;
                    this.endColumn();
                } else if (this.option.isUseCustomLineDelimiter() && currentLetter == this.option.getLineDelimiter()) {
                    if (this.startedColumn || this.currentColumnCount > 0 || !this.option.isSkipEmptyRows()) {
                        this.endColumn();
                        this.endRecord();
                    } else {
                        this.dataBuffer.lineStart = this.dataBuffer.position + 1;
                    }
                    this.lastLetter = currentLetter;
                } else if (!(this.option.isUseCustomLineDelimiter() || currentLetter != '\r' && currentLetter != '\n')) {
                    if (this.startedColumn || this.currentColumnCount > 0 || !this.option.isSkipEmptyRows() && (currentLetter == '\r' || this.lastLetter != '\r')) {
                        this.endColumn();
                        this.endRecord();
                    } else {
                        this.dataBuffer.lineStart = this.dataBuffer.position + 1;
                    }
                    this.lastLetter = currentLetter;
                } else if (this.option.isUseComments() && this.currentColumnCount == 0 && currentLetter == this.option.getComment()) {
                    this.lastLetter = currentLetter;
                    this.clear();
                } else if (this.option.isTrim() && (currentLetter == ' ' || currentLetter == '\t')) {
                    this.startedColumn = true;
                    this.dataBuffer.columnStart = this.dataBuffer.position + 1;
                } else {
                    this.startedColumn = true;
                    this.dataBuffer.columnStart = this.dataBuffer.position;
                    boolean lastLetterWasBackslash = false;
                    boolean readingComplexEscape = false;
                    int escape = 1;
                    int escapeLength = 0;
                    char escapeValue = '\u0000';
                    boolean firstLoop = true;
                    do {
                        if (!firstLoop && this.dataBuffer.position == this.dataBuffer.count) {
                            this.checkDataLength();
                            continue;
                        }
                        if (!firstLoop) {
                            currentLetter = this.dataBuffer.buffer[this.dataBuffer.position];
                        }
                        if (!this.option.isUseTextQualifier() && this.option.getEscapeMode() == CsvOption.ESCAPE_MODE_BACKSLASH && currentLetter == '\\') {
                            if (lastLetterWasBackslash) {
                                lastLetterWasBackslash = false;
                            } else {
                                this.updateCurrentValue();
                                lastLetterWasBackslash = true;
                            }
                        } else if (readingComplexEscape) {
                            ++escapeLength;
                            switch (escape) {
                                case 1: {
                                    escapeValue = (char)(escapeValue * 16);
                                    escapeValue = (char)(escapeValue + CsvReader.hexToDec(currentLetter));
                                    if (escapeLength != 4) break;
                                    readingComplexEscape = false;
                                    break;
                                }
                                case 2: {
                                    escapeValue = (char)(escapeValue * 8);
                                    escapeValue = (char)(escapeValue + (char)(currentLetter - 48));
                                    if (escapeLength != 3) break;
                                    readingComplexEscape = false;
                                    break;
                                }
                                case 3: {
                                    escapeValue = (char)(escapeValue * 10);
                                    escapeValue = (char)(escapeValue + (char)(currentLetter - 48));
                                    if (escapeLength != 3) break;
                                    readingComplexEscape = false;
                                    break;
                                }
                                case 4: {
                                    escapeValue = (char)(escapeValue * 16);
                                    escapeValue = (char)(escapeValue + CsvReader.hexToDec(currentLetter));
                                    if (escapeLength != 2) break;
                                    readingComplexEscape = false;
                                }
                            }
                            if (!readingComplexEscape) {
                                this.appendLetter(escapeValue);
                            } else {
                                this.dataBuffer.columnStart = this.dataBuffer.position + 1;
                            }
                        } else if (this.option.getEscapeMode() == CsvOption.ESCAPE_MODE_BACKSLASH && lastLetterWasBackslash) {
                            switch (currentLetter) {
                                case 'n': {
                                    this.appendLetter('\n');
                                    break;
                                }
                                case 'r': {
                                    this.appendLetter('\r');
                                    break;
                                }
                                case 't': {
                                    this.appendLetter('\t');
                                    break;
                                }
                                case 'b': {
                                    this.appendLetter('\b');
                                    break;
                                }
                                case 'f': {
                                    this.appendLetter('\f');
                                    break;
                                }
                                case 'e': {
                                    this.appendLetter('\u001b');
                                    break;
                                }
                                case 'v': {
                                    this.appendLetter('\u000b');
                                    break;
                                }
                                case 'a': {
                                    this.appendLetter('\u0007');
                                    break;
                                }
                                case '0': 
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': {
                                    escape = 2;
                                    readingComplexEscape = true;
                                    escapeLength = 1;
                                    escapeValue = (char)(currentLetter - 48);
                                    this.dataBuffer.columnStart = this.dataBuffer.position + 1;
                                    break;
                                }
                                case 'D': 
                                case 'O': 
                                case 'U': 
                                case 'X': 
                                case 'd': 
                                case 'o': 
                                case 'u': 
                                case 'x': {
                                    switch (currentLetter) {
                                        case 'U': 
                                        case 'u': {
                                            escape = 1;
                                            break;
                                        }
                                        case 'X': 
                                        case 'x': {
                                            escape = 4;
                                            break;
                                        }
                                        case 'O': 
                                        case 'o': {
                                            escape = 2;
                                            break;
                                        }
                                        case 'D': 
                                        case 'd': {
                                            escape = 3;
                                        }
                                    }
                                    readingComplexEscape = true;
                                    escapeLength = 0;
                                    escapeValue = '\u0000';
                                    this.dataBuffer.columnStart = this.dataBuffer.position + 1;
                                    break;
                                }
                            }
                            lastLetterWasBackslash = false;
                        } else if (currentLetter == this.option.getDelimiter()) {
                            this.endColumn();
                        } else if (!this.option.isUseCustomLineDelimiter() && (currentLetter == '\r' || currentLetter == '\n') || this.option.isUseCustomLineDelimiter() && currentLetter == this.option.getLineDelimiter()) {
                            this.endColumn();
                            this.endRecord();
                        }
                        this.lastLetter = currentLetter;
                        firstLoop = false;
                        if (!this.startedColumn) continue;
                        ++this.dataBuffer.position;
                        if (!this.option.isSafetySwitch() || this.dataBuffer.position - this.dataBuffer.columnStart + this.columnBuffer.position <= 100000) continue;
                        this.close();
                        throw Exceptions.unsafe((String)("maximum column length of 100,000 exceeded in column " + NumberFormat.getIntegerInstance().format(this.currentColumnCount) + " in record " + NumberFormat.getIntegerInstance().format(this.currentRecord) + ". Set the SafetySwitch property to false if you're expecting column lengths greater than 100,000 characters to avoid this error."));
                    } while (this.hasMoreData && this.startedColumn);
                }
                if (!this.hasMoreData) continue;
                ++this.dataBuffer.position;
            } while (this.hasMoreData && !this.hasReadNextLine);
            if (this.startedColumn || this.lastLetter == this.option.getDelimiter()) {
                this.endColumn();
                this.endRecord();
            }
        }
        this.rawRecord = !this.option.isSkipRawRow() ? (this.hasMoreData ? (this.rawBuffer.position == 0 ? new String(this.dataBuffer.buffer, this.dataBuffer.lineStart, this.dataBuffer.position - this.dataBuffer.lineStart - 1) : new String(this.rawBuffer.buffer, 0, this.rawBuffer.position) + new String(this.dataBuffer.buffer, this.dataBuffer.lineStart, this.dataBuffer.position - this.dataBuffer.lineStart - 1)) : new String(this.rawBuffer.buffer, 0, this.rawBuffer.position)) : "";
        return this.hasReadNextLine;
    }

    public boolean skipRecord() throws IOException {
        this.checkClosed();
        boolean recordRead = false;
        if (this.hasMoreData && (recordRead = this.readRow())) {
            --this.currentRecord;
        }
        return recordRead;
    }

    public boolean clear() throws IOException {
        this.checkClosed();
        this.currentColumnCount = 0;
        boolean skippedLine = false;
        if (this.hasMoreData) {
            boolean foundEol = false;
            do {
                if (this.dataBuffer.position == this.dataBuffer.count) {
                    this.checkDataLength();
                    continue;
                }
                skippedLine = true;
                char currentLetter = this.dataBuffer.buffer[this.dataBuffer.position];
                if (currentLetter == '\r' || currentLetter == '\n') {
                    foundEol = true;
                }
                this.lastLetter = currentLetter;
                if (foundEol) continue;
                ++this.dataBuffer.position;
            } while (this.hasMoreData && !foundEol);
            this.columnBuffer.position = 0;
            this.dataBuffer.lineStart = this.dataBuffer.position + 1;
        }
        this.rawBuffer.position = 0;
        this.rawRecord = "";
        return skippedLine;
    }

    private void checkDataLength() throws IOException {
        this.updateCurrentValue();
        if (!this.option.isSkipRawRow() && this.dataBuffer.count > 0) {
            if (this.rawBuffer.buffer.length - this.rawBuffer.position < this.dataBuffer.count - this.dataBuffer.lineStart) {
                int newLength = this.rawBuffer.buffer.length + Math.max(this.dataBuffer.count - this.dataBuffer.lineStart, this.rawBuffer.buffer.length);
                char[] holder = new char[newLength];
                System.arraycopy(this.rawBuffer.buffer, 0, holder, 0, this.rawBuffer.position);
                this.rawBuffer.buffer = holder;
            }
            System.arraycopy(this.dataBuffer.buffer, this.dataBuffer.lineStart, this.rawBuffer.buffer, this.rawBuffer.position, this.dataBuffer.count - this.dataBuffer.lineStart);
            this.rawBuffer.position += this.dataBuffer.count - this.dataBuffer.lineStart;
        }
        try {
            this.dataBuffer.count = this.reader.read(this.dataBuffer.buffer, 0, this.dataBuffer.buffer.length);
        }
        catch (IOException ex) {
            this.close();
            throw ex;
        }
        if (this.dataBuffer.count == -1) {
            this.hasMoreData = false;
        }
        this.dataBuffer.position = 0;
        this.dataBuffer.lineStart = 0;
        this.dataBuffer.columnStart = 0;
    }

    private void endColumn() {
        String currentValue = "";
        if (this.startedColumn) {
            int lastLetter;
            if (this.columnBuffer.position == 0) {
                if (this.dataBuffer.columnStart < this.dataBuffer.position) {
                    if (this.option.isTrim() && !this.startedWithQualifier) {
                        for (lastLetter = this.dataBuffer.position - 1; lastLetter >= this.dataBuffer.columnStart && (this.dataBuffer.buffer[lastLetter] == ' ' || this.dataBuffer.buffer[lastLetter] == '\t'); --lastLetter) {
                        }
                    }
                    currentValue = new String(this.dataBuffer.buffer, this.dataBuffer.columnStart, lastLetter - this.dataBuffer.columnStart + 1);
                }
            } else {
                this.updateCurrentValue();
                if (this.option.isTrim() && !this.startedWithQualifier) {
                    for (lastLetter = this.columnBuffer.position - 1; lastLetter >= 0 && (this.columnBuffer.buffer[lastLetter] == ' ' || this.columnBuffer.buffer[lastLetter] == ' '); --lastLetter) {
                    }
                }
                currentValue = new String(this.columnBuffer.buffer, 0, lastLetter + 1);
            }
        }
        this.columnBuffer.position = 0;
        this.startedColumn = false;
        if (this.currentColumnCount >= 100000 && this.option.isSafetySwitch()) {
            this.close();
            throw Exceptions.unsafe((String)("maximum column count of 100,000 exceeded in record " + NumberFormat.getIntegerInstance().format(this.currentRecord) + ". Set the SafetySwitch property to false if you're expecting more than 100,000 columns per record to avoid this error."));
        }
        if (this.currentColumnCount == this.values.length) {
            int newLength = this.values.length * 2;
            String[] holder = new String[newLength];
            System.arraycopy(this.values, 0, holder, 0, this.values.length);
            this.values = holder;
            boolean[] qualifiedHolder = new boolean[newLength];
            System.arraycopy(this.isQualified, 0, qualifiedHolder, 0, this.isQualified.length);
            this.isQualified = qualifiedHolder;
        }
        this.values[this.currentColumnCount] = currentValue;
        this.isQualified[this.currentColumnCount] = this.startedWithQualifier;
        currentValue = "";
        ++this.currentColumnCount;
    }

    private void appendLetter(char letter) {
        if (this.columnBuffer.position == this.columnBuffer.buffer.length) {
            int newLength = this.columnBuffer.buffer.length * 2;
            char[] holder = new char[newLength];
            System.arraycopy(this.columnBuffer.buffer, 0, holder, 0, this.columnBuffer.position);
            this.columnBuffer.buffer = holder;
        }
        this.columnBuffer.buffer[this.columnBuffer.position++] = letter;
        this.dataBuffer.columnStart = this.dataBuffer.position + 1;
    }

    private void updateCurrentValue() {
        if (this.startedColumn && this.dataBuffer.columnStart < this.dataBuffer.position) {
            if (this.columnBuffer.buffer.length - this.columnBuffer.position < this.dataBuffer.position - this.dataBuffer.columnStart) {
                int newLength = this.columnBuffer.buffer.length + Math.max(this.dataBuffer.position - this.dataBuffer.columnStart, this.columnBuffer.buffer.length);
                char[] holder = new char[newLength];
                System.arraycopy(this.columnBuffer.buffer, 0, holder, 0, this.columnBuffer.position);
                this.columnBuffer.buffer = holder;
            }
            System.arraycopy(this.dataBuffer.buffer, this.dataBuffer.columnStart, this.columnBuffer.buffer, this.columnBuffer.position, this.dataBuffer.position - this.dataBuffer.columnStart);
            this.columnBuffer.position += this.dataBuffer.position - this.dataBuffer.columnStart;
        }
        this.dataBuffer.columnStart = this.dataBuffer.position + 1;
    }

    private void endRecord() {
        this.hasReadNextLine = true;
        ++this.currentRecord;
    }

    private void checkClosed() {
        if (this.closed) {
            throw Exceptions.ioRuntime((String)"this instance already been closed");
        }
    }

    public void close() {
        if (!this.closed) {
            this.headersHolder.headers = null;
            this.headersHolder.indexByName = null;
            this.dataBuffer.buffer = null;
            this.columnBuffer.buffer = null;
            this.rawBuffer.buffer = null;
            Streams.close((AutoCloseable)this.reader);
            this.reader = null;
            this.closed = true;
        }
    }

    public CsvReaderOption getOption() {
        return this.option;
    }

    public void setOption(CsvReaderOption option) {
        this.option = option;
    }

    public boolean isQualified(int columnIndex) {
        if (columnIndex < this.currentColumnCount && columnIndex > -1) {
            return this.isQualified[columnIndex];
        }
        return false;
    }

    public int getCurrentColumnCount() {
        return this.currentColumnCount;
    }

    public long getCurrentIndex() {
        return this.currentRecord - 1L;
    }

    public String[] getHeaders() {
        this.checkClosed();
        if (this.headersHolder.headers == null) {
            return null;
        }
        String[] clone = new String[this.headersHolder.length];
        System.arraycopy(this.headersHolder.headers, 0, clone, 0, this.headersHolder.length);
        return clone;
    }

    public String getHeader(int columnIndex) {
        if (columnIndex > -1 && columnIndex < this.headersHolder.length) {
            return this.headersHolder.headers[columnIndex];
        }
        return "";
    }

    public int getHeaderIndex(String headerName) {
        this.checkClosed();
        Integer indexValue = this.headersHolder.indexByName.get(headerName);
        if (indexValue != null) {
            return indexValue;
        }
        return -1;
    }

    public int getHeaderCount() {
        return this.headersHolder.length;
    }

    private static char hexToDec(char hex) {
        char result = hex >= 'a' ? (char)(hex - 97 + 10) : (hex >= 'A' ? (char)(hex - 65 + 10) : (char)(hex - 48));
        return result;
    }

    private static class HeadersHolder {
        public String[] headers = null;
        public int length = 0;
        public Map<String, Integer> indexByName = new HashMap<String, Integer>();
    }

    private static class RawRecordBuffer {
        public char[] buffer = new char[500];
        public int position = 0;
    }

    private static class ColumnBuffer {
        public char[] buffer = new char[50];
        public int position = 0;
    }

    private static class DataBuffer {
        public char[] buffer = new char[1024];
        public int position = 0;
        public int count = 0;
        public int columnStart = 0;
        public int lineStart = 0;
    }
}

