/*
 * Decompiled with CFR 0.152.
 */
package com.orion.office.csv.merge;

import com.orion.lang.able.SafeCloseable;
import com.orion.lang.constant.Const;
import com.orion.lang.utils.io.Streams;
import com.orion.office.csv.reader.CsvArrayReader;
import com.orion.office.csv.writer.CsvArrayWriter;
import java.util.Collection;

public class CsvMerge
implements SafeCloseable {
    private final CsvArrayWriter writer;
    private int skipRows;
    private int bufferLine;

    public CsvMerge(CsvArrayWriter writer) {
        this.writer = writer;
        this.bufferLine = Const.N_100;
    }

    public CsvMerge header(String ... header) {
        this.writer.headers(header);
        return this;
    }

    public CsvMerge bufferLine(int bufferLine) {
        this.bufferLine = bufferLine;
        return this;
    }

    public CsvMerge skip() {
        this.writer.skip();
        return this;
    }

    public CsvMerge skip(int skip) {
        this.writer.skip(skip);
        return this;
    }

    public CsvMerge skipRows() {
        ++this.skipRows;
        return this;
    }

    public CsvMerge skipRows(int skip) {
        this.skipRows += skip;
        return this;
    }

    public CsvMerge merge(CsvArrayReader reader) {
        Collection lines;
        if (this.skipRows != 0) {
            reader.skip(this.skipRows);
        }
        while (!(lines = reader.clear().read(this.bufferLine).getRows()).isEmpty()) {
            this.writer.addRows(lines);
        }
        this.skipRows = 0;
        this.writer.flush();
        return this;
    }

    public void close() {
        Streams.close((AutoCloseable)((Object)this.writer));
    }

    public CsvArrayWriter getWriter() {
        return this.writer;
    }
}

