/*
 * Decompiled with CFR 0.152.
 */
package com.orion.office.csv.reader;

import com.orion.lang.able.SafeCloseable;
import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Valid;
import com.orion.office.csv.core.CsvReader;
import com.orion.office.csv.option.CsvReaderOption;
import com.orion.office.csv.reader.CsvReaderIterator;
import java.util.Collection;
import java.util.function.Consumer;

public abstract class BaseCsvReader<T>
implements SafeCloseable,
Iterable<T> {
    protected final CsvReader reader;
    protected int rowNum;
    protected boolean end;
    protected Collection<T> rows;
    protected Consumer<T> consumer;
    protected boolean store;

    protected BaseCsvReader(CsvReader reader, Collection<T> rows, Consumer<T> consumer) {
        this.reader = (CsvReader)Valid.notNull((Object)reader, (String)"reader is null", (Object[])new Object[0]);
        if (rows == null && consumer == null) {
            throw Exceptions.argument((String)"rows container or row consumer one of them must not be empty");
        }
        this.rows = rows;
        this.consumer = consumer;
        this.store = rows != null;
    }

    @Override
    public CsvReaderIterator<T> iterator() {
        return new CsvReaderIterator(this);
    }

    public BaseCsvReader<T> skip() {
        try {
            this.reader.skipRecord();
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime((Throwable)e);
        }
        return this;
    }

    public BaseCsvReader<T> skip(int i) {
        for (int s = 0; s < i; ++s) {
            this.skip();
        }
        return this;
    }

    public BaseCsvReader<T> skipEmptyRows(boolean skip) {
        this.reader.getOption().setSkipEmptyRows(skip);
        return this;
    }

    public BaseCsvReader<T> read() {
        while (!this.end) {
            this.readRow();
        }
        return this;
    }

    public BaseCsvReader<T> read(int i) {
        for (int j = 0; j < i && !this.end; ++j) {
            this.readRow();
        }
        return this;
    }

    protected void readRow() {
        T row = this.nextRow();
        if (this.end) {
            return;
        }
        if (this.store) {
            this.rows.add(row);
        } else {
            this.consumer.accept(row);
        }
    }

    protected T nextRow() {
        if (this.end) {
            return null;
        }
        try {
            boolean read = this.reader.readRow();
            if (!read) {
                this.end = true;
                return null;
            }
            ++this.rowNum;
            return this.parserRow(this.reader.getRow());
        }
        catch (Exception e) {
            throw Exceptions.ioRuntime((Throwable)e);
        }
    }

    protected abstract T parserRow(String[] var1);

    protected String get(String[] row, int index) {
        return this.get(row, index, null);
    }

    protected String get(String[] row, int index, String def) {
        if (index < row.length) {
            return row[index];
        }
        return def;
    }

    public void close() {
        this.reader.close();
    }

    public BaseCsvReader<T> clear() {
        if (this.store && this.rows != null) {
            this.rows.clear();
        }
        return this;
    }

    public CsvReader getReader() {
        return this.reader;
    }

    public CsvReaderOption getOption() {
        return this.reader.getOption();
    }

    public String getRaw() {
        return this.reader.getRawRow();
    }

    public Collection<T> getRows() {
        return this.rows;
    }

    public int getRowNum() {
        return this.rowNum;
    }
}

