/*
 * Decompiled with CFR 0.152.
 */
package com.orion.office.csv.reader;

import com.orion.lang.utils.Exceptions;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.reflect.Annotations;
import com.orion.lang.utils.reflect.Constructors;
import com.orion.lang.utils.reflect.Fields;
import com.orion.lang.utils.reflect.Methods;
import com.orion.office.csv.annotation.ImportField;
import com.orion.office.csv.annotation.ImportIgnore;
import com.orion.office.csv.annotation.ImportSetting;
import com.orion.office.csv.core.CsvReader;
import com.orion.office.csv.option.CsvReaderOption;
import com.orion.office.csv.reader.BaseCsvReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CsvBeanReader<T>
extends BaseCsvReader<T> {
    private final Class<T> targetClass;
    private Constructor<T> constructor;
    private boolean nullInvoke;
    private Map<String, Method> setters;
    protected Map<Integer, String> mapping;

    public CsvBeanReader(CsvReader reader, Class<T> targetClass) {
        this(reader, targetClass, new ArrayList(), null);
    }

    public CsvBeanReader(CsvReader reader, Class<T> targetClass, List<T> rows) {
        this(reader, targetClass, rows, null);
    }

    public CsvBeanReader(CsvReader reader, Class<T> targetClass, Consumer<T> consumer) {
        this(reader, targetClass, null, consumer);
    }

    protected CsvBeanReader(CsvReader reader, Class<T> targetClass, List<T> rows, Consumer<T> consumer) {
        super(reader, rows, consumer);
        this.targetClass = (Class)Valid.notNull(targetClass, (String)"target class is null", (Object[])new Object[0]);
        this.mapping = new TreeMap<Integer, String>();
        this.parseClass();
        this.parseField();
    }

    public CsvBeanReader<T> nullInvoke() {
        this.nullInvoke = true;
        return this;
    }

    public CsvBeanReader<T> mapping(String field, int column) {
        return this.mapping(column, field);
    }

    public CsvBeanReader<T> mapping(int column, String field) {
        Method method = this.setters.get(field);
        if (method == null) {
            throw Exceptions.parse((String)("not found " + field + " setter method"));
        }
        this.mapping.put(column, field);
        return this;
    }

    @Override
    protected T parserRow(String[] row) {
        Object t = Constructors.newInstance(this.constructor);
        this.mapping.forEach((? super K k, ? super V v) -> {
            Method setter = this.setters.get(v);
            if (setter == null) {
                return;
            }
            String value = this.get(row, (int)k);
            if (value != null) {
                try {
                    Methods.invokeSetterInfer((Object)t, (Method)setter, (Object)value);
                }
                catch (Exception e) {
                    Exceptions.printStacks((Throwable)e);
                }
            } else if (this.nullInvoke) {
                Methods.invokeMethod((Object)t, (Method)setter, (Object[])new Object[]{null});
            }
        });
        return (T)t;
    }

    protected void parseClass() {
        this.constructor = (Constructor)Valid.notNull((Object)Constructors.getDefaultConstructor(this.targetClass), (String)"target class not found default constructor", (Object[])new Object[0]);
        ImportSetting setting = (ImportSetting)Annotations.getAnnotation(this.targetClass, ImportSetting.class);
        CsvReaderOption option = new CsvReaderOption();
        if (setting == null) {
            this.reader.setOption(option);
            return;
        }
        option.setCaseSensitive(setting.caseSensitive()).setUseComments(setting.useComments()).setSafetySwitch(setting.safetySwitch()).setSkipEmptyRows(setting.skipEmptyRows()).setSkipRawRow(setting.skipRawRow());
        option.setTextQualifier(setting.textQualifier()).setUseTextQualifier(setting.useTextQualifier()).setDelimiter(setting.delimiter()).setLineDelimiter(setting.lineDelimiter()).setComment(setting.comment()).setEscapeMode(setting.escapeMode()).setUseTextQualifier(setting.useTextQualifier()).setCharset(Charset.forName(setting.charset())).setTrim(setting.trim());
        this.reader.setOption(option);
    }

    protected void parseField() {
        List fieldList = Fields.getFieldsByCache(this.targetClass);
        List methodList = Methods.getSetterMethodsByCache(this.targetClass);
        this.setters = methodList.stream().collect(Collectors.toMap(Fields::getFieldNameByMethod, Function.identity()));
        for (Field field : fieldList) {
            this.parseColumn((ImportField)Annotations.getAnnotation((Field)field, ImportField.class), (ImportIgnore)Annotations.getAnnotation((Field)field, ImportIgnore.class), Methods.getGetterMethodByField(this.targetClass, (Field)field), field.getName());
        }
        for (Method method : methodList) {
            this.parseColumn((ImportField)Annotations.getAnnotation((Method)method, ImportField.class), (ImportIgnore)Annotations.getAnnotation((Method)method, ImportIgnore.class), method, null);
        }
    }

    protected void parseColumn(ImportField field, ImportIgnore ignore, Method method, String fieldName) {
        if (field == null || ignore != null) {
            return;
        }
        if (method == null) {
            throw Exceptions.parse((String)("not found " + fieldName + "setter method"));
        }
        int index = field.value();
        if (fieldName == null) {
            this.mapping.put(index, Fields.getFieldNameByMethod((Method)method));
        } else {
            this.mapping.put(index, fieldName);
        }
    }
}

