/*
 * Decompiled with CFR 0.152.
 */
package com.orion.office.csv.reader;

import com.orion.lang.define.wrapper.Pair;
import com.orion.lang.utils.Valid;
import com.orion.office.csv.core.CsvReader;
import com.orion.office.csv.reader.BaseCsvReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class CsvLambdaReader<T>
extends BaseCsvReader<T> {
    protected final Map<Integer, Pair<Function<String, ?>, BiConsumer<T, ?>>> mapping;
    protected final Supplier<T> supplier;
    protected boolean nullInvoke;

    public CsvLambdaReader(CsvReader reader, Supplier<T> supplier) {
        this(reader, new ArrayList(), null, supplier);
    }

    public CsvLambdaReader(CsvReader reader, Collection<T> rows, Supplier<T> supplier) {
        this(reader, rows, null, supplier);
    }

    public CsvLambdaReader(CsvReader reader, Consumer<T> consumer, Supplier<T> supplier) {
        this(reader, null, consumer, supplier);
    }

    protected CsvLambdaReader(CsvReader reader, Collection<T> rows, Consumer<T> consumer, Supplier<T> supplier) {
        super(reader, rows, consumer);
        this.supplier = (Supplier)Valid.notNull(supplier, (String)"supplier is null", (Object[])new Object[0]);
        this.mapping = new TreeMap();
    }

    public CsvLambdaReader<T> nullInvoke() {
        this.nullInvoke = true;
        return this;
    }

    public CsvLambdaReader<T> mapping(int column, BiConsumer<T, String> consumer) {
        this.mapping.put(column, Pair.of(Function.identity(), consumer));
        return this;
    }

    public <V> CsvLambdaReader<T> mapping(int column, Function<String, V> convert, BiConsumer<T, V> consumer) {
        this.mapping.put(column, Pair.of(convert, consumer));
        return this;
    }

    @Override
    protected T parserRow(String[] row) {
        T current = this.supplier.get();
        this.mapping.forEach((? super K k, ? super V v) -> {
            String value = this.get(row, (int)k);
            if (value != null || this.nullInvoke) {
                Function convert = (Function)v.getKey();
                BiConsumer consumer = (BiConsumer)v.getValue();
                Object val = convert.apply(value);
                consumer.accept(current, val);
            }
        });
        return current;
    }
}

