/*
 * Decompiled with CFR 0.152.
 */
package com.orion.office.excel;

import com.monitorjbl.xlsx.impl.StreamingWorkbook;
import com.orion.lang.able.SafeCloseable;
import com.orion.lang.define.collect.MutableMap;
import com.orion.lang.utils.Valid;
import com.orion.lang.utils.io.Files1;
import com.orion.lang.utils.io.Streams;
import com.orion.office.excel.Excels;
import com.orion.office.excel.reader.ExcelArrayReader;
import com.orion.office.excel.reader.ExcelBeanReader;
import com.orion.office.excel.reader.ExcelLambdaReader;
import com.orion.office.excel.reader.ExcelMapReader;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelExt
implements SafeCloseable {
    private final Workbook workbook;

    public ExcelExt(File file) {
        this(Files1.openInputStreamSafe((File)file), null, false, true);
    }

    public ExcelExt(File file, boolean streaming) {
        this(Files1.openInputStreamSafe((File)file), null, streaming, true);
    }

    public ExcelExt(File file, String password) {
        this(Files1.openInputStreamSafe((File)file), password, false, true);
    }

    public ExcelExt(File file, String password, boolean streaming) {
        this(Files1.openInputStreamSafe((File)file), password, streaming, true);
    }

    public ExcelExt(String file) {
        this(Files1.openInputStreamSafe((String)file), null, false, true);
    }

    public ExcelExt(String file, boolean streaming) {
        this(Files1.openInputStreamSafe((String)file), null, streaming, true);
    }

    public ExcelExt(String file, String password) {
        this(Files1.openInputStreamSafe((String)file), password, false, true);
    }

    public ExcelExt(String file, String password, boolean streaming) {
        this(Files1.openInputStreamSafe((String)file), password, streaming, true);
    }

    public ExcelExt(InputStream in) {
        this(in, null, false, false);
    }

    public ExcelExt(InputStream in, boolean streaming) {
        this(in, null, streaming, false);
    }

    public ExcelExt(InputStream in, String password) {
        this(in, password, false, false);
    }

    public ExcelExt(InputStream in, String password, boolean streaming) {
        this(in, password, streaming, false);
    }

    public ExcelExt(InputStream in, String password, boolean streaming, boolean close) {
        this.workbook = streaming ? Excels.openStreamingWorkbook(in, password) : Excels.openWorkbook(in, password);
        Valid.notNull((Object)this.workbook, (String)"workbook is null", (Object[])new Object[0]);
        if (close) {
            Streams.close((AutoCloseable)in);
        }
    }

    public ExcelExt(Workbook workbook) {
        Valid.notNull((Object)workbook, (String)"workbook is null", (Object[])new Object[0]);
        this.workbook = workbook;
    }

    public ExcelArrayReader arrayReader(int sheetIndex) {
        return this.arrayReader(this.workbook.getSheetAt(sheetIndex), new ArrayList<String[]>(), null);
    }

    public ExcelArrayReader arrayReader(String sheetName) {
        return this.arrayReader(this.workbook.getSheet(sheetName), new ArrayList<String[]>(), null);
    }

    public ExcelArrayReader arrayReader(int sheetIndex, List<String[]> rows) {
        return this.arrayReader(this.workbook.getSheetAt(sheetIndex), rows, null);
    }

    public ExcelArrayReader arrayReader(String sheetName, List<String[]> rows) {
        return this.arrayReader(this.workbook.getSheet(sheetName), rows, null);
    }

    public ExcelArrayReader arrayReader(int sheetIndex, Consumer<String[]> consumer) {
        return this.arrayReader(this.workbook.getSheetAt(sheetIndex), null, consumer);
    }

    public ExcelArrayReader arrayReader(String sheetName, Consumer<String[]> consumer) {
        return this.arrayReader(this.workbook.getSheet(sheetName), null, consumer);
    }

    private ExcelArrayReader arrayReader(Sheet sheet, List<String[]> rows, Consumer<String[]> consumer) {
        if (rows != null) {
            return new ExcelArrayReader(this.workbook, sheet, rows);
        }
        return new ExcelArrayReader(this.workbook, sheet, consumer);
    }

    public <K, V> ExcelMapReader<K, V> mapReader(int sheetIndex) {
        return this.mapReader(this.workbook.getSheetAt(sheetIndex), new ArrayList<MutableMap<K, V>>(), null);
    }

    public <K, V> ExcelMapReader<K, V> mapReader(String sheetName) {
        return this.mapReader(this.workbook.getSheet(sheetName), new ArrayList<MutableMap<K, V>>(), null);
    }

    public <K, V> ExcelMapReader<K, V> mapReader(int sheetIndex, List<MutableMap<K, V>> rows) {
        return this.mapReader(this.workbook.getSheetAt(sheetIndex), rows, null);
    }

    public <K, V> ExcelMapReader<K, V> mapReader(String sheetName, List<MutableMap<K, V>> rows) {
        return this.mapReader(this.workbook.getSheet(sheetName), rows, null);
    }

    public <K, V> ExcelMapReader<K, V> mapReader(int sheetIndex, Consumer<MutableMap<K, V>> consumer) {
        return this.mapReader(this.workbook.getSheetAt(sheetIndex), null, consumer);
    }

    public <K, V> ExcelMapReader<K, V> mapReader(String sheetName, Consumer<MutableMap<K, V>> consumer) {
        return this.mapReader(this.workbook.getSheet(sheetName), null, consumer);
    }

    private <K, V> ExcelMapReader<K, V> mapReader(Sheet sheet, List<MutableMap<K, V>> rows, Consumer<MutableMap<K, V>> consumer) {
        if (rows != null) {
            return new ExcelMapReader<K, V>(this.workbook, sheet, rows);
        }
        return new ExcelMapReader<K, V>(this.workbook, sheet, consumer);
    }

    public <T> ExcelBeanReader<T> beanReader(int sheetIndex, Class<T> targetClass) {
        return this.beanReader(this.workbook.getSheetAt(sheetIndex), targetClass, new ArrayList(), null);
    }

    public <T> ExcelBeanReader<T> beanReader(String sheetName, Class<T> targetClass) {
        return this.beanReader(this.workbook.getSheet(sheetName), targetClass, new ArrayList(), null);
    }

    public <T> ExcelBeanReader<T> beanReader(int sheetIndex, Class<T> targetClass, List<T> rows) {
        return this.beanReader(this.workbook.getSheetAt(sheetIndex), targetClass, rows, null);
    }

    public <T> ExcelBeanReader<T> beanReader(String sheetName, Class<T> targetClass, List<T> rows) {
        return this.beanReader(this.workbook.getSheet(sheetName), targetClass, rows, null);
    }

    public <T> ExcelBeanReader<T> beanReader(int sheetIndex, Class<T> targetClass, Consumer<T> consumer) {
        return this.beanReader(this.workbook.getSheetAt(sheetIndex), targetClass, null, consumer);
    }

    public <T> ExcelBeanReader<T> beanReader(String sheetName, Class<T> targetClass, Consumer<T> consumer) {
        return this.beanReader(this.workbook.getSheet(sheetName), targetClass, null, consumer);
    }

    private <T> ExcelBeanReader<T> beanReader(Sheet sheet, Class<T> targetClass, List<T> rows, Consumer<T> consumer) {
        if (rows != null) {
            return new ExcelBeanReader<T>(this.workbook, sheet, targetClass, rows);
        }
        return new ExcelBeanReader<T>(this.workbook, sheet, targetClass, consumer);
    }

    public <T> ExcelLambdaReader<T> lambdaReader(int sheetIndex, Supplier<T> supplier) {
        return this.lambdaReader(this.workbook.getSheetAt(sheetIndex), new ArrayList(), null, supplier);
    }

    public <T> ExcelLambdaReader<T> lambdaReader(String sheetName, Supplier<T> supplier) {
        return this.lambdaReader(this.workbook.getSheet(sheetName), new ArrayList(), null, supplier);
    }

    public <T> ExcelLambdaReader<T> lambdaReader(int sheetIndex, List<T> rows, Supplier<T> supplier) {
        return this.lambdaReader(this.workbook.getSheetAt(sheetIndex), rows, null, supplier);
    }

    public <T> ExcelLambdaReader<T> lambdaReader(String sheetName, List<T> rows, Supplier<T> supplier) {
        return this.lambdaReader(this.workbook.getSheet(sheetName), rows, null, supplier);
    }

    public <T> ExcelLambdaReader<T> lambdaReader(int sheetIndex, Consumer<T> consumer, Supplier<T> supplier) {
        return this.lambdaReader(this.workbook.getSheetAt(sheetIndex), null, consumer, supplier);
    }

    public <T> ExcelLambdaReader<T> lambdaReader(String sheetName, Consumer<T> consumer, Supplier<T> supplier) {
        return this.lambdaReader(this.workbook.getSheet(sheetName), null, consumer, supplier);
    }

    private <T> ExcelLambdaReader<T> lambdaReader(Sheet sheet, List<T> rows, Consumer<T> consumer, Supplier<T> supplier) {
        if (rows != null) {
            return new ExcelLambdaReader<T>(this.workbook, sheet, rows, supplier);
        }
        return new ExcelLambdaReader<T>(this.workbook, sheet, consumer, supplier);
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public boolean isStreaming() {
        return this.workbook instanceof StreamingWorkbook;
    }

    public void close() {
        Streams.close((AutoCloseable)this.workbook);
    }
}

